/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.FinanceNatureTypeEnum;
import kd.tmc.tda.common.enums.FinanceStatisticTypeEnum;
import kd.tmc.tda.common.helper.FinanceInterestBearLiaDisDatahelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceInterestBearLiaDisHelper;
import org.apache.commons.lang.StringUtils;

public class FinanceInterestBearLiaDisDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String DATARANGE = "datarange";
    private static final String ORG_NAME = "org_name";
    private static final String ISOFFSET = "isoffset";
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("onemonth", "threemonth", "sixmonth", "oneyear", "twoyear", "threeyear", "fouryear", "fiveyear", "sixyear", "sevenyear", "eightyear", "nineyear", "thenyear", "overtenyear", "overtime");
    private static final String STATISTICS_TYPE = "statisticsType";

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        String financingnature;
        String statType;
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet ds = FinanceInterestBearLiaDisDatahelper.getInterstBearLiaDisDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (DataSet)orgDateSet.copy());
        String displayType = (String)paramMap.get(STATISTICS_TYPE);
        if (StringUtils.isEmpty((String)displayType)) {
            statType = FinanceStatisticTypeEnum.ALL.getValue();
            financingnature = FinanceNatureTypeEnum.ALL.getValue();
        } else {
            String[] displayStrs = displayType.split(",");
            statType = displayStrs[0];
            financingnature = displayStrs[1];
        }
        if (StringUtils.isEmpty((String)statType)) {
            statType = FinanceStatisticTypeEnum.ALL.getValue();
        }
        if (StringUtils.isEmpty((String)financingnature)) {
            financingnature = FinanceNatureTypeEnum.ALL.getValue();
        }
        DataSet afterChooseTypeSet = FinanceInterestBearLiaDisHelper.dealStartintdateByType(ds.filter("isequity = false"), queryDate, statType);
        if (FinanceNatureTypeEnum.IN.getValue().equals(financingnature)) {
            afterChooseTypeSet = afterChooseTypeSet.filter("isoutgroup = 0");
        }
        if (FinanceNatureTypeEnum.OUT.getValue().equals(financingnature)) {
            afterChooseTypeSet = afterChooseTypeSet.filter("isoutgroup = 1");
        }
        afterChooseTypeSet = afterChooseTypeSet.select("org,residueterm,exrepaymentdate,expiredate,startintdate,repayamount,repayamount as count,rowoffset,coloffset,'' as datarange,0 as order,perpetualbond");
        DataSet allDataSet = FinanceInterestBearLiaDisHelper.getDataByResidueterm(afterChooseTypeSet, paramMap, false);
        DataSet[] avgTermDs = FinanceInterestBearLiaDisHelper.dealDayNum(allDataSet.copy(), queryDate, orgDateSet.copy());
        allDataSet = allDataSet.updateField("count", "repayamount + rowoffset").addField("'0'", ISOFFSET);
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        DataSet colOffsetDs = allDataSet.copy().filter("coloffset < 0").updateField("count", "coloffset").updateField("org", ((DynamicObject)parentOrgs.get(0)).getString("id")).updateField(ISOFFSET, "'1'");
        String selectStr = "org,count,datarange,order,isoffset";
        DataSet unionSet = allDataSet.union(colOffsetDs).select(selectStr);
        unionSet = FinanceInterestBearLiaDisHelper.addZeroDataRange(unionSet.select(selectStr), FinanceStatisticTypeEnum.MONTH, ((Object)((Object)this)).getClass().getName(), queryDate, orgId);
        unionSet = DecisionAnlsHelper.ChangeRowToColDataSet(unionSet, DATARANGE, "org,datarange,isoffset", "").groupBy(new String[]{"org", ISOFFSET}).sum("onemonth").sum("threemonth").sum("sixmonth").sum("oneyear").sum("twoyear").sum("threeyear").sum("fouryear").sum("fiveyear").sum("sixyear").sum("sevenyear").sum("eightyear").sum("nineyear").sum("thenyear").sum("overtenyear").sum("overtime").finish();
        DataSet leftJoinSet = orgDateSet.leftJoin(unionSet).on("org", "org").select(new String[]{"rowid", "pid", "isgroupnode", "level", "mixorgname as org_name", "sortcode"}, unionSet.getRowMeta().getFieldNames()).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinSet.copy().filter("isoffset != '1'"), AMOUNT_FIELDS, "org_name,sortcode");
        String[] sumDataSetFields = sumDataSet.getRowMeta().getFieldNames();
        sumDataSet = sumDataSet.leftJoin(avgTermDs[0]).on("rowid", "rowid").select(sumDataSetFields, new String[]{"avgterm"}).finish();
        DataSet offsetDataSet = leftJoinSet.filter("isoffset = '1'").updateField(ORG_NAME, ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"FinanceInterestBearLiaDisDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])).updateFields(new String[]{"rowid", "isgroupnode"}, new String[]{"-1", "'0'"});
        offsetDataSet = offsetDataSet.addField("0", "avgterm");
        sumDataSet = sumDataSet.union(offsetDataSet.select(sumDataSet.getRowMeta().getFieldNames()));
        sumDataSet = sumDataSet.addFields(new String[]{StringUtils.join(AMOUNT_FIELDS, (String)"+"), "rowid"}, new String[]{"total", "orgid"});
        List filterOrg = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)filterOrg)) {
            filterOrg = (List)paramMap.get("allorgids");
        }
        DataSet offSetData = sumDataSet.copy().filter("rowid = -1");
        if (CollectionUtils.isNotEmpty((Collection)filterOrg)) {
            sumDataSet = sumDataSet.filter("(rowid in secondOrgIds) and total > 0", Collections.singletonMap("secondOrgIds", filterOrg));
        }
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"}).union(offSetData);
        ArrayList<String> sumList = new ArrayList<String>(AMOUNT_FIELDS);
        sumList.add("total");
        DataSet sDataSet = DecisionAnlsHelper.addAllTotalDataSet(sumDataSet, sumList, ORG_NAME);
        BigDecimal totalAvgTerm = BigDecimal.ZERO;
        DataSet otalAvgDs = avgTermDs[2];
        while (otalAvgDs.hasNext()) {
            totalAvgTerm = otalAvgDs.next().getBigDecimal("avgterm");
        }
        sDataSet = sDataSet.updateField("avgterm", totalAvgTerm.toPlainString());
        sumDataSet = sumDataSet.union(sDataSet);
        return sumDataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List<String> dataRangeList = FinanceInterestBearLiaDisHelper.getDataRangeList(false);
        List<String> dataRangeChineseList = FinanceInterestBearLiaDisHelper.getDataRangeList(true);
        int indexOfOverTime = dataRangeList.size() - 1;
        columns.add((AbstractReportColumn)this.createReportColumn(dataRangeList.get(indexOfOverTime), dataRangeChineseList.get(indexOfOverTime)));
        for (int i = 0; i < dataRangeList.size(); ++i) {
            if (i == indexOfOverTime) continue;
            columns.add((AbstractReportColumn)this.createReportColumn(dataRangeList.get(i), dataRangeChineseList.get(i)));
        }
        columns.add((AbstractReportColumn)this.createReportColumn("total", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"FinanceInterestBearLiaDisDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0])));
        columns.add((AbstractReportColumn)this.createReportColumn("avgterm", ResManager.loadKDString((String)"\u5e73\u5747\u5230\u671f\u671f\u9650\uff08\u5e74\uff09", (String)"FinanceInterestBearLiaDisDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])));
        return columns;
    }

    private ReportColumn createReportColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setZeroShow(true);
        reportColumn.setScale(2);
        reportColumn.setCaption(new LocaleString(caption));
        return reportColumn;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(AMOUNT_FIELDS);
        fields.add("total");
        return fields;
    }
}

