/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.report.ReportList;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.FinanceInterestBearLiaDisDatahelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceTermDetailPlugin
extends AbstractDetailDataPlugin {
    @Override
    protected List<Object[]> getColumnItems() {
        ArrayList<Object[]> field = new ArrayList<Object[]>(40);
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u501f\u6b3e\u4eba/\u53d1\u884c\u4eba", (String)"FinanceTermDetailPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"FinanceTermDetailPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"contractno", ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"FinanceTermDetailPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"contractname", ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"FinanceTermDetailPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"financetype1", ResManager.loadKDString((String)"\u878d\u8d44\u7c7b\u578b", (String)"FinanceTermDetailPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("bank", ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e", (String)"FinanceTermDetailPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "bond", ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"FinanceTermDetailPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "company", ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"FinanceTermDetailPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "other", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceTermDetailPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"loantype", ResManager.loadKDString((String)"\u8d37\u6b3e\u7c7b\u578b", (String)"FinanceTermDetailPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("loan", ResManager.loadKDString((String)"\u666e\u901a\u8d37\u6b3e", (String)"FinanceTermDetailPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "sl", ResManager.loadKDString((String)"\u94f6\u56e2\u8d37\u6b3e", (String)"FinanceTermDetailPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "ec", ResManager.loadKDString((String)"\u4f01\u4e1a\u5f80\u6765", (String)"FinanceTermDetailPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "entrust", ResManager.loadKDString((String)"\u59d4\u6258\u8d37\u6b3e", (String)"FinanceTermDetailPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "bond", ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"FinanceTermDetailPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "lease", ResManager.loadKDString((String)"\u878d\u8d44\u79df\u8d41", (String)"FinanceTermDetailPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"creditortype", ResManager.loadKDString((String)"\u503a\u6743\u4eba\u7c7b\u578b", (String)"FinanceTermDetailPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("innerunit", ResManager.loadKDString((String)"\u5185\u90e8\u5355\u4f4d", (String)"FinanceTermDetailPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "bank", ResManager.loadKDString((String)"\u94f6\u884c", (String)"FinanceTermDetailPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "finorg", ResManager.loadKDString((String)"\u975e\u94f6\u884c\u91d1\u878d\u673a\u6784", (String)"FinanceTermDetailPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "settlecenter", ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3", (String)"FinanceTermDetailPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), "fincom", "", "custom", ResManager.loadKDString((String)"\u5ba2\u5546", (String)"FinanceTermDetailPlugin_21", (String)"tmc-tda-report", (Object[])new Object[0]), "other", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceTermDetailPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"bankcatename", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"FinanceTermDetailPlugin_39", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"textcreditor", ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"FinanceTermDetailPlugin_40", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"isoutgroup1", ResManager.loadKDString((String)"\u8d37\u6b3e\u6027\u8d28", (String)"FinanceTermDetailPlugin_23", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("in", ResManager.loadKDString((String)"\u96c6\u56e2\u5185", (String)"FinanceTermDetailPlugin_24", (String)"tmc-tda-report", (Object[])new Object[0]), "out", ResManager.loadKDString((String)"\u96c6\u56e2\u5916", (String)"FinanceTermDetailPlugin_25", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"FinanceTermDetailPlugin_26", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"FinanceTermDetailPlugin_27", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"srcdrawamount", ResManager.loadKDString((String)"\u501f\u6b3e/\u53d1\u884c\u91d1\u989d", (String)"FinanceTermDetailPlugin_28", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"drawamount", ResManager.loadKDString((String)"\u501f\u6b3e/\u53d1\u884c\u91d1\u989d\u6298\u672c\u4f4d\u5e01", (String)"FinanceTermDetailPlugin_29", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"srcrepayamount", ResManager.loadKDString((String)"\u9884\u8ba1\u8fd8\u672c\u91d1", (String)"FinanceTermDetailPlugin_30", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"repayamount", ResManager.loadKDString((String)"\u9884\u8ba1\u8fd8\u672c\u91d1\u6298\u672c\u4f4d\u5e01", (String)"FinanceTermDetailPlugin_31", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"exrepaymentdate", ResManager.loadKDString((String)"\u9884\u8ba1\u8fd8\u6b3e\u65e5\u671f", (String)"FinanceTermDetailPlugin_32", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"residueterm", ResManager.loadKDString((String)"\u5269\u4f59\u671f\u9650", (String)"FinanceTermDetailPlugin_33", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"startintdate", ResManager.loadKDString((String)"\u8d77\u606f\u65e5", (String)"FinanceTermDetailPlugin_34", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"expiredate", ResManager.loadKDString((String)"\u5230\u671f\u65e5", (String)"FinanceTermDetailPlugin_35", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"loanrate", ResManager.loadKDString((String)"\u6700\u65b0\u5229\u7387", (String)"FinanceTermDetailPlugin_36", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"isoffset", ResManager.loadKDString((String)"\u662f\u5426\u62b5\u6d88", (String)"FinanceTermDetailPlugin_37", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = FinanceInterestBearLiaDisDatahelper.getInterstBearLiaDisDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, null).filter("isequity=false").select("id, billno, org orgname, org company, financetype, creditortype, currencyname, drawamount, startintdate, expiredate, residueterm,repayamount, perpetualbond, loantype, exrepaymentdate, loanrate, isoutgroup, contractno, contractname, bankcatename, textcreditor,rowoffset, coloffset ,rate, srcdrawamount, srcrepayamount, repayamount isoffset_repayamount");
        ds = ds.addFields(new String[]{"case when isoutgroup = 0 then 'in' else 'out' end", "case when rowoffset = 0.0 and coloffset = 0.0 then 0 else 1 end", "case when financetype = 0 then 'bank' else case when financetype = 1 then 'bond' else case when financetype = 2 then 'company' else 'other' end end end"}, new String[]{"isoutgroup1", "isoffset", "financetype1"});
        String residueTermStr = String.format("case when residueterm='-1d' then '%s' else residueterm end", ResManager.loadKDString((String)"\u903e\u671f", (String)"FinanceTermDetailPlugin_38", (String)"tmc-tda-report", (Object[])new Object[0]));
        ds = ds.updateFields(new String[]{"drawamount", "repayamount", "residueterm"}, new String[]{"case when isoffset = 1 then 0.0 else drawamount end", "case when isoffset = 1 then 0.0 else repayamount end", residueTermStr});
        return ds;
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("repayamount", "isoffset_repayamount");
    }

    @Override
    protected Set<String> getCovertList() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("drawamount");
        return set;
    }

    @Override
    protected List<String> getOrderByList() {
        return Arrays.asList("financetype1", "billno", "contractno", "textcreditor", "exrepaymentdate");
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("billno", "id");
        map.put("contractno", "id");
        return map;
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        Function<HyperLinkClickEvent, String> hyperLinkFunction = hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String loantype = rowData.getString("loantype");
            String linkEntity = "cfm_loanbill";
            if ("loan".equals(loantype) || "sl".equals(loantype)) {
                linkEntity = "cfm_loanbill_b_l";
            } else if ("ec".equals(loantype) || "entrust".equals(loantype)) {
                linkEntity = "cfm_loanbill_e_l";
            } else if ("bond".equals(loantype)) {
                linkEntity = "cfm_loanbill_bond";
            } else if ("lease".equals(loantype)) {
                linkEntity = FinanceDataHelper.getLeaseFormId();
            }
            return linkEntity;
        };
        return hyperLinkFunction;
    }

    @Override
    protected DataSet beforeReturn(DataSet result) {
        return result.updateField("srcrepayamount", "case when rate is null or rate=0 then 0.00 else repayamount/rate end");
    }
}

