/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceingCostAnalsDataHelper;

public class FinanceingCostDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String STAT = "stat";
    private static final String COL_PREFIX = "month_";

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        String displayType = (String)paramMap.get("displayType");
        String searchParam = (String)paramMap.get("param");
        DataSet financeDataSet = FinanceingCostAnalsDataHelper.getMonthData(paramMap, displayType, new String[]{"month", "org"}, searchParam);
        List sumColName = FinanceingCostAnalsDataHelper.getSumRptCols(displayType).stream().map(Pair::getValue0).collect(Collectors.toList());
        Set month = ORM.create().toPlainDynamicObjectCollection(financeDataSet.copy().filter("param = paramval", Collections.singletonMap("paramval", searchParam))).stream().map(r -> r.getInt("month")).collect(Collectors.toSet());
        param.getCustomParam().put("month", month);
        ArrayList<String> allSumColName = new ArrayList<String>(10);
        for (Object col : sumColName) {
            allSumColName.add((String)col + "amount");
            allSumColName.add((String)col + "rateamount");
            allSumColName.add((String)col + "amountcoloffset");
            allSumColName.add((String)col + "rateamountcoloffset");
        }
        List realFieldName = Arrays.stream(financeDataSet.getRowMeta().getFieldNames()).collect(Collectors.toList());
        for (String allSumName : allSumColName) {
            if (realFieldName.contains(allSumName)) continue;
            financeDataSet = financeDataSet.addField("0.0", allSumName);
        }
        DataSet result = DecisionAnlsHelper.ChangeMultRowToColDataSet(financeDataSet, "month", "org", COL_PREFIX, allSumColName);
        List<String> sumField = FinanceingCostDataListPlugin.getSumField(result);
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgviewId);
        List<String> selectField = FinanceingCostDataListPlugin.getSelectField(sumField);
        selectField.add("sortcode");
        DataSet orgJoinSet = orgDateSet.leftJoin(result).on("rowid", "org").select(selectField.toArray(new String[0])).finish();
        return this.getSumDataSetByLevel(orgJoinSet, sumField, "sortcode,orgid,orgname,mixorgname");
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        List<String> sumField;
        Map paramMap = this.transQueryParam(queryParam);
        List subOrgids = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)subOrgids)) {
            subOrgids = (List)paramMap.get("allorgids");
        }
        ds = (sumField = FinanceingCostDataListPlugin.getSumField(ds = ds.filter("orgid in orgidparam", Collections.singletonMap("orgidparam", subOrgids)))).size() > 0 ? ds.addField(String.join((CharSequence)"+", sumField.stream().filter(f -> f.endsWith("avasumamount")).collect(Collectors.toSet())), STAT) : ds.addField("0.0", STAT);
        ds = ds.filter("stat > 0").orderBy(new String[]{"sortcode", "stat desc"});
        String displayType = (String)paramMap.get("displayType");
        List sumColName = FinanceingCostAnalsDataHelper.getSumRptCols(displayType).stream().map(Pair::getValue0).collect(Collectors.toList());
        Set month = (Set)queryParam.getCustomParam().get("month");
        ArrayList<Pair> pairColList = new ArrayList<Pair>(60);
        Iterator iterator = month.iterator();
        while (iterator.hasNext()) {
            int mon = (Integer)iterator.next();
            for (String pageCol : sumColName) {
                String typeRateAmountCol = COL_PREFIX + mon + pageCol + "rateamount";
                String typeAmountCol = COL_PREFIX + mon + pageCol + "amount";
                String typeRateAmountColOffset = COL_PREFIX + mon + pageCol + "rateamountcoloffset";
                String typeAmountColOffset = COL_PREFIX + mon + pageCol + "amountcoloffset";
                String showCol = this.getShowColKey(pageCol, mon);
                String sqlStr = "case when " + typeAmountCol + " = 0 then 0 else " + typeRateAmountCol + " / " + typeAmountCol + " end";
                ds = ds.addField(sqlStr, showCol);
                String sumSqlStr = "case when (" + typeAmountCol + " + " + typeAmountColOffset + ") = 0 then 0 else (" + typeRateAmountCol + " + " + typeRateAmountColOffset + ") / (" + typeAmountCol + " + " + typeAmountColOffset + ") end";
                pairColList.add(new Pair((Object)sumSqlStr, (Object)showCol));
                sumField.add(showCol);
            }
        }
        DataSet totalSet = this.addAllTotalDataSet(ds, sumField, "orgname").updateField("mixorgname", ResManager.loadKDString((String)"'\u96c6\u56e2\u5408\u5e76'", (String)"FinanceingCostDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        for (Pair pair : pairColList) {
            totalSet = totalSet.updateField((String)pair.getValue1(), (String)pair.getValue0());
        }
        return ds.union(totalSet);
    }

    private static List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(10);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(COL_PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private static List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(10);
        selectField.addAll(sumField);
        selectField.addAll(FinanceingCostDataListPlugin.getSelectOrgField());
        return selectField;
    }

    private static List<String> getSelectOrgField() {
        ArrayList<String> selectOrgField = new ArrayList<String>(8);
        selectOrgField.add("orgname");
        selectOrgField.add("mixorgname");
        selectOrgField.add("rowid");
        selectOrgField.add("orgid");
        selectOrgField.add("pid");
        selectOrgField.add("isgroupnode");
        selectOrgField.add("level");
        selectOrgField.add("0 sumlevel");
        return selectOrgField;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map paramMap = this.transQueryParam(this.getQueryParam());
        String displayType = (String)paramMap.get("displayType");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet dateDateSet = FinanceingCostAnalsDataHelper.getDateDateSet(queryDate).orderBy(new String[]{"dateTime"});
        List<Pair<String, String>> sumRptCols = FinanceingCostAnalsDataHelper.getSumRptCols(displayType);
        while (dateDateSet.hasNext()) {
            Row next = dateDateSet.next();
            int month = next.getInteger("month");
            ReportColumnGroup newColGroup = new ReportColumnGroup();
            newColGroup.setFieldKey(COL_PREFIX + month);
            newColGroup.setCaption(new LocaleString(next.getString("dateStr")));
            for (Pair<String, String> coPair : sumRptCols) {
                String caption = (String)coPair.getValue1();
                ReportColumn newCol = new ReportColumn();
                newCol.setFieldKey(this.getShowColKey((String)coPair.getValue0(), month));
                newCol.setFieldType("text");
                newCol.setCaption(new LocaleString(caption));
                newColGroup.getChildren().add(newCol);
            }
            columns.add((AbstractReportColumn)newColGroup);
        }
        return columns;
    }

    private String getShowColKey(String showTypeName, int month) {
        return showTypeName + "_" + month + "_" + "RPTCOLSTR";
    }
}

