/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;

public class FinanceCostByTermFormPlugin
extends AbstractReportFormPlugin {
    private String TERM_PREFIX = "term_";

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            row.getDataEntityType().getProperties().stream().filter(iDataEntityProperty -> iDataEntityProperty.getName().startsWith(this.TERM_PREFIX)).forEach(iDataEntityProperty -> {
                String propertyName = iDataEntityProperty.getName();
                String rateStr = row.getString(propertyName);
                BigDecimal percent = StringUtils.isEmpty((String)rateStr) ? BigDecimal.ZERO : row.getBigDecimal(propertyName);
                row.set(propertyName, (Object)(percent.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%"));
            });
        }
    }
}

