/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.FinanceNatureTypeEnum;
import kd.tmc.tda.common.enums.FinanceStatisticTypeEnum;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceInterestBearLiaDisHelper {
    private static final String DATARANGE = "datarange";
    private static final String ORDER = "order";
    private static final String[] statTypes = new String[]{"all", "month", "year"};
    private static final String[] financeTypes = new String[]{"ALL", "IN", "OUT"};
    public static final String DATA_RANGE_ARRAY = "dataRangeArray";
    public static final String ORDER_ARRAY = "orderArray";

    public static List<String> getDataRangeList(Boolean isChangeChines) {
        if (isChangeChines.booleanValue()) {
            return Arrays.asList(ResManager.loadKDString((String)"1\u4e2a\u6708", (String)"FinanceInterestBearLiaDisHelper_0", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"3\u4e2a\u6708", (String)"FinanceInterestBearLiaDisHelper_1", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"6\u4e2a\u6708", (String)"FinanceInterestBearLiaDisHelper_2", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"1\u5e74", (String)"FinanceInterestBearLiaDisHelper_3", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"2\u5e74", (String)"FinanceInterestBearLiaDisHelper_4", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"3\u5e74", (String)"FinanceInterestBearLiaDisHelper_5", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"4\u5e74", (String)"FinanceInterestBearLiaDisHelper_6", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"5\u5e74", (String)"FinanceInterestBearLiaDisHelper_7", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"6\u5e74", (String)"FinanceInterestBearLiaDisHelper_8", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"7\u5e74", (String)"FinanceInterestBearLiaDisHelper_9", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"8\u5e74", (String)"FinanceInterestBearLiaDisHelper_10", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"9\u5e74", (String)"FinanceInterestBearLiaDisHelper_11", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"10\u5e74", (String)"FinanceInterestBearLiaDisHelper_12", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"10\u5e74\u4ee5\u4e0a", (String)"FinanceInterestBearLiaDisHelper_13", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f", (String)"FinanceInterestBearLiaDisHelper_14", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        return Arrays.asList("onemonth", "threemonth", "sixmonth", "oneyear", "twoyear", "threeyear", "fouryear", "fiveyear", "sixyear", "sevenyear", "eightyear", "nineyear", "thenyear", "overtenyear", "overtime");
    }

    public static DataSet dealStartintdateByType(DataSet allds, Date queryDate, String type) {
        HashMap<String, Date> paramsMap = new HashMap<String, Date>(4);
        if (type.equals(FinanceStatisticTypeEnum.MONTH.getValue())) {
            Date firstDay = DateUtils.getFirstDayOfMonth((Date)queryDate);
            Date lastDay = DateUtils.getLastDayOfMonth((Date)queryDate);
            paramsMap.put("firstDay", firstDay);
            paramsMap.put("lsatDay", lastDay);
            allds = allds.filter("startintdate >= firstDay and startintdate <= lsatDay", paramsMap).updateField("startintdate", "'" + FinanceStatisticTypeEnum.MONTH.getValue() + "'");
        } else if (type.equals(FinanceStatisticTypeEnum.YEAR.getValue())) {
            Date firstDay = DateUtils.getFirstYearDate((Date)queryDate);
            paramsMap.put("firstDay", firstDay);
            paramsMap.put("lsatDay", queryDate);
            allds = allds.filter("startintdate >= firstDay and startintdate <= lsatDay", paramsMap).updateField("startintdate", "'" + FinanceStatisticTypeEnum.YEAR.getValue() + "'");
        }
        return allds;
    }

    public static DataSet addZeroDataRange(DataSet monthDataSet, FinanceStatisticTypeEnum typeEnum, String className, Date queryDate, long orgId) {
        Iterator it = monthDataSet.copy().iterator();
        HashSet<String> dataRangeSet = new HashSet<String>(16);
        while (it.hasNext()) {
            Row row = (Row)it.next();
            dataRangeSet.add(row.getString(DATARANGE));
        }
        RowMeta rowMeta = monthDataSet.getRowMeta();
        List<String> allCurrencyList = FinanceInterestBearLiaDisHelper.getDataRangeList(false);
        int count = 0;
        for (String str : allCurrencyList) {
            if (!dataRangeSet.contains(str)) {
                DataSet creatDataSet = DecisionAnlsHelper.createRow(className, rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{orgId, 0, allCurrencyList.get(count), count, 0}));
                monthDataSet = monthDataSet.union(creatDataSet);
            }
            ++count;
        }
        return monthDataSet;
    }

    public static DataSet getDataByResidueterm(DataSet ds, Map<String, Object> paramMap, boolean isChangeChines) {
        final List<String> dataRangeList = FinanceInterestBearLiaDisHelper.getDataRangeList(isChangeChines);
        paramMap.put(DATA_RANGE_ARRAY, dataRangeList.toArray());
        paramMap.put(ORDER_ARRAY, FinanceInterestBearLiaDisHelper.buildOrderArray(dataRangeList.size()));
        DataSet[] splitDataSet = ds.splitByFilter(new String[]{"perpetualbond = false and residueterm = ''"}, true);
        DataSet overTimeDataSet = splitDataSet[0].updateFields(new String[]{DATARANGE, ORDER}, new String[]{"'" + dataRangeList.get(0) + "'", "0"});
        DataSet allDataSet = splitDataSet[1];
        final RowMeta rowMeta = ds.getRowMeta();
        allDataSet = allDataSet.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                String residueterm = row.getString("residueterm");
                String termType = "-1d".equals(residueterm) ? (String)dataRangeList.get(14) : FinanceInterestBearLiaDisHelper.getDataRangeByResidueterm(residueterm, dataRangeList);
                int order = dataRangeList.indexOf(termType);
                for (String fieldName : rowMeta.getFieldNames()) {
                    if (FinanceInterestBearLiaDisHelper.DATARANGE.equals(fieldName)) {
                        rowInfo.add(termType);
                        continue;
                    }
                    if (FinanceInterestBearLiaDisHelper.ORDER.equals(fieldName)) {
                        rowInfo.add(order);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return allDataSet.union(overTimeDataSet);
    }

    private static String getDataRangeByResidueterm(String residueterm, List<String> dataRangeList) {
        String result;
        boolean isContainMonthDay;
        if (EmptyUtil.isEmpty((String)residueterm)) {
            return dataRangeList.get(13);
        }
        int indexYear = residueterm.indexOf("y");
        int indexMonth = residueterm.indexOf("m");
        int indexDay = residueterm.indexOf("d");
        boolean bl = isContainMonthDay = indexMonth > 0 || indexDay > 0;
        if (indexYear > 0) {
            int year = Integer.parseInt(residueterm.substring(0, indexYear));
            if (year > 10) {
                result = dataRangeList.get(13);
            } else {
                result = dataRangeList.get(year + 3);
                if (!isContainMonthDay) {
                    result = dataRangeList.get(year + 2);
                }
            }
        } else if (indexMonth < 0) {
            result = dataRangeList.get(0);
        } else {
            int month = Integer.parseInt(residueterm.substring(0, indexMonth));
            if (month == 1) {
                result = dataRangeList.get(1);
                if (indexDay < 0) {
                    result = dataRangeList.get(0);
                }
            } else if (month > 1 && month < 3) {
                result = dataRangeList.get(1);
            } else if (month == 3) {
                result = dataRangeList.get(2);
                if (indexDay < 0) {
                    result = dataRangeList.get(1);
                }
            } else if (month > 3 && month < 6) {
                result = dataRangeList.get(2);
            } else if (month == 6) {
                result = dataRangeList.get(3);
                if (indexDay < 0) {
                    result = dataRangeList.get(2);
                }
            } else {
                result = dataRangeList.get(3);
            }
        }
        return result;
    }

    public static DataSet addQingZeroDataRange(DataSet monthDataSet, String className) {
        HashSet<String> dataRangeAndParamSet = new HashSet<String>(16);
        RowMeta rowMeta = monthDataSet.getRowMeta();
        DataSet copyDataSet = monthDataSet.copy();
        while (copyDataSet.hasNext()) {
            Row row = copyDataSet.next();
            String dataRange = row.getString(DATARANGE);
            dataRangeAndParamSet.add(dataRange + ',' + row.getString("param"));
        }
        List<String> allDataRangeList = FinanceInterestBearLiaDisHelper.getDataRangeList(true);
        List<String> allDataAndParamList = FinanceInterestBearLiaDisHelper.getAllDataAndParamList(allDataRangeList);
        for (String str : allDataAndParamList) {
            if (dataRangeAndParamSet.contains(str)) continue;
            String[] dataRangeAndParamStrs = str.split(",");
            String datarange = dataRangeAndParamStrs[0];
            String stat = dataRangeAndParamStrs[1];
            int order = allDataRangeList.indexOf(datarange);
            String financingnature = dataRangeAndParamStrs[2];
            String statname = FinanceStatisticTypeEnum.getNameByValue((String)stat);
            String financingnaturename = FinanceNatureTypeEnum.getNameByValue((String)financingnature);
            DataSet creatDataSet = DecisionAnlsHelper.createRow(className, rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{datarange, 0, order, stat, statname, financingnature, financingnaturename, stat + ',' + financingnature}));
            monthDataSet = monthDataSet.union(creatDataSet);
        }
        return monthDataSet.updateField(ORDER, "case when order=14 then -1 else order end");
    }

    private static List<String> getAllDataAndParamList(List<String> allDataRangeList) {
        ArrayList<String> allDataAndParamList = new ArrayList<String>(128);
        for (String dataRange : allDataRangeList) {
            for (String statType : statTypes) {
                for (String financeType : financeTypes) {
                    allDataAndParamList.add(dataRange + ',' + statType + ',' + financeType);
                }
            }
        }
        return allDataAndParamList;
    }

    private static int[] buildOrderArray(int size) {
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static DataSet[] dealDayNum(DataSet detailData, final Date queryDate, DataSet orgDataSet) {
        detailData = detailData.addFields(new String[]{"0", "repayamount"}, new String[]{"days", "avgrepayamout"});
        final RowMeta rowMeta = detailData.getRowMeta();
        detailData = detailData.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                Date exRepaymentDate = row.getDate("exrepaymentdate");
                int daysIndex = rowMeta.getFieldIndex("days", false);
                if (EmptyUtil.isEmpty((Object)exRepaymentDate)) {
                    data[daysIndex] = 1;
                } else {
                    int days = DateUtils.getDiffDays((Date)queryDate, (Date)exRepaymentDate);
                    if (days <= 0) {
                        days = 1;
                    }
                    data[daysIndex] = days;
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        detailData = detailData.addField("days * avgrepayamout", "dmavgrepayamout");
        DataSet[] splitDataSet = detailData.splitByFilter(new String[]{"rowoffset = 0 and perpetualbond = false", "coloffset < 0 and perpetualbond = false", "rowoffset = 0 and coloffset = 0 and perpetualbond = false"}, false);
        DataSet sumData = splitDataSet[0].groupBy(new String[]{"org"}).sum("dmavgrepayamout").sum("avgrepayamout").finish();
        DataSet leftJoinSet = orgDataSet.leftJoin(sumData).on("org", "org").select(new String[]{"rowid", "pid", "isgroupnode", "level", "mixorgname as org_name", "sortcode"}, sumData.getRowMeta().getFieldNames()).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinSet, Arrays.asList("dmavgrepayamout", "avgrepayamout"), "").select("rowid,case when avgrepayamout = 0 or avgrepayamout is null then 0 else dmavgrepayamout/(avgrepayamout*365) end as avgterm ");
        DataSet offsetData = splitDataSet[1].groupBy().sum("dmavgrepayamout").sum("avgrepayamout").finish().select("case when avgrepayamout = 0 or avgrepayamout is null  then 0 else dmavgrepayamout/(avgrepayamout*365) end  as avgterm ");
        DataSet total = splitDataSet[2].groupBy().sum("dmavgrepayamout").sum("avgrepayamout").finish().select("case when avgrepayamout = 0 or avgrepayamout is null  then 0 else dmavgrepayamout/(avgrepayamout*365) end as avgterm ");
        return new DataSet[]{sumDataSet, offsetData, total};
    }
}

