/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.enums.FinanceCostTermEnum;
import kd.tmc.tda.common.helper.FinanceCostDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceCostByTermDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AVGBALANCE = "avgbalance";
    private static final String INTEREST = "interest";
    private static final String CUSTOMTYPE = "customtype";
    private String TERM = "term";
    private String FINANCE_COST = "financeCost";
    private String DATE_RANGE = "dateRange";
    private String DATE_TYPE = "datetype";
    private String DATE = "date";
    private Integer AVG_TERM = 999;

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{this.TERM, ResManager.loadKDString((String)"\u671f\u9650\u7c7b\u578b", (String)"FinanceCostByTermDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{this.DATE, ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"FinanceCostByTermDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{this.DATE_RANGE, ResManager.loadKDString((String)"\u4e0b\u62c9\u6846\u8303\u56f4", (String)"FinanceCostByTermDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{this.FINANCE_COST, ResManager.loadKDString((String)"\u878d\u8d44\u6210\u672c", (String)"FinanceCostByTermDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List queryDateList = FinanceCostDateHelper.getAllQueryDateList((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        DataSet financeCostDataSet = FinanceCostDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), allorgids, (Date)DecisionAnlsHelper.getQueryDate(paramMap), (Long)baseCurrency, (Long)orgViewId, (Long)0L, (List)queryDateList);
        financeCostDataSet = financeCostDataSet.select("creditorinnerorg,customtype,term,datetype,avgbalance,interest");
        financeCostDataSet = financeCostDataSet.filter("creditorinnerorg not in allorgids", Collections.singletonMap("allorgids", allorgids));
        financeCostDataSet = this.dealTermDataSet(financeCostDataSet);
        financeCostDataSet = financeCostDataSet.groupBy(new String[]{this.DATE_TYPE, this.TERM, CUSTOMTYPE}).sum(AVGBALANCE).sum(INTEREST).finish();
        financeCostDataSet = financeCostDataSet.select(new String[]{this.DATE_TYPE, this.TERM, "customtype as " + this.DATE_RANGE, AVGBALANCE, INTEREST});
        DataSet[] copyDs = DataSetHelper.copy((DataSet)financeCostDataSet, (int)2);
        DataSet termDataSet = copyDs[0];
        DataSet weightedAverageSet = copyDs[1].groupBy(new String[]{this.DATE_TYPE, this.DATE_RANGE}).sum(AVGBALANCE).sum(INTEREST).finish().select(new String[]{this.DATE_TYPE, "'" + this.AVG_TERM + "' as " + this.TERM, this.DATE_RANGE, AVGBALANCE, INTEREST});
        DataSet tempDataSet = termDataSet.union(weightedAverageSet);
        DataSet resultDataSet = tempDataSet.addField("case when interest is null or interest = 0.0 or avgbalance is null or avgbalance = 0.0 then 0.0 else interest * 1.0 / avgbalance end", this.FINANCE_COST);
        resultDataSet = resultDataSet.select(new String[]{this.DATE_TYPE, this.TERM, this.DATE_RANGE, this.FINANCE_COST});
        resultDataSet = this.createAbsentRow(resultDataSet).addFields(new String[]{"''", "term"}, new String[]{this.DATE, "termnum"});
        resultDataSet = this.updateFields(resultDataSet, queryDate);
        return resultDataSet.select(new String[]{this.TERM, "termnum", this.DATE, this.DATE_RANGE, this.FINANCE_COST});
    }

    private DataSet dealTermDataSet(DataSet financeCostDataSet) {
        final RowMeta rowMeta = financeCostDataSet.getRowMeta();
        return financeCostDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String term = row.getString(FinanceCostByTermDataPlugin.this.TERM);
                int termIndex = rowMeta.getFieldIndex(FinanceCostByTermDataPlugin.this.TERM, false);
                FinanceCostTermEnum financeCostTermEnum = FinanceCostTermEnum.matchExp((String)term);
                data[termIndex] = String.valueOf(financeCostTermEnum.getIndex());
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    private DataSet updateFields(DataSet financeCostDataSet, final Date queryDate) {
        final RowMeta rowMeta = financeCostDataSet.getRowMeta();
        return financeCostDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                Integer dateType = row.getInteger(FinanceCostByTermDataPlugin.this.DATE_TYPE);
                int dateIndex = rowMeta.getFieldIndex(FinanceCostByTermDataPlugin.this.DATE, false);
                String dateRange = row.getString(FinanceCostByTermDataPlugin.this.DATE_RANGE);
                DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
                int diff = dateRangeEnum.getEnd() - dateType;
                String dateCaption = FinanceCostDateHelper.getDateCaption((Date)FinanceCostDateHelper.getNewDate((Date)queryDate), (String)dateRange, (String)dateRangeEnum.getShortName(), (int)diff);
                data[dateIndex] = dateCaption;
                Integer term = row.getInteger(FinanceCostByTermDataPlugin.this.TERM);
                int termIndex = rowMeta.getFieldIndex(FinanceCostByTermDataPlugin.this.TERM, false);
                FinanceCostTermEnum financeCostTermEnum = FinanceCostTermEnum.getEnumByIndex((Integer)term);
                String description = financeCostTermEnum.getText().getDescription();
                String resourceID = financeCostTermEnum.getText().getResourceID();
                String columnCaption = ResManager.loadKDString((String)description, (String)resourceID, (String)financeCostTermEnum.getText().getSystemType(), (Object[])new Object[0]);
                if (FinanceCostByTermDataPlugin.this.AVG_TERM.equals(term)) {
                    columnCaption = ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceCostTermEnum_6", (String)financeCostTermEnum.getText().getSystemType(), (Object[])new Object[0]);
                }
                data[termIndex] = columnCaption;
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    private DataSet createAbsentRow(DataSet dataSet) {
        DataSet[] copyDs = DataSetHelper.copy((DataSet)dataSet, (int)2);
        dataSet = copyDs[0];
        ArrayList<Object[]> collection = new ArrayList<Object[]>(2);
        Set<String> allRowKeys = this.getAllRowKeys();
        Set<String> existsRowKeys = this.getExistsRowKeys(copyDs[1]);
        HashSet<String> absentRowKeys = new HashSet<String>(allRowKeys.size());
        for (String string : allRowKeys) {
            if (existsRowKeys.contains(string.substring(0, string.lastIndexOf("_")))) continue;
            absentRowKeys.add(string);
        }
        if (EmptyUtil.isNoEmpty(absentRowKeys)) {
            RowMeta rowMeta = dataSet.getRowMeta();
            for (String string : absentRowKeys) {
                String[] splitKey = string.split("_");
                collection.add(new Object[]{splitKey[0], splitKey[1], splitKey[2], "0.0"});
            }
            DataSet dataSet2 = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), collection);
            dataSet = dataSet.union(dataSet2);
        }
        dataSet = dataSet.orderBy(new String[]{this.DATE_TYPE, this.TERM});
        return dataSet;
    }

    private Set<String> getExistsRowKeys(DataSet dataSet) {
        HashSet<String> exists = new HashSet<String>(256);
        for (Row next : dataSet) {
            String dateType = next.getString(this.DATE_TYPE);
            String termIndex = next.getString(this.TERM);
            String rowKey = dateType + "_" + termIndex;
            exists.add(rowKey);
        }
        return exists;
    }

    private Set<String> getAllRowKeys() {
        List dateRangeEnums = DateRangeEnum.getCommonEnums();
        HashSet<String> allRowKeys = new HashSet<String>();
        for (DateRangeEnum dateRangeEnum : dateRangeEnums) {
            if (dateRangeEnum == DateRangeEnum.HALF_YEAR) continue;
            Integer start = dateRangeEnum.getStart();
            Integer end = dateRangeEnum.getEnd();
            for (int j = start.intValue(); j <= end; ++j) {
                for (FinanceCostTermEnum financeCostTermEnum : FinanceCostTermEnum.values()) {
                    if (financeCostTermEnum == FinanceCostTermEnum.UNKNOWN) continue;
                    String key = j + "_" + financeCostTermEnum.getIndex() + "_" + dateRangeEnum.getValue();
                    allRowKeys.add(key);
                }
                String key = j + "_" + this.AVG_TERM + "_" + dateRangeEnum.getValue();
                allRowKeys.add(key);
            }
        }
        return allRowKeys;
    }

    @Override
    protected List<String> getLinkReport() {
        List<String> objects = Collections.singletonList("tda_fincostbytermrpt");
        return objects;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return this.DATE_RANGE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_fincostbytermrpt");
        showParameter.getCustomParams().put(this.DATE_RANGE, ids.get(0));
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(5, 4);
        }
        return value;
    }
}

