/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.tda.common.enums.FinanceTermYearEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceTermDateHelper;

public class FinanceDebtByYearQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String TERM_YEAR_TEXT = "termyeartext";
    private static final String AMOUNT = "drawamount";
    private static final String FINANCING_NATURE = "financingnature";
    private static final FinanceTermYearEnum[] TERM_YEAR_ENUM_ARRAY = new FinanceTermYearEnum[]{FinanceTermYearEnum.WITHIN_SIX_MONTH, FinanceTermYearEnum.SIX_MONTH_ONE_YEAR, FinanceTermYearEnum.ONE_THREE_YEAR, FinanceTermYearEnum.THREE_FIVE_YEAR, FinanceTermYearEnum.FIVE_TEN_YEAR, FinanceTermYearEnum.MORE_THEN_TEN_YEAR};

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{TERM_YEAR_TEXT, ResManager.loadKDString((String)"\u671f\u9650", (String)"FinanceDebtByYearQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"termyearnumber", ResManager.loadKDString((String)"\u671f\u9650\u7f16\u53f7", (String)"FinanceDebtByYearQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"FinanceDebtByYearQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{FINANCING_NATURE, ResManager.loadKDString((String)"\u878d\u8d44\u6027\u8d28", (String)"FinanceDebtByYearQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        ds = ds.filter("isequity=false").select("term,repayamount drawamount,rowoffset,coloffset,isoutgroup,0 termyearnumber");
        ds = FinanceTermDateHelper.parseTerm(ds);
        ds = ds.groupBy(new String[]{"isoutgroup", "termyearnumber"}).sum(AMOUNT).sum("rowoffset").sum("coloffset").finish();
        boolean enableOffsetShow = BasicParamHelper.getAppBooleamParameter((String)"tda_finance_param", (String)"enableoffsetshow");
        ds = enableOffsetShow ? ds.updateField(AMOUNT, "case when isoutgroup = 0 then drawamount + rowoffset else drawamount + rowoffset + coloffset end") : ds.updateField(AMOUNT, "drawamount + rowoffset + coloffset");
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds);
        ds = dataSets[0];
        DataSet allFinNatureDs = dataSets[1].addField("'ALL'", FINANCING_NATURE);
        if (enableOffsetShow) {
            allFinNatureDs = allFinNatureDs.updateField(AMOUNT, "case when isoutgroup = 0 then drawamount + coloffset else drawamount end ");
        }
        ds = ds.addField("case when isoutgroup = 1 then 'OUT' else 'IN' end as financingnature", FINANCING_NATURE);
        DataSet resultDs = allFinNatureDs.union(ds);
        resultDs = resultDs.groupBy(new String[]{FINANCING_NATURE, "termyearnumber"}).sum(AMOUNT).finish();
        resultDs = this.dealEmptyRow(resultDs);
        String financingNature = String.format("case when financingnature='ALL' then '%1$s' when financingnature='OUT' then '%2$s' when financingnature='IN' then '%3$s' else '%1$s' end", ResManager.loadKDString((String)"\u5168\u90e8", (String)"FinanceDebtByYearQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5916", (String)"FinanceDebtByYearQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5185", (String)"FinanceDebtByYearQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
        resultDs = resultDs.updateField(FINANCING_NATURE, financingNature);
        String termYearText = String.format("case when termyearnumber=1 then '%1$s' when termyearnumber=2 then '%2$s' when termyearnumber=3 then '%3$s' when termyearnumber=4 then '%4$s' when termyearnumber=5 then '%5$s' when termyearnumber=6 then '%6$s' end", FinanceTermYearEnum.WITHIN_SIX_MONTH.getText(), FinanceTermYearEnum.SIX_MONTH_ONE_YEAR.getText(), FinanceTermYearEnum.ONE_THREE_YEAR.getText(), FinanceTermYearEnum.THREE_FIVE_YEAR.getText(), FinanceTermYearEnum.FIVE_TEN_YEAR.getText(), FinanceTermYearEnum.MORE_THEN_TEN_YEAR.getText());
        return resultDs.addField(termYearText, TERM_YEAR_TEXT);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_findebtyearrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return TERM_YEAR_TEXT;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId(formId);
        this.fireLinkageShowForm(view, param);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    private DataSet dealEmptyRow(DataSet ds) {
        List<String> financingNatures = this.getFinancingNatures(ds);
        RowMeta rowMeta = ds.getRowMeta();
        for (String financingNature : financingNatures) {
            for (FinanceTermYearEnum yearEnum : TERM_YEAR_ENUM_ARRAY) {
                String filterConditions = String.format("financingnature='%1$s' and termyearnumber=%2$s", financingNature, yearEnum.getNumber());
                if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
                DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{financingNature, yearEnum.getNumber(), 0.0}));
                ds = ds.union(bizDs);
            }
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFinancingNatures(DataSet ds) {
        ArrayList<String> financingNatures = new ArrayList<String>(4);
        try (DataSet copy = null;){
            copy = ds.copy().groupBy(new String[]{FINANCING_NATURE}).finish();
            while (copy.hasNext()) {
                Row row = copy.next();
                String financeType = row.getString(FINANCING_NATURE);
                if (financeType == null) continue;
                financingNatures.add(financeType);
            }
            ArrayList<String> arrayList = financingNatures;
            return arrayList;
        }
    }
}

