/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceFormDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static String FINANCE_MODE = "financemode";
    private static String REPAY_AMOUNT = "repayamount";
    private String UN_EQUITY = "isequity = false";
    private static final String PARAM = "param";
    private static final String LOAN_RATE = "loanrate";
    private static final String RATE_AMOUNT = "rateamount";
    private static final String AVERAGE_COIST = "averagecost";
    private static final String INDIRECT_AMOUNT = "indirectamount";
    private static final String DIRECT_AMOUNT = "directamount";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{FINANCE_MODE, ResManager.loadKDString((String)"\u878d\u8d44\u5f62\u5f0f", (String)"FinanceFormDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{REPAY_AMOUNT, ResManager.loadKDString((String)"\u6709\u606f\u8d1f\u503a\u603b\u989d", (String)"FinanceFormDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"financemodename", ResManager.loadKDString((String)"\u878d\u8d44\u5f62\u5f0f\u540d\u79f0", (String)"FinanceFormDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"FinanceFormDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{INDIRECT_AMOUNT, ResManager.loadKDString((String)"\u95f4\u63a5\u878d\u8d44", (String)"FinanceFormDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{DIRECT_AMOUNT, ResManager.loadKDString((String)"\u76f4\u63a5\u878d\u8d44", (String)"FinanceFormDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AVERAGE_COIST, ResManager.loadKDString((String)"\u5e73\u5747\u6210\u672c", (String)"FinanceFormDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"indirectcolumn", ResManager.loadKDString((String)"\u95f4\u63a5\u878d\u8d44\u5217", (String)"FinanceFormDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"directcolumn", ResManager.loadKDString((String)"\u76f4\u63a5\u878d\u8d44\u5217", (String)"FinanceFormDataPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"averagecostcolumn", ResManager.loadKDString((String)"\u5e73\u5747\u6210\u672c\u5217", (String)"FinanceFormDataPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet financeDataSet = FinanceDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)((List)paramMap.get("allorgids")), (Date)DecisionAnlsHelper.getQueryDate(paramMap), (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        financeDataSet = financeDataSet.filter(this.UN_EQUITY).select(new String[]{"org", FINANCE_MODE, REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME, LOAN_RATE});
        financeDataSet = financeDataSet.updateField(REPAY_AMOUNT, String.join((CharSequence)"+", REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME));
        DataSet result = financeDataSet.groupBy(new String[]{FINANCE_MODE}).sum(REPAY_AMOUNT + "*" + LOAN_RATE, RATE_AMOUNT).sum(REPAY_AMOUNT).finish();
        String typeName = String.format("case when financemode=0 then '%1$s' when financemode=1 then '%2$s' else ' ' end", ResManager.loadKDString((String)"\u95f4\u63a5\u878d\u8d44", (String)"FinanceFormDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76f4\u63a5\u878d\u8d44", (String)"FinanceFormDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]));
        result = this.addTotalProfit(result);
        result = DecisionAnlsHelper.creatAbsentRow(result, FINANCE_MODE, Arrays.asList("0", "1"), 0, () -> new Object[]{"", "0", "0", "0.0"});
        return result.addFields(new String[]{typeName, FINANCE_MODE, "case when financemode=0 then repayamount else 0.0 end", "case when financemode=1 then repayamount else 0.0 end", DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u95f4\u63a5\u878d\u8d44", (String)"FinanceFormDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u76f4\u63a5\u878d\u8d44", (String)"FinanceFormDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u5e73\u5747\u6210\u672c", (String)"FinanceFormDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]))}, new String[]{"financemodename", PARAM, INDIRECT_AMOUNT, DIRECT_AMOUNT, "indirectcolumn", "directcolumn", "averagecostcolumn"});
    }

    private DataSet addTotalProfit(DataSet ds) {
        final String profit = this.getTotalProfit(ds.copy());
        ds = ds.addField("0.0", AVERAGE_COIST);
        final RowMeta rowMetas = ds.getRowMeta();
        final long[] i = new long[]{0L};
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(16);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (FinanceFormDataPlugin.AVERAGE_COIST.equals(fieldName)) {
                        if (i[0] == 0L) {
                            rowInfo.add(new BigDecimal(profit));
                        } else {
                            rowInfo.add(BigDecimal.ZERO);
                        }
                        i[0] = i[0] + 1L;
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTotalProfit(DataSet ds) {
        String profit = "0.0";
        try {
            ds = ds.updateField("financemode", "1").groupBy(new String[]{"financemode"}).sum("repayamount").sum(RATE_AMOUNT).finish();
            ds = ds.select("case when (repayamount is null or repayamount=0) then 0.0 else rateamount*1.0/repayamount end as profit");
            Iterator iterator = ds.iterator();
            if (iterator.hasNext()) {
                profit = ((Row)iterator.next()).getString("profit");
            }
        }
        finally {
            ds.close();
        }
        return profit;
    }

    @Override
    protected List<String> getLinkReport() {
        return Arrays.asList("tda_financeformrpt", "tda_finformbydirrpt", "tda_finformbyindirrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        if (!"tda_financeformrpt".equals(formId)) {
            formId = EmptyUtil.isNoEmpty(ids) && "0".equals(ids.get(0)) ? "tda_finformbyindirrpt" : (EmptyUtil.isNoEmpty(ids) && "1".equals(ids.get(0)) ? "tda_finformbydirrpt" : "tda_financeformrpt");
        }
        switch (formId) {
            case "tda_financeformrpt": {
                showParameter.setFormId("tda_financeformrpt");
                break;
            }
            case "tda_finformbydirrpt": {
                showParameter.setFormId("tda_finformbydirrpt");
                showParameter.setCaption(ResManager.loadKDString((String)"\u878d\u8d44\u5f62\u5f0f-\u76f4\u878d\u8868", (String)"FinanceFormDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]));
                break;
            }
            case "tda_finformbyindirrpt": {
                showParameter.setFormId("tda_finformbyindirrpt");
                showParameter.setCaption(ResManager.loadKDString((String)"\u878d\u8d44\u5f62\u5f0f-\u95f4\u878d\u8868", (String)"FinanceFormDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]));
                break;
            }
        }
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(8);
        fields.add(REPAY_AMOUNT);
        fields.add(INDIRECT_AMOUNT);
        fields.add(DIRECT_AMOUNT);
        return fields;
    }
}

