/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.FinanceStatisticTypeEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.FinanceInterestBearLiaDisDatahelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceInterestBearLiaDisHelper;

public class FinanceInterestBearLiaDisQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String DATARANGE = "datarange";
    private static final String AMOUNT = "repayamount";
    private static final String ORDER = "order";
    private static final String PARAM = "param";
    private static final String STATISTICS_TYPE = "statisticsType";
    private static final String FINANCINGNATURE = "financingnature";
    private static final String FINANCINGNATURENAME = "financingnaturename";
    private static final String STAT = "stat";
    private static final String STATNAME = "statname";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{DATARANGE, ResManager.loadKDString((String)"\u671f\u9650", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{ORDER, ResManager.loadKDString((String)"\u6392\u5e8f", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{STAT, ResManager.loadKDString((String)"\u7edf\u8ba1\u5206\u7c7b", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{STATNAME, ResManager.loadKDString((String)"\u7edf\u8ba1\u5206\u7c7b\u540d\u79f0", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{FINANCINGNATURE, ResManager.loadKDString((String)"\u878d\u8d44\u6027\u8d28", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{FINANCINGNATURENAME, ResManager.loadKDString((String)"\u878d\u8d44\u6027\u8d28\u540d\u79f0", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        String className = ((Object)((Object)this)).getClass().getName();
        DataSet ds = FinanceInterestBearLiaDisDatahelper.getInterstBearLiaDisDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, null);
        ds = ds.filter("isequity=false").select("org,isoutgroup,residueterm,expiredate,startintdate,repayamount,repayamount as count,rowoffset,coloffset,'' as datarange,0 as order,perpetualbond");
        boolean enableoffsetshow = BasicParamHelper.getAppBooleamParameter((String)"tda_finance_param", (String)"enableoffsetshow");
        ds = enableoffsetshow ? ds.updateField(AMOUNT, "case when isoutgroup = 0 then repayamount + rowoffset else repayamount + rowoffset + coloffset end") : ds.updateField(AMOUNT, "repayamount + rowoffset + coloffset");
        DataSet dataRangeSet = FinanceInterestBearLiaDisHelper.getDataByResidueterm(ds, paramMap, true);
        String selectStr = "org,isoutgroup,startintdate,repayamount,count,datarange,order,rowoffset,coloffset";
        DataSet monthDataSet = FinanceInterestBearLiaDisHelper.dealStartintdateByType(dataRangeSet.copy().select(selectStr), queryDate, FinanceStatisticTypeEnum.MONTH.getValue()).addFields(new String[]{"'" + FinanceStatisticTypeEnum.MONTH.getValue() + "'", "'" + FinanceStatisticTypeEnum.MONTH.getName() + "'"}, new String[]{STAT, STATNAME});
        DataSet monthDataAllFinnatureSet = monthDataSet.copy();
        if (enableoffsetshow) {
            monthDataAllFinnatureSet = monthDataAllFinnatureSet.updateField(AMOUNT, "case when isoutgroup = 0 then repayamount + coloffset else repayamount end ");
        }
        DataSet yearDataSet = FinanceInterestBearLiaDisHelper.dealStartintdateByType(dataRangeSet.copy().select(selectStr), queryDate, FinanceStatisticTypeEnum.YEAR.getValue()).addFields(new String[]{"'" + FinanceStatisticTypeEnum.YEAR.getValue() + "'", "'" + FinanceStatisticTypeEnum.YEAR.getName() + "'"}, new String[]{STAT, STATNAME});
        DataSet yearDataAllFinnatureSet = yearDataSet.copy();
        if (enableoffsetshow) {
            yearDataAllFinnatureSet = yearDataAllFinnatureSet.updateField(AMOUNT, "case when isoutgroup = 0 then repayamount + coloffset else repayamount end");
        }
        DataSet stockDataSet = dataRangeSet.select(selectStr).addFields(new String[]{"'" + FinanceStatisticTypeEnum.ALL.getValue() + "'", "'" + FinanceStatisticTypeEnum.ALL.getName() + "'"}, new String[]{STAT, STATNAME});
        DataSet stockDataAllFinnatureSet = stockDataSet.copy();
        if (enableoffsetshow) {
            stockDataAllFinnatureSet = stockDataAllFinnatureSet.updateField(AMOUNT, "case when isoutgroup = 0 then repayamount + coloffset else repayamount end");
        }
        monthDataAllFinnatureSet = monthDataAllFinnatureSet.union(new DataSet[]{yearDataAllFinnatureSet, stockDataAllFinnatureSet}).addFields(new String[]{"'ALL'", ResManager.loadKDString((String)"'\u5168\u90e8'", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0])}, new String[]{FINANCINGNATURE, FINANCINGNATURENAME});
        String financeNameStr = "case when isoutgroup = 1 then '%1$s' else '%2$s' end as financingnaturename";
        monthDataSet = monthDataSet.union(new DataSet[]{yearDataSet, stockDataSet}).addFields(new String[]{"case when isoutgroup = 1 then 'OUT' else 'IN' end as financingnature", String.format(financeNameStr, ResManager.loadKDString((String)"\u96c6\u56e2\u5916", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5185", (String)"FinanceInterestBearLiaDisQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]))}, new String[]{FINANCINGNATURE, FINANCINGNATURENAME});
        String selectField = "datarange,repayamount,order,stat,statname,financingnature,financingnaturename";
        monthDataSet = monthDataSet.select(selectField).union(monthDataAllFinnatureSet.select(selectField)).addField("CONCAT(stat + ',' +  financingnature)", PARAM);
        monthDataSet = FinanceInterestBearLiaDisHelper.addQingZeroDataRange(monthDataSet, className);
        return monthDataSet.groupBy(new String[]{DATARANGE, ORDER, STAT, STATNAME, FINANCINGNATURE, FINANCINGNATURENAME, PARAM}).sum(AMOUNT).finish();
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_intbearliadeadlinerpt");
        parameter.getCustomParams().put(STATISTICS_TYPE, ids.get(0));
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_intbearliadeadlinerpt");
    }
}

