/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.enums.FinanceStatisticTypeEnum;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.TdaParameterHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceStruAnalyQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String SIMPLENAME = "simplename";
    private static final String BANKLOANS = "bankloans";
    private static final String ISSUANCEOFBOND = "issuanceofbond";
    private static final String BUSINESSBORROW = "businessborrow";
    private static final String FINCOMPAMT = "fincompamt";
    private static final String FINLEASINGAMT = "finleasingamt";
    private static final String SETTLECENTERAMT = "settlecenteramt";
    private static final String OTHERAMOUNT = "otheramount";
    private static final String ORGID = "org";
    private static final String PARAM = "param";
    private static final String PARAMNAME = "paramname";
    private static final String FINANCETYPE = "financetype";
    private static final String AMOUNT = "amount";
    private static final String FINANCETYPENAME = "financetypename";
    private static final String STATISTICS_TYPE = "statisticsType";
    private static final String ISOUTGROUP = "isoutgroup";
    private static final String FINANCINGNATURE = "financingnature";
    private static final String FINANCINGNATURENAME = "financingnaturename";
    private List<String> SUM_FIELDS = Arrays.asList("bankloans", "issuanceofbond", "businessborrow", "fincompamt", "finleasingamt", "settlecenteramt", "otheramount");
    private static final String[] newFieldNames = new String[]{"simplename", "param", "paramname", "financetype", "financetypename", "amount", "isoutgroup"};
    private static final DataType[] newDataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.IntegerType};

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{SIMPLENAME, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7b80\u79f0", (String)"FinanceStruAnalyQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"FinanceStruAnalyQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{PARAMNAME, ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"FinanceStruAnalyQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{FINANCETYPE, ResManager.loadKDString((String)"\u878d\u8d44\u7ed3\u6784\u7c7b\u578b", (String)"FinanceStruAnalyQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{FINANCETYPENAME, ResManager.loadKDString((String)"\u878d\u8d44\u7ed3\u6784\u7c7b\u578b\u540d\u79f0", (String)"FinanceStruAnalyQingAnlsPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"FinanceStruAnalyQingAnlsPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{FINANCINGNATURE, ResManager.loadKDString((String)"\u878d\u8d44\u6027\u8d28", (String)"FinanceStruAnalyQingAnlsPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{FINANCINGNATURENAME, ResManager.loadKDString((String)"\u878d\u8d44\u6027\u8d28\u540d\u79f0", (String)"FinanceStruAnalyQingAnlsPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get(ORGID)).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        ds = ds.updateField("repayamount", "repayamount + rowoffset");
        DataSet[] splitDataSet = ds.splitByFilter(new String[]{"isoutgroup = 0 and sourcetype = 0 and creditortype = 'settlecenter'", "isoutgroup = 0 and creditortype = 'fincom'"}, true);
        DataSet settleDataSet = splitDataSet[0].updateField(FINANCETYPE, "5");
        DataSet finCompDataSet = splitDataSet[1].updateField(FINANCETYPE, "4");
        ds = settleDataSet.union(new DataSet[]{finCompDataSet, splitDataSet[2]});
        ds = ds.select("org,isoutgroup,startintdate,case when financetype = 0 then repayamount else 0 end as bankloans,case when financetype = 1 then repayamount else 0 end as issuanceofbond ,case when financetype = 2 then repayamount else 0 end as businessborrow,case when sourcetype = 3 and financetype = 3 then repayamount else 0 end as finleasingamt,case when financetype = 4 then repayamount else 0 end as fincompamt,case when financetype = 5 then repayamount else 0 end as settlecenteramt,case when sourcetype = 0 and financetype = 3 then repayamount else 0 end as otheramount");
        List subOrgIds = TmcOrgDataHelper.getSecondOrgIds((Long)orgViewId, (Long)orgId, (boolean)true, (boolean)true);
        List<String> fieldList = FinanceStruAnalyQingAnlsPlugin.getFieldList();
        DataSet allOrgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        String monthExpr = FinanceStruAnalyQingAnlsPlugin.dealStartintdateByType(queryDate, FinanceStatisticTypeEnum.MONTH.getValue(), paramsMap);
        String yearExpr = FinanceStruAnalyQingAnlsPlugin.dealStartintdateByType(queryDate, FinanceStatisticTypeEnum.YEAR.getValue(), paramsMap);
        String[] filterExprs = new String[]{monthExpr, yearExpr};
        DataSet[] splitDs = DataSetHelper.splitByFilter((DataSet)ds.copy(), (String[])filterExprs, paramsMap, (boolean)false);
        DataSet monthDataSet = splitDs[0].updateField("startintdate", "'" + FinanceStatisticTypeEnum.MONTH.getValue() + "'");
        monthDataSet = this.getSumDataSet(allOrgDataSet.copy(), monthDataSet, fieldList, FinanceStatisticTypeEnum.MONTH);
        DataSet yearDataSet = splitDs[1].updateField("startintdate", "'" + FinanceStatisticTypeEnum.YEAR.getValue() + "'");
        yearDataSet = this.getSumDataSet(allOrgDataSet.copy(), yearDataSet, fieldList, FinanceStatisticTypeEnum.YEAR);
        DataSet stockDataSet = this.getSumDataSet(allOrgDataSet, ds, fieldList, FinanceStatisticTypeEnum.ALL);
        DataSet unionDataSet = monthDataSet.union(new DataSet[]{yearDataSet, stockDataSet});
        RowMeta rowMeta = unionDataSet.getRowMeta();
        if (unionDataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        unionDataSet = CollectionUtils.isEmpty((Collection)subOrgIds) ? DecisionAnlsHelper.createEmptyDataSet(unionDataSet.getRowMeta()) : unionDataSet.copy().filter("rowid in orgidparam", Collections.singletonMap("orgidparam", subOrgIds)).filter("bankloans + issuanceofbond + businessborrow + finleasingamt + fincompamt + settlecenteramt + otheramount > 0");
        DataSet groupSet = unionDataSet.groupBy(new String[]{SIMPLENAME, PARAM, PARAMNAME, ISOUTGROUP}).sum(BANKLOANS).sum(ISSUANCEOFBOND).sum(BUSINESSBORROW).sum(FINCOMPAMT).sum(FINLEASINGAMT).sum(SETTLECENTERAMT).sum(OTHERAMOUNT).finish();
        RowMeta builderMeta = RowMetaFactory.createRowMeta((String[])newFieldNames, (DataType[])newDataTypes);
        DataSetBuilder builder = Algo.create((String)"FinanceStruAnalyQingAnlsPlugin.newDataSet").createDataSetBuilder(builderMeta);
        boolean containCompany = TdaParameterHelper.getFinCompanyFlag();
        boolean containSettle = TdaParameterHelper.getFinSettleFinFlag();
        for (Row row : groupSet) {
            String simpleName = row.getString(SIMPLENAME);
            String param = row.getString(PARAM);
            String paramName = row.getString(PARAMNAME);
            BigDecimal bankAmount = row.getBigDecimal(BANKLOANS);
            BigDecimal bondAmount = row.getBigDecimal(ISSUANCEOFBOND);
            BigDecimal companyAmount = row.getBigDecimal(BUSINESSBORROW);
            BigDecimal finCompAmount = row.getBigDecimal(FINCOMPAMT);
            BigDecimal finLeasingAmount = row.getBigDecimal(FINLEASINGAMT);
            BigDecimal settleCenterAmount = row.getBigDecimal(SETTLECENTERAMT);
            BigDecimal otherAmount = row.getBigDecimal(OTHERAMOUNT);
            Integer isOut = row.getInteger(ISOUTGROUP);
            if (isOut == 1) {
                List<Object> bankRow = this.buildDataSetRow(simpleName, param, paramName, "1", bankAmount, isOut, ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e", (String)"FinanceStruAnalyQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]));
                builder.append(bankRow.toArray());
                List<Object> bondRow = this.buildDataSetRow(simpleName, param, paramName, "2", bondAmount, isOut, ResManager.loadKDString((String)"\u53d1\u884c\u503a\u5238", (String)"FinanceStruAnalyQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
                builder.append(bondRow.toArray());
                if (containCompany) {
                    List<Object> companyRowOut = this.buildDataSetRow(simpleName, param, paramName, "3", companyAmount, isOut, ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"FinanceStruAnalyQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
                    builder.append(companyRowOut.toArray());
                }
                List<Object> otherRow = this.buildDataSetRow(simpleName, param, paramName, "7", otherAmount.add(finLeasingAmount), isOut, ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceStruAnalyQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
                builder.append(otherRow.toArray());
            } else {
                List<Object> finCompRow = this.buildDataSetRow(simpleName, param, paramName, "4", finCompAmount, isOut, ResManager.loadKDString((String)"\u8d22\u53f8\u501f\u6b3e", (String)"FinanceStruAnalyQingAnlsPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]));
                builder.append(finCompRow.toArray());
                if (containSettle) {
                    List<Object> settleCenterRow = this.buildDataSetRow(simpleName, param, paramName, "6", settleCenterAmount, isOut, ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3", (String)"FinanceStruAnalyQingAnlsPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]));
                    builder.append(settleCenterRow.toArray());
                }
                List<Object> finLeasingRow = this.buildDataSetRow(simpleName, param, paramName, "5", finLeasingAmount, isOut, ResManager.loadKDString((String)"\u878d\u8d44\u79df\u8d41", (String)"FinanceStruAnalyQingAnlsPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]));
                builder.append(finLeasingRow.toArray());
                if (containCompany) {
                    List<Object> companyRowIn = this.buildDataSetRow(simpleName, param, paramName, "3", companyAmount, isOut, ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"FinanceStruAnalyQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
                    builder.append(companyRowIn.toArray());
                }
            }
            List<Object> allBankRow = this.buildDataSetRow(simpleName, param, paramName, "1", bankAmount, 3, ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e", (String)"FinanceStruAnalyQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]));
            builder.append(allBankRow.toArray());
            List<Object> allBondRow = this.buildDataSetRow(simpleName, param, paramName, "2", bondAmount, 3, ResManager.loadKDString((String)"\u53d1\u884c\u503a\u5238", (String)"FinanceStruAnalyQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
            builder.append(allBondRow.toArray());
            if (containCompany) {
                List<Object> allCompanyRow = this.buildDataSetRow(simpleName, param, paramName, "3", companyAmount, 3, ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"FinanceStruAnalyQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
                builder.append(allCompanyRow.toArray());
            }
            List<Object> allFinCompRow = this.buildDataSetRow(simpleName, param, paramName, "4", finCompAmount, 3, ResManager.loadKDString((String)"\u8d22\u53f8\u501f\u6b3e", (String)"FinanceStruAnalyQingAnlsPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]));
            builder.append(allFinCompRow.toArray());
            List<Object> allOtherRow = this.buildDataSetRow(simpleName, param, paramName, "7", otherAmount.add(finLeasingAmount), 3, ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceStruAnalyQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
            builder.append(allOtherRow.toArray());
        }
        DataSet resultDS = builder.build();
        String financeNameStr = "case when isoutgroup = 1 then '%1$s' when isoutgroup = 0 then '%2$s' else '%3$s' end as financingnaturename";
        String financeNameExpr = String.format(financeNameStr, ResManager.loadKDString((String)"\u96c6\u56e2\u5916", (String)"FinanceStruAnalyQingAnlsPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5185", (String)"FinanceStruAnalyQingAnlsPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5168\u90e8", (String)"FinanceStruAnalyQingAnlsPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]));
        resultDS = resultDS.addFields(new String[]{"case when isoutgroup = 1 then '3' when isoutgroup = 0 then '2' else '1' end as financingnature", financeNameExpr}, new String[]{FINANCINGNATURE, FINANCINGNATURENAME});
        return resultDS;
    }

    private List<Object> buildDataSetRow(String simpleName, String param, String paramName, String finType, BigDecimal amt, Integer isOut, String finTypeName) {
        ArrayList<Object> row = new ArrayList<Object>(newFieldNames.length);
        row.add(simpleName);
        row.add(param);
        row.add(paramName);
        row.add(finType);
        row.add(finTypeName);
        row.add(amt);
        row.add(isOut);
        return row;
    }

    private static String dealStartintdateByType(Date queryDate, String type, Map<String, Object> paramsMap) {
        if (type.equals(FinanceStatisticTypeEnum.MONTH.getValue())) {
            QFilter qFilter = new QFilter("startintdate", ">=", (Object)"monthFirstDay");
            qFilter.and("startintdate", "<=", (Object)"monthLsatDay");
            paramsMap.put("monthFirstDay", DateUtils.getFirstDayOfMonth((Date)queryDate));
            paramsMap.put("monthLsatDay", DateUtils.getLastDayOfMonth((Date)queryDate));
            return qFilter.toString().replace("'", "");
        }
        if (type.equals(FinanceStatisticTypeEnum.YEAR.getValue())) {
            QFilter qFilter = new QFilter("startintdate", ">=", (Object)"yearFirstDay");
            qFilter.and("startintdate", "<=", (Object)"yearLsatDay");
            paramsMap.put("yearFirstDay", DateUtils.getFirstYearDate((Date)queryDate));
            paramsMap.put("yearLsatDay", queryDate);
            return qFilter.toString().replace("'", "");
        }
        return "";
    }

    private DataSet getSumDataSet(DataSet allOrgDataSet, DataSet sourceDataSet, List<String> fieldList, FinanceStatisticTypeEnum typeEnum) {
        DataSet[] inOutDs = sourceDataSet.splitByFilter(new String[]{"isoutgroup=0", "isoutgroup=1"}, false);
        for (int i = 0; i < inOutDs.length; ++i) {
            sourceDataSet = inOutDs[i].groupBy(new String[]{ORGID}).sum(BANKLOANS).sum(ISSUANCEOFBOND).sum(BUSINESSBORROW).sum(FINCOMPAMT).sum(FINLEASINGAMT).sum(SETTLECENTERAMT).sum(OTHERAMOUNT).finish();
            DataSet allDsJoinOrg = allOrgDataSet.leftJoin(sourceDataSet).on("rowid", ORGID).select(fieldList.toArray(new String[fieldList.size()])).finish();
            inOutDs[i] = DecisionAnlsHelper.getSumDataSetByLevel(allDsJoinOrg, this.SUM_FIELDS, SIMPLENAME).addField(String.valueOf(i), ISOUTGROUP);
        }
        DataSet resultSet = inOutDs[0].union(inOutDs[1]);
        return resultSet.addFields(new String[]{"'" + typeEnum.getValue() + "'", "'" + typeEnum.getName() + "'"}, new String[]{PARAM, PARAMNAME});
    }

    private static List<String> getFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(16);
        fieldList.add("rowid");
        fieldList.add(BANKLOANS);
        fieldList.add(ISSUANCEOFBOND);
        fieldList.add(BUSINESSBORROW);
        fieldList.add(FINCOMPAMT);
        fieldList.add(FINLEASINGAMT);
        fieldList.add(SETTLECENTERAMT);
        fieldList.add(OTHERAMOUNT);
        fieldList.add("isgroupnode");
        fieldList.add("level");
        fieldList.add("pid");
        fieldList.add("0 as sumlevel");
        fieldList.add("mixorgname simplename");
        return fieldList;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_findebtsumrpt");
        parameter.getCustomParams().put(STATISTICS_TYPE, ids.get(0));
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_findebtsumrpt");
    }
}

