/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.FinanceStatisticTypeEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.FinanceInterestBearLiaDisDatahelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceTermDateHelper;

public class FinanceTermDateQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AMOUNT = "repayamount";
    private static final String PARAM = "param";
    private static final String STATISTICS_TYPE = "statisticsType";
    private static final String FINANCING_NATURE = "financingnature";
    private static final String FINANCING_NATURE_NAME = "financingnaturename";
    private static final String STAT = "stat";
    private static final String STAT_NAME = "statname";
    private static final String[] financeStatisticTypeValues = new String[]{FinanceStatisticTypeEnum.ALL.getValue(), FinanceStatisticTypeEnum.MONTH.getValue(), FinanceStatisticTypeEnum.YEAR.getValue()};
    private static final String[] financingNatureArray = new String[]{"ALL", "OUT", "IN"};

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"datarange", ResManager.loadKDString((String)"\u671f\u9650", (String)"FinanceTermDateQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"FinanceTermDateQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"order", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"FinanceTermDateQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{STAT, ResManager.loadKDString((String)"\u7edf\u8ba1\u5206\u7c7b", (String)"FinanceTermDateQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{STAT_NAME, ResManager.loadKDString((String)"\u7edf\u8ba1\u5206\u7c7b\u540d\u79f0", (String)"FinanceTermDateQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{FINANCING_NATURE, ResManager.loadKDString((String)"\u878d\u8d44\u6027\u8d28", (String)"FinanceTermDateQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{FINANCING_NATURE_NAME, ResManager.loadKDString((String)"\u878d\u8d44\u6027\u8d28\u540d\u79f0", (String)"FinanceTermDateQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"FinanceTermDateQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = FinanceInterestBearLiaDisDatahelper.getInterstBearLiaDisDataSet((String)this.createAlgoKey(""), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, null);
        ds = ds.filter("isequity=false").select("startintdate,isoutgroup,residueterm,exrepaymentdate,repayamount,rowoffset,coloffset,'' as datarange,0 as order,perpetualbond");
        boolean enableOffsetShow = BasicParamHelper.getAppBooleamParameter((String)"tda_finance_param", (String)"enableoffsetshow");
        ds = enableOffsetShow ? ds.updateField(AMOUNT, "case when isoutgroup = 0 then repayamount + rowoffset else repayamount + rowoffset + coloffset end") : ds.updateField(AMOUNT, "repayamount + rowoffset + coloffset");
        ds = FinanceTermDateHelper.groupByExpireDate(ds, paramMap).addField("'" + FinanceStatisticTypeEnum.ALL.getValue() + "'", STAT);
        DataSet monthDs = FinanceTermDateHelper.filterCurrentMonthOrYear(ds.copy(), queryDate, FinanceStatisticTypeEnum.MONTH.getValue()).updateField(STAT, "'" + FinanceStatisticTypeEnum.MONTH.getValue() + "'");
        DataSet yearDs = FinanceTermDateHelper.filterCurrentMonthOrYear(ds.copy(), queryDate, FinanceStatisticTypeEnum.YEAR.getValue()).updateField(STAT, "'" + FinanceStatisticTypeEnum.YEAR.getValue() + "'");
        DataSet allDs = ds.union(new DataSet[]{monthDs, yearDs});
        DataSet allFinNatureDs = allDs.copy().addField("'ALL'", FINANCING_NATURE);
        if (enableOffsetShow) {
            allFinNatureDs = allFinNatureDs.updateField(AMOUNT, "case when isoutgroup = 0 then repayamount + coloffset else repayamount end ");
        }
        allDs = allDs.addField("case when isoutgroup = 1 then 'OUT' else 'IN' end as financingnature", FINANCING_NATURE);
        DataSet resultDs = allFinNatureDs.union(allDs);
        resultDs = resultDs.groupBy(new String[]{"order", "datarange", STAT, FINANCING_NATURE}).sum(AMOUNT).finish();
        resultDs = this.dealEmptyRow(resultDs, paramMap);
        String statName = String.format("case when stat='%1$s' then '%2$s' when stat='%3$s' then '%4$s' when stat='%5$s' then '%6$s' else '%2$s' end", FinanceStatisticTypeEnum.ALL.getValue(), FinanceStatisticTypeEnum.ALL.getName(), FinanceStatisticTypeEnum.MONTH.getValue(), FinanceStatisticTypeEnum.MONTH.getName(), FinanceStatisticTypeEnum.YEAR.getValue(), FinanceStatisticTypeEnum.YEAR.getName());
        String financingNatureName = String.format("case when financingnature='ALL' then '%1$s' when financingnature='OUT' then '%2$s' when financingnature='IN' then '%3$s' else '%1$s' end", ResManager.loadKDString((String)"\u5168\u90e8", (String)"FinanceTermDateQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5916", (String)"FinanceTermDateQingAnlsPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5185", (String)"FinanceTermDateQingAnlsPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]));
        return resultDs.addFields(new String[]{statName, financingNatureName, "CONCAT(stat + ',' +  financingnature)"}, new String[]{STAT_NAME, FINANCING_NATURE_NAME, PARAM});
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(formId);
        parameter.getCustomParams().put(STATISTICS_TYPE, ids.get(0));
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_fintermdaterpt");
    }

    private DataSet dealEmptyRow(DataSet ds, Map<String, Object> paramMap) {
        String[] dataRanges = (String[])paramMap.get("dataRangeArray");
        int[] orders = (int[])paramMap.get("orderArray");
        RowMeta rowMeta = ds.getRowMeta();
        for (int order : orders) {
            for (String stat : financeStatisticTypeValues) {
                for (String financingNature : financingNatureArray) {
                    String filterConditions = String.format("order=%1$s and stat='%2$s' and financingnature='%3$s'", order, stat, financingNature);
                    if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
                    DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{order, dataRanges[order], stat, financingNature, 0.0}));
                    ds = ds.union(bizDs);
                }
            }
        }
        return ds;
    }
}

