/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.finance.helper.FinanceingCostAnalsDataHelper;

public class FinanceingCostCurrencyDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String CURRENCYSORT = "currencysort";
    private static final String CURRENCYTYPENAME = "currencytypename";
    private static final String RATE = "rate";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"month", ResManager.loadKDString((String)"\u6708\u4efd\u6570", (String)"FinanceingCostCurrencyDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"dateStr", ResManager.loadKDString((String)"\u6708\u4efd", (String)"FinanceingCostCurrencyDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u65e5\u671f", (String)"FinanceingCostCurrencyDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Date.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"FinanceingCostCurrencyDataPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"param", ResManager.loadKDString((String)"\u53c2\u6570", (String)"FinanceingCostCurrencyDataPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"paramname", ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"FinanceingCostCurrencyDataPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{CURRENCYSORT, ResManager.loadKDString((String)"\u5e01\u79cd\u6392\u5e8f", (String)"FinanceingCostCurrencyDataPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{CURRENCYTYPENAME, ResManager.loadKDString((String)"\u5e01\u79cd\u540d\u79f0", (String)"FinanceingCostCurrencyDataPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{RATE, ResManager.loadKDString((String)"\u6210\u672c", (String)"FinanceingCostCurrencyDataPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet financeDataSet = FinanceingCostAnalsDataHelper.getMonthData(paramMap, "financeingcurrency", new String[]{"bizdate", "month", "dateStr", CURRENCYSORT}, "");
        DataSet averageDataSet = financeDataSet.copy().groupBy(new String[]{"bizdate", "month", "dateStr", "param", "paramname"}).sum("repayamount").sum("repayrateamount").finish();
        averageDataSet = averageDataSet.addFields(new String[]{"'averagecost'", String.format("'%s'", ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceingCostCurrencyDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0])), "99"}, new String[]{CURRENCYSORT, CURRENCYTYPENAME, CURRENCYSORT});
        financeDataSet = financeDataSet.union(averageDataSet.select(financeDataSet.getRowMeta().getFieldNames()));
        financeDataSet = financeDataSet.addField("case when (repayamount = 0 or repayamount is null)  then 0  else repayrateamount/repayamount end", RATE).orderBy(new String[]{"bizdate"});
        financeDataSet = financeDataSet.filter("currencysort != 3");
        return financeDataSet;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        Map customParams = param.getCustomParams();
        customParams.put("displayType", "financeingcurrency");
        customParams.put("param", CollectionUtils.isEmpty(ids) ? "ALL" : ids.get(0));
        param.setFormId("tda_financingcostrpt");
        param.setCaption(ResManager.loadKDString((String)"\u878d\u8d44\u65f6\u70b9\u6210\u672c\u5206\u6790\u8868-\u6309\u5e01\u79cd", (String)"FinanceingCostCurrencyDataPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, param);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "param";
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_financingcostrpt");
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.getCustomParams().put("displayType", "financeingcurrency");
        param.getCustomParams().put("param", CollectionUtils.isEmpty((Collection)((JSONArray)clickArgs.get((Object)"data"))) ? "ALL" : ((JSONArray)clickArgs.get((Object)"data")).get(4));
        param.setFormId("tda_financingcostrpt");
        param.setCaption(ResManager.loadKDString((String)"\u878d\u8d44\u65f6\u70b9\u6210\u672c\u5206\u6790\u8868-\u6309\u5e01\u79cd", (String)"FinanceingCostCurrencyDataPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]));
    }
}

