/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.helper.FinanceBatchDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceingCostAnalsDataHelper;

public class FinanceingCostTermQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String TERMTYPE = "term";
    private static final String RATE = "rate";
    private static final String TERMTYPENAME = "termname";
    private static final String PARAMNAME = "paramname";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"datestr", ResManager.loadKDString((String)"\u6708\u4efd\u6570", (String)"FinanceingCostTypeDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"date", ResManager.loadKDString((String)"\u6708\u4efd", (String)"FinanceingCostTypeDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"FinanceingCostTypeDataPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"param", ResManager.loadKDString((String)"\u53c2\u6570", (String)"FinanceingCostCurrencyDataPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{PARAMNAME, ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"FinanceingCostTypeDataPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{TERMTYPE, ResManager.loadKDString((String)"\u671f\u9650\u7c7b\u578b", (String)"FinanceingCostTermQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{TERMTYPENAME, ResManager.loadKDString((String)"\u671f\u9650\u7c7b\u578b\u540d\u79f0", (String)"FinanceingCostTermQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{RATE, ResManager.loadKDString((String)"\u6210\u672c", (String)"FinanceingCostTypeDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet financeDataSet = FinanceBatchDataHelper.getFinanceDataSet((String)FinanceingCostAnalsDataHelper.class.getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgviewId).filter("term != '0'").select("datestr,date,param,paramname,term,termname,repayamount,loanrate").addField("repayamount * loanrate", "repayrateamount");
        financeDataSet = financeDataSet.groupBy("datestr,date,param,paramname,term,termname".split(",")).sum("repayamount").sum("repayrateamount").finish();
        DataSet averageDataSet = financeDataSet.copy().groupBy("datestr,date,param,paramname".split(",")).sum("repayamount").sum("repayrateamount").finish();
        averageDataSet = averageDataSet.addFields(new String[]{"'99'", String.format("'%s'", ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceingCostTypeDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]))}, new String[]{TERMTYPE, TERMTYPENAME});
        financeDataSet = financeDataSet.union(averageDataSet.select(financeDataSet.getRowMeta().getFieldNames()));
        financeDataSet = financeDataSet.addField("case when (repayamount = 0 or repayamount is null)  then 0  else repayrateamount/repayamount end", RATE).orderBy(new String[]{"date"});
        return financeDataSet;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        Map customParams = reportShowParameter.getCustomParams();
        customParams.put("displayType", "financeingterm");
        customParams.put("param", CollectionUtils.isEmpty(ids) ? "ALL" : ids.get(0));
        reportShowParameter.setFormId("tda_financingcostrpt");
        reportShowParameter.setCaption(ResManager.loadKDString((String)"\u878d\u8d44\u65f6\u70b9\u6210\u672c\u5206\u6790\u8868-\u6309\u671f\u9650", (String)"FinanceingCostTermDataPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, reportShowParameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "param";
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_financingcostrpt");
    }
}

