/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InterestDebtByInterestTypeDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String INTEREST_TYPE = "interesttype";
    private static final String REPAY_AMOUNT = "repayamount";
    private static final String UN_EQUITY = "isequity = false";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{INTEREST_TYPE, ResManager.loadKDString((String)"\u5229\u7387\u7c7b\u578b", (String)"InterestDebtByInterestTypeDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{REPAY_AMOUNT, ResManager.loadKDString((String)"\u8fd8\u6b3e\u4f59\u989d", (String)"InterestDebtByInterestTypeDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"interesttypename", ResManager.loadKDString((String)"\u5229\u7387\u7c7b\u578b\u540d\u79f0", (String)"InterestDebtByInterestTypeDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet financeDataSet = FinanceDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)((List)paramMap.get("allorgids")), (Date)DecisionAnlsHelper.getQueryDate(paramMap), (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        financeDataSet = financeDataSet.filter(UN_EQUITY).select(new String[]{"org", INTEREST_TYPE, REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME});
        DataSet result = financeDataSet.groupBy(new String[]{INTEREST_TYPE}).sum(REPAY_AMOUNT).sum(MergeOffsetHandler.ROW_OFFSETFILENAME).sum(MergeOffsetHandler.COL_OFFSETFILENAME).finish();
        result = result.updateField(REPAY_AMOUNT, String.join((CharSequence)"+", REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME));
        result = DecisionAnlsHelper.creatAbsentRow(result, INTEREST_TYPE, Arrays.asList("fixed", "float"), 0, () -> new Object[]{"", "0", "0", "0"});
        String typeName = String.format("case when interesttype='float' then '%1$s' when interesttype='fixed' then '%2$s' else ' ' end", ResManager.loadKDString((String)"\u6d6e\u52a8\u5229\u7387", (String)"InterestDebtByInterestTypeDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56fa\u5b9a\u5229\u7387", (String)"InterestDebtByInterestTypeDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
        return result.addField(typeName, "interesttypename");
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_interdebtbyinttyperpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return INTEREST_TYPE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_interdebtbyinttyperpt");
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(REPAY_AMOUNT);
    }
}

