/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.message.service.pa.util.StringUtil;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.GuaranteeTermEnum;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;
import kd.tmc.tda.report.gm.qing.data.AbstractGuaranteeByTermQingDataPlugin;

public class GuaranteeByTermDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ORG = "org";
    private static final String TERMTYPE = "termType";
    private static final String ORIGINAL = "original";
    private static final String RESIDUAL = "residual";
    private static final String AMOUNT = "amount";
    private static final String ROWID = "rowid";
    private static final String IS_MORTGAGE_TYPE = "ismortgagetype";
    private static final String TERMSORT = "termsort";
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("inoneyearamount", "onetothreeyearamount", "threetofiveyearamount", "overfiveyearamount", "total_amount");

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List orgIds = (List)paramMap.get("allorgids");
        DataSet allDs = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, orgIds);
        String termType = (String)paramMap.get(TERMTYPE);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String ismortgageType = String.format("case when guaranteeway='%1$s' or guaranteeway='%2$s' then 'mortgagetype' else 'ensuretype' end", GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        allDs = allDs.addField(ismortgageType, IS_MORTGAGE_TYPE);
        allDs = allDs.select(new String[]{"dutyamount", "enddate", "begindate", IS_MORTGAGE_TYPE, ORG, "' ' as termType"});
        if (StringUtil.isEmpty((String)termType)) {
            DataSet residualSet = allDs.copy().updateField(TERMTYPE, "'residual'");
            residualSet = GuaranteeReportHelper.addTermByType(residualSet, RESIDUAL, queryDate, false);
            allDs = GuaranteeReportHelper.addTermByType(allDs, ORIGINAL, queryDate, false);
            return allDs.union(residualSet);
        }
        allDs = allDs.updateField(TERMTYPE, "'" + termType + "'");
        allDs = GuaranteeReportHelper.addTermByType(allDs, termType, queryDate, false);
        return allDs;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        List<String> ismortgagetypeList;
        Map paramMap = this.transQueryParam(queryParam);
        String termType = (String)paramMap.get(TERMTYPE);
        if (termType == null) {
            termType = ORIGINAL;
        }
        if ((ismortgagetypeList = (List<String>)paramMap.get(IS_MORTGAGE_TYPE)) == null) {
            ismortgagetypeList = Arrays.asList("mortgagetype", "ensuretype");
        }
        ds = ds.filter("termType = selectTermType", Collections.singletonMap("selectTermType", termType));
        ds = ds.filter("ismortgagetype in ismortgagetypeList", Collections.singletonMap("ismortgagetypeList", ismortgagetypeList));
        ds = ds.select(new String[]{ORG, "dutyamount as amount", IS_MORTGAGE_TYPE, TERMTYPE, TERMSORT, "term"});
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        ds = this.addEmptyRow(ds, termType, ((DynamicObject)parentOrgs.get(0)).getLong("id"));
        List<String> sumFields = Collections.singletonList(AMOUNT);
        DataSet changeSet = DecisionAnlsHelper.typeGroupFiledSum(ds, ORG, "", "term", sumFields, new ArrayList<String>(16));
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> selectField = GuaranteeByTermDataListPlugin.getSelectField(AMOUNT_FIELDS);
        selectField.add("sortcode");
        DataSet orgJoinSet = orgDateSet.leftJoin(changeSet).on(ROWID, ORG).select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, AMOUNT_FIELDS, "sortcode,orgname,mixorgname,rowid orgid");
        List subOrgids = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)subOrgids)) {
            subOrgids = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in orgidparam", Collections.singletonMap("orgidparam", subOrgids));
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, AMOUNT_FIELDS, "mixorgname");
        return sumDataSet.union(totalSet);
    }

    private DataSet addEmptyRow(DataSet ds, String termType, long id) {
        DataSet copy = ds.copy().groupBy(new String[]{TERMSORT}).finish();
        HashSet<Integer> dateRangs = new HashSet<Integer>(10);
        RowMeta rowMeta = ds.getRowMeta();
        while (copy.hasNext()) {
            Row row = copy.next();
            Integer termsort = row.getInteger(TERMSORT);
            dateRangs.add(termsort);
        }
        for (GuaranteeTermEnum guaranteeTermEnum : GuaranteeTermEnum.values()) {
            Integer dateRangeTermSort;
            if (guaranteeTermEnum == GuaranteeTermEnum.UNKNOWN || !dateRangs.add(dateRangeTermSort = guaranteeTermEnum.getIndex())) continue;
            DataSet gmTermDateSet = DecisionAnlsHelper.createRow(AbstractGuaranteeByTermQingDataPlugin.class.getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{id, 0.0, "ensuretype", termType, guaranteeTermEnum.getIndex(), guaranteeTermEnum.getNumber()}));
            ds = ds.union(gmTermDateSet);
        }
        return ds;
    }

    public static List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("mixorgname orgname");
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add("org as orgid");
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        return selectField;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        int index = 1;
        for (String field : AMOUNT_FIELDS) {
            if (index == 5) break;
            ReportColumn newCol = new ReportColumn();
            newCol.setFieldKey(field);
            newCol.setFieldType("decimal");
            newCol.setZeroShow(true);
            newCol.setScale(2);
            GuaranteeTermEnum enumByIndex = GuaranteeTermEnum.getEnumByIndex((Integer)index);
            newCol.setCaption(new LocaleString(enumByIndex.getText().loadKDString()));
            columns.add((AbstractReportColumn)newCol);
            ++index;
        }
        ReportColumn totalField = new ReportColumn();
        totalField.setFieldKey("total_amount");
        totalField.setFieldType("decimal");
        totalField.setZeroShow(true);
        totalField.setScale(2);
        totalField.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d", (String)"GuaranteeByTermDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])));
        columns.add((AbstractReportColumn)totalField);
        return columns;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(10);
        fields.addAll(AMOUNT_FIELDS);
        return fields;
    }
}

