/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.data;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public class GuaranteeContractAnalysisDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String IS_MORTGAGE_TYPE = "ismortgagetype";
    private static final String ORG_NAME = "org_name";
    private static final String ROWID = "rowid";
    private static final List<String> SUM_FIELDS = Arrays.asList("totalamount", "financeamount", "nofinanceamount", "dutyamount", "endofcurryear", "beginofcurryear");

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        DataSet ds = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, orgIds).select("org guaranteeorg, guaranteeway, dutyamount, amount, begindate, enddate, isfinance");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds, (int)3);
        String sic = "guaranteeorg,guaranteeway,dutyamount,amount totalamount,0.0 as endofcurryear,0.0 as beginofcurryear,case when isfinance='finance' then dutyamount else 0.0 end as financeamount,case when isfinance='nofinance' then dutyamount else 0.0 end as nofinanceamount";
        ds = dataSets[0].select(sic);
        DataSet endOfCurrYearDs = this.endOfCurrYear(dataSets[1], queryDate).select("guaranteeorg,guaranteeway,0.0 dutyamount,0.0 totalamount,amount endofcurryear,0.0 beginofcurryear,0.0 financeamount,0.0 nofinanceamount");
        DataSet beginOfCurrYearDs = this.beginOfCurrYear(dataSets[2], queryDate).select("guaranteeorg,guaranteeway,0.0 dutyamount,0.0 totalamount,0.0 endofcurryear,amount beginofcurryear,0.0 financeamount,0.0 nofinanceamount");
        DataSet allSet = ds.union(new DataSet[]{endOfCurrYearDs, beginOfCurrYearDs});
        DataSet groupSet = allSet.groupBy(new String[]{"guaranteeorg", "guaranteeway"}).sum(SUM_FIELDS.get(0)).sum(SUM_FIELDS.get(1)).sum(SUM_FIELDS.get(2)).sum(SUM_FIELDS.get(3)).sum(SUM_FIELDS.get(4)).sum(SUM_FIELDS.get(5)).finish();
        String ismortgageType = String.format("case when guaranteeway='%1$s' or guaranteeway='%2$s' then 'mortgagetype' else 'ensuretype' end", GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        return groupSet.addField(ismortgageType, IS_MORTGAGE_TYPE);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        String mortgagetype = this.getType(paramMap);
        if (!"all".equals(mortgagetype)) {
            ds = ds.filter("ismortgagetype = '" + mortgagetype + "'");
        }
        ds = ds.groupBy(new String[]{"guaranteeorg"}).sum(SUM_FIELDS.get(0)).sum(SUM_FIELDS.get(1)).sum(SUM_FIELDS.get(2)).sum(SUM_FIELDS.get(3)).sum(SUM_FIELDS.get(4)).sum(SUM_FIELDS.get(5)).finish();
        DataSet allDs = orgDs.leftJoin(ds).on(ROWID, "guaranteeorg").select(DecisionAnlsHelper.getSelectField(SUM_FIELDS)).finish();
        DataSet sumResultSet = this.getSumDataSetByLevel(allDs, SUM_FIELDS, "mixorgname,orgid,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        sumResultSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumResultSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("totalamount+dutyamount+endofcurryear+beginofcurryear > 0") : sumResultSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("totalamount+dutyamount+endofcurryear+beginofcurryear > 0");
        sumResultSet = sumResultSet.addField("'groupcol'", "groupcol").orderBy(new String[]{"sortcode"});
        DataSet totalSet = this.addSubTotalDataSet(sumResultSet, Collections.singletonList("groupcol"), SUM_FIELDS, "mixorgname");
        return sumResultSet.union(totalSet).addField("mixorgname", ORG_NAME);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(16);
        fields.addAll(SUM_FIELDS);
        return fields;
    }

    private String getType(Map<String, Object> paramMap) {
        String type;
        JSONArray array = (JSONArray)paramMap.get(IS_MORTGAGE_TYPE);
        if (array != null && array.size() <= 1 && ("mortgagetype".equals(type = array.get(0).toString()) || "ensuretype".equals(type))) {
            return type;
        }
        return "all";
    }

    private DataSet beginOfCurrYear(DataSet ds, Date queryDate) {
        return ds.filter("begindate >= firstDay", Collections.singletonMap("firstDay", DateUtils.getFirstYearDate((Date)queryDate)));
    }

    private DataSet endOfCurrYear(DataSet ds, Date queryDate) {
        HashMap<String, Date> paramsMap = new HashMap<String, Date>(4);
        paramsMap.put("firstDay", DateUtils.getFirstYearDate((Date)queryDate));
        paramsMap.put("lastDay", DateUtils.getNextDay((Date)DateUtils.getLastYearDate((Date)queryDate), (int)1));
        return ds.filter("enddate >= firstDay and enddate < lastDay", paramsMap);
    }
}

