/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.GuaranteeTypeEntityEnum;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public class GuaranteeContractDetailDataListPlugin
extends AbstractDetailDataPlugin {
    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba", (String)"GuaranteeContractDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"gmbillno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"GuaranteeContractDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"guaranteeno", ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u53f7", (String)"GuaranteeContractDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"guaranteename", ResManager.loadKDString((String)"\u62c5\u4fdd\u54c1\u79cd", (String)"GuaranteeContractDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"guaranteeway", ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f", (String)"GuaranteeContractDetailDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"ischange", ResManager.loadKDString((String)"\u5df2\u8c03\u6574", (String)"GuaranteeContractDetailDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"isexceedstock", ResManager.loadKDString((String)"\u8d85\u80a1\u6bd4", (String)"GuaranteeContractDetailDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"isfinance", ResManager.loadKDString((String)"\u878d\u8d44\u6027", (String)"GuaranteeContractDetailDataListPlugin_25", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"guaranteedorgtext", ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba", (String)"GuaranteeContractDetailDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"reguaranteetype", ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u7c7b\u578b", (String)"GuaranteeContractDetailDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"countorguaway", ResManager.loadKDString((String)"\u53cd\u62c5\u4fdd\u7c7b\u578b", (String)"GuaranteeContractDetailDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"creditortype", ResManager.loadKDString((String)"\u503a\u6743\u4eba\u7c7b\u578b", (String)"GuaranteeContractDetailDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(GuaranteeTypeEntityEnum.valueMapItemList())});
        field.add(new Object[]{"creditortext", ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"GuaranteeContractDetailDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"GuaranteeContractDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"GuaranteeContractDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"totalamount", ResManager.loadKDString((String)"\u5355\u636e\u62c5\u4fdd\u5408\u7ea6\u91d1\u989d", (String)"GuaranteeContractDetailDataListPlugin_26", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"gm_rate", ResManager.loadKDString((String)"\u62c5\u4fdd\u6bd4\u4f8b", (String)"GuaranteeContractDetailDataListPlugin_27", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"originalamount", ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u7ea6\u91d1\u989d", (String)"GuaranteeContractDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u7ea6\u6298\u62a5\u544a\u5e01", (String)"GuaranteeContractDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"begindate", ResManager.loadKDString((String)"\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f", (String)"GuaranteeContractDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"enddate", ResManager.loadKDString((String)"\u62c5\u4fdd\u7ed3\u675f\u65e5\u671f", (String)"GuaranteeContractDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"isexpire", ResManager.loadKDString((String)"\u62c5\u4fdd\u8d85\u671f", (String)"GuaranteeContractDetailDataListPlugin_28", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u5408\u540c\u767b\u8bb0\u65e5\u671f", (String)"GuaranteeContractDetailDataListPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"originaldutyamount", ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb\u91d1\u989d", (String)"GuaranteeContractDetailDataListPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"dutyamount", ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb\u91d1\u989d\u6298\u62a5\u544a\u5e01", (String)"GuaranteeContractDetailDataListPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"close", ResManager.loadKDString((String)"\u5173\u95ed", (String)"GuaranteeContractDetailDataListPlugin_21", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"closetime", ResManager.loadKDString((String)"\u5173\u95ed\u65e5\u671f", (String)"GuaranteeContractDetailDataListPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"originalguaranteeamount", ResManager.loadKDString((String)"\u62c5\u4fdd\u8d39", (String)"GuaranteeContractDetailDataListPlugin_29", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"guaranteeamount", ResManager.loadKDString((String)"\u62c5\u4fdd\u8d39\u6298\u62a5\u544a\u5e01", (String)"GuaranteeContractDetailDataListPlugin_30", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        DataSet ds = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, orgIds, true);
        String props = "id, org orgname, org company, billno gmbillno, guaranteeno, guaranteename, guaranteeway, ischange, guaranteedorgtext,reguaranteetype, countorguaway, creditortype, creditortext, currencyname, rate, originalamount, amount, totalamount, total_amount_rate gm_rate,begindate, enddate, bizdate, originaldutyamount, dutyamount, closetime, isexpire, guaranteeamount, originalguaranteeamount,case when isexceedstock=FALSE then '0' else '1' end as isexceedstock,case when isfinance='nofinance' then '0' when isfinance='finance' then '1' else '0' end as isfinance,case when bizstatus='closed' then '1' else '0' end as close";
        String reguaranteeTypeStr = String.format("case when reguaranteetype='bos_org' or reguaranteetype='tmc_org' then '%1$s' else '%2$s' end", ResManager.loadKDString((String)"\u96c6\u56e2\u5185\u62c5\u4fdd", (String)"GuaranteeContractDetailDataListPlugin_23", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5916\u62c5\u4fdd", (String)"GuaranteeContractDetailDataListPlugin_24", (String)"tmc-tda-report", (Object[])new Object[0]));
        ds = ds.updateField("reguaranteetype", reguaranteeTypeStr);
        return this.handleDataSet(ds.select(props));
    }

    private DataSet handleDataSet(DataSet ds) {
        final Map valueMapText = GuaranteeWayEntityEnum.valueMapText();
        final RowMeta rowMetas = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("guaranteeway".equals(fieldName) || "countorguaway".equals(fieldName)) {
                        String guaranteeway = row.getString(fieldName);
                        if (EmptyUtil.isEmpty((String)guaranteeway)) {
                            rowInfo.add("");
                            continue;
                        }
                        rowInfo.add(GuaranteeReportHelper.GuaranteewayValueMapText(guaranteeway, valueMapText));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("amount", "dutyamount");
    }

    @Override
    protected Set<String> getCovertList() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("guaranteeamount");
        return set;
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("gmbillno", "id");
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        return hyperLinkClickEvent -> "gm_guaranteecontract";
    }

    @Override
    protected List<String> getOrderByList() {
        ArrayList<String> orderList = new ArrayList<String>(6);
        orderList.add("guaranteename");
        orderList.add("isexceedstock DESC");
        orderList.add("gmbillno DESC");
        orderList.add("guaranteedorgtext");
        orderList.add("creditortext");
        return orderList;
    }
}

