/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public class GuaranteeContractGuaranteedDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String GUARANTEED_FINANCE_TYPE_ALL = "all";
    private static final String ROWID = "rowid";

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        DataSet contractDs = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, orgIds);
        contractDs = contractDs.groupBy(new String[]{"org", "isfinance", "isinner", "guaranteeway"}).sum("dutyamount").finish();
        String ismortgageType = String.format("case when guaranteeway='%1$s' or guaranteeway='%2$s' then 'mortgagetype' else 'ensuretype' end", GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        return contractDs.addField(ismortgageType, "ismortgagetype");
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam param) {
        String mortgagetype;
        Map paramMap = this.transQueryParam(param);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String financeType = GuaranteeReportHelper.getFinanceType(paramMap);
        if (!GUARANTEED_FINANCE_TYPE_ALL.equals(financeType)) {
            ds = ds.filter("isfinance = '" + financeType + "'");
        }
        if (!GUARANTEED_FINANCE_TYPE_ALL.equals(mortgagetype = GuaranteeReportHelper.getMortgagetype(paramMap))) {
            ds = ds.filter("ismortgagetype = '" + mortgagetype + "'");
        }
        ds = ds.groupBy(new String[]{"org", "isinner", "guaranteeway"}).sum("dutyamount").finish();
        String props = "org,isinner,guaranteeway,dutyamount,case when isinner='inner' then dutyamount else 0 end as inneramount,case when isinner='noinner' then dutyamount else 0 end as noinneramount,case when guaranteeway='ensure' then dutyamount else 0 end as ensureamount,case when guaranteeway='ensuamt' then dutyamount else 0 end as ensuamtamount,case when guaranteeway='mortgage' then dutyamount else 0 end as mortgageamount,case when guaranteeway='pledge' then dutyamount else 0 end as pledgeamount";
        ds = ds.select(props);
        ds = ds.groupBy(new String[]{"org"}).sum("dutyamount", "stat").sum("inneramount").sum("noinneramount").sum("ensureamount").sum("ensuamtamount").sum("mortgageamount").sum("pledgeamount").finish();
        List<String> sumFields = this.getSumField();
        DataSet allDs = orgDs.leftJoin(ds).on(ROWID, "org").select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        DataSet sumDataSet = this.getSumDataSetByLevel(allDs, sumFields, "mixorgname,orgid,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("stat > 0") : sumDataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("stat > 0");
        sumDataSet = sumDataSet.addField("'groupcol'", "groupcol").orderBy(new String[]{"sortcode"});
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        return sumDataSet.union(totalSet);
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.getSumField());
    }

    private List<String> getSumField() {
        ArrayList<String> sumFields = new ArrayList<String>(4);
        sumFields.add("inneramount");
        sumFields.add("noinneramount");
        sumFields.add("stat");
        sumFields.add("ensureamount");
        sumFields.add("ensuamtamount");
        sumFields.add("mortgageamount");
        sumFields.add("pledgeamount");
        return sumFields;
    }
}

