/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.qing.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public class GuaranteeContractAnalysisQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String IS_MORTGAGE_TYPE = "ismortgagetype";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"totalamount", ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u91d1\u989d", (String)"GuaranteeContractAnalysisQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"financeamount", ResManager.loadKDString((String)"\u878d\u8d44\u7c7b", (String)"GuaranteeContractAnalysisQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"nofinanceamount", ResManager.loadKDString((String)"\u975e\u878d\u8d44\u7c7b", (String)"GuaranteeContractAnalysisQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"dutyamount", this.getDutyAmountName(), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"isfinance", ResManager.loadKDString((String)"\u662f\u5426\u878d\u8d44\u7c7b", (String)"GuaranteeContractAnalysisQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{IS_MORTGAGE_TYPE, ResManager.loadKDString((String)"\u662f\u5426\u542b\u62b5\u8d28\u62bc", (String)"GuaranteeContractAnalysisQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"ensuretypename", ResManager.loadKDString((String)"\u4e0d\u542b\u62b5\u8d28\u62bc", (String)"GuaranteeContractAnalysisQingDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"ensuretype", ResManager.loadKDString((String)"\u8fc7\u6ee4\u53c2\u6570", (String)"GuaranteeContractAnalysisQingDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet contractDs = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, this.getOrgIds(paramMap));
        contractDs = contractDs.groupBy(new String[]{"isfinance", "guaranteeway"}).sum("amount").sum("dutyamount").finish();
        String ismortgageType = String.format("case when guaranteeway='%1$s' or guaranteeway='%2$s' then 'mortgagetype' else 'ensuretype' end", GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        contractDs = contractDs.addField(ismortgageType, IS_MORTGAGE_TYPE);
        String props = "isfinance,guaranteeway,ismortgagetype,amount totalamount,dutyamount,case when isfinance='finance' then dutyamount else 0 end as financeamount,case when isfinance='nofinance' then dutyamount else 0 end as nofinanceamount";
        return contractDs.select(props).addFields(new String[]{"'ensuretype'", ResManager.loadKDString((String)"'\u4e0d\u542b\u62b5\u8d28\u62bc'", (String)"GuaranteeContractAnalysisQingDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0])}, new String[]{"ensuretype", "ensuretypename"});
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_gmcontractamtsumrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return IS_MORTGAGE_TYPE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_gmcontractamtsumrpt");
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>(4);
        customParams.put(IS_MORTGAGE_TYPE, ids);
        parameter.setCustomParams(customParams);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(8);
        fields.add("totalamount");
        fields.add("financeamount");
        fields.add("nofinanceamount");
        fields.add("dutyamount");
        return fields;
    }

    private String getDutyAmountName() {
        return ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb\u603b\u989d", (String)"GuaranteeContractAnalysisQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
    }
}

