/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.interloan.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.tmc.tda.extpoint.interloan.IInterLoanDetailInterface;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.InterCompanyLoansDataHelper;
import kd.tmc.tda.common.helper.InterCompanyLoansTermHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceTermDateHelper;

public abstract class AbstractInterLoanDetailDataListPlugin
extends AbstractDetailDataPlugin {
    private static final Log logger = LogFactory.getLog(AbstractInterLoanDetailDataListPlugin.class);

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        final Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        boolean isDebt = (Boolean)paramMap.get("isDebt");
        boolean isTerm = (Boolean)paramMap.get("isTerm");
        String comloanRange = (String)paramMap.get("comloanrange");
        DataSet ds = !isTerm ? InterCompanyLoansDataHelper.getInterCompanyLoanData((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (DataSet)TmcOrgDataHelper.getOrgDateSet((Long)orgViewId), (boolean)isDebt, (String)comloanRange) : InterCompanyLoansTermHelper.getInterLoanTermData((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (DataSet)TmcOrgDataHelper.getOrgDateSet((Long)orgViewId), (boolean)isDebt, (String)comloanRange);
        ds = AbstractInterLoanDetailDataListPlugin.getDetailDataSetExt(ds, paramMap);
        ds = ds.addFields(new String[]{"case when isoutgroup = 0 then 'in' else 'out' end", "case when rowoffset = 0.0 and coloffset = 0.0 then 0 else 1 end", "0"}, new String[]{"isoutgroup1", "isoffset", "isoverdue"});
        ds = ds.updateFields(new String[]{"drawamount", "repayamount"}, new String[]{"case when isoffset = 1 then 0.0 else drawamount end", "case when isoffset = 1 then 0.0 else repayamount end"});
        QFilter mdRateFilter = new QFilter("enable", "=", (Object)"1");
        DataSet mdRateDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"md_datarate", (String)"referrate,bizdate,endprice", (QFilter[])mdRateFilter.toArray(), (String)"referrate asc,bizdate asc");
        ArrayList mdRateList = new ArrayList(10);
        for (Row row : mdRateDataSet) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>(4);
            tempMap.put("referrate", row.get("referrate"));
            tempMap.put("bizdate", row.get("bizdate"));
            tempMap.put("endprice", row.get("endprice"));
            mdRateList.add(tempMap);
        }
        final Map<Long, List<Map>> mdRateMap = mdRateList.stream().collect(Collectors.groupingBy(o -> (Long)o.get("referrate")));
        final RowMeta rowMeta = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public Object[] map(Row row) {
                List tempList;
                Object[] data = RowUtil.toArray((Row)row);
                int isOverDueIndex = rowMeta.getFieldIndex("isoverdue");
                BigDecimal repayAmount = row.getBigDecimal("repayamount");
                Date expiredate = row.getDate("expiredate");
                if (repayAmount != null && expiredate != null && queryDate.compareTo(expiredate) > 0 && repayAmount.compareTo(BigDecimal.ZERO) > 0) {
                    data[isOverDueIndex] = 1;
                }
                int guaranteeIndex = rowMeta.getFieldIndex("guarantee");
                if (StringUtils.isNotEmpty((String)row.getString("guarantee"))) {
                    data[guaranteeIndex] = Arrays.stream(row.getString("guarantee").replace("1", ResManager.loadKDString((String)"\u4fe1\u7528", (String)"FinanceDetailDataListPlugin_80", (String)"tmc-tda-report", (Object[])new Object[0])).replace("7", ResManager.loadKDString((String)"\u4fe1\u7528/\u65e0\u62c5\u4fdd", (String)"FinanceDetailDataListPlugin_81", (String)"tmc-tda-report", (Object[])new Object[0])).replace("6", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceDetailDataListPlugin_82", (String)"tmc-tda-report", (Object[])new Object[0])).replace("5", ResManager.loadKDString((String)"\u8d28\u62bc", (String)"FinanceDetailDataListPlugin_83", (String)"tmc-tda-report", (Object[])new Object[0])).replace("4", ResManager.loadKDString((String)"\u62b5\u62bc", (String)"FinanceDetailDataListPlugin_84", (String)"tmc-tda-report", (Object[])new Object[0])).replace("3", ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1", (String)"FinanceDetailDataListPlugin_85", (String)"tmc-tda-report", (Object[])new Object[0])).replace("2", ResManager.loadKDString((String)"\u4fdd\u8bc1", (String)"FinanceDetailDataListPlugin_86", (String)"tmc-tda-report", (Object[])new Object[0])).split(",")).filter(s -> !StringUtils.isBlank((String)s)).collect(Collectors.joining(","));
                }
                int index = rowMeta.getFieldIndex("referenceratevalue");
                Long referencerate = row.getLong("referencerate");
                if (referencerate == null) {
                    return data;
                }
                Date startintdate = row.getDate("startintdate");
                List mdRateTempMap = (List)mdRateMap.get(referencerate);
                if (!EmptyUtil.isEmpty((Collection)mdRateTempMap) && !EmptyUtil.isEmpty(tempList = mdRateTempMap.stream().filter(m -> m.get("bizdate") != null && ((Date)m.get("bizdate")).getTime() <= startintdate.getTime()).collect(Collectors.toList()))) {
                    Map rateRow = (Map)tempList.get(tempList.size() - 1);
                    data[index] = rateRow.get("endprice");
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        ds = ds.addField("isoffset", "isoffsetNum");
        ds = FinanceTermDateHelper.parseTerm(ds);
        return ds;
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("repayamount", "drawamount");
    }

    @Override
    protected List<String> getOrderByList() {
        return Arrays.asList("loantype", "finproductname");
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("billno", "id");
    }

    @Override
    protected String getCountField() {
        return "isoffsetNum";
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        Function<HyperLinkClickEvent, String> hyperLinkFunction = hyperLinkClickEvent -> {
            String linkEntity = "cfm_loanbill";
            return linkEntity;
        };
        return hyperLinkFunction;
    }

    @Override
    protected Boolean getIsRemoveNoDataFlag() {
        return Boolean.FALSE;
    }

    @Override
    protected String getNotNullFilterStr() {
        String filterStr = this.getFilterStr(this.getSumLists());
        return filterStr + " or (isoffsetNum != 0)";
    }

    protected static List<Object[]> getDetailColumnItemsExt(List<Object[]> fieldColumns) {
        PluginProxy pluginProxy = PluginProxy.create(IInterLoanDetailInterface.class, (String)"kd.sdk.tmc.tda.extpoint.interloan.IInterLoanDetailInterface.detailColumnItemsExt");
        List resultList = pluginProxy.callReplace(p -> p.detailColumnItemsExt(fieldColumns));
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty(resultList.get(0))) {
            logger.info("IInterLoanDetailInterface.detailColumnItemsExt \u4e0d\u4e3a\u7a7a\uff0c\u660e\u7ec6\u5217\u6570\uff1a" + ((List)resultList.get(0)).size());
            return (List)resultList.get(0);
        }
        logger.info("IInterLoanDetailInterface.detailColumnItemsExt \u62d3\u5c55\u8fd4\u56de\u4e3a\u7a7a");
        return fieldColumns;
    }

    protected static DataSet getDetailDataSetExt(DataSet result, Map<String, Object> paramMap) {
        PluginProxy pluginProxy = PluginProxy.create(IInterLoanDetailInterface.class, (String)"kd.sdk.tmc.tda.extpoint.interloan.IInterLoanDetailInterface.detailDataSetExt");
        List resultList = pluginProxy.callReplace(p -> p.detailDataSetExt(result, paramMap));
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty(resultList.get(0))) {
            logger.info("IInterLoanDetailInterface.detailDataSetExt \u4e0d\u4e3a\u7a7a");
            return (DataSet)resultList.get(0);
        }
        logger.info("IInterLoanDetailInterface.detailColumnItemsExt \u62d3\u5c55\u8fd4\u56de\u4e3a\u7a7a");
        return result;
    }
}

