/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.interloan.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.InterCompanyLoansTermHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceInterestBearLiaDisHelper;

public class BorrowTermDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ISOFFSET = "isoffset";
    private List<String> orderFields = new ArrayList<String>(32);
    private List<String> dataRangeValues = new ArrayList<String>(32);

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        boolean isDebit = this.isDebit(paramMap);
        String comloanRange = (String)paramMap.get("comloanrange");
        DataSet ds = InterCompanyLoansTermHelper.getInterLoanTermData((String)this.createAlgoKey(""), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, null, (boolean)isDebit, (String)comloanRange);
        if (!isDebit) {
            ds = ds.updateField("org", "creditor");
        }
        ds = ds.filter("isequity=false").select("org orgid,residueterm,exrepaymentdate,repayamount,rowoffset,coloffset,'' as datarange,0 as order,perpetualbond,'0' isoffset");
        ds = ds.updateField("repayamount", "repayamount + rowoffset");
        ds = FinanceInterestBearLiaDisHelper.getDataByResidueterm(ds, paramMap, true);
        DataSet allDs = this.groupby(ds.copy(), paramMap);
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        DataSet colOffsetDs = ds.copy().filter("coloffset < 0").updateFields(new String[]{"repayamount", "orgid", ISOFFSET}, new String[]{"coloffset", ((DynamicObject)parentOrgs.get(0)).getString("id"), "'1'"});
        colOffsetDs = this.groupby(colOffsetDs, paramMap);
        List<String> sumFields = this.getSumField(paramMap);
        allDs = this.unionOrgInfo(allDs, orgDs, sumFields, JoinType.RIGHT);
        colOffsetDs = this.unionOrgInfo(colOffsetDs, orgDs, sumFields, JoinType.LEFT).updateFields(new String[]{"sumlevel", "isgroupnode", "mixorgname"}, new String[]{"-1", "'0'", ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"FinanceTermDateDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])});
        DataSet sumDataSet = this.getSumDataSetByLevel(allDs, sumFields, "mixorgname,orgid,sortcode").filter("stat > 0").updateField("orgid", "rowid");
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("orgid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("stat > 0") : sumDataSet.filter("orgid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("stat > 0");
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"}).union(colOffsetDs.select(sumDataSet.getRowMeta().getFieldNames())).addField("'groupcol'", "groupcol");
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        return sumDataSet.union(totalSet);
    }

    private DataSet groupby(DataSet ds, Map<String, Object> paramMap) {
        int[] orders = (int[])paramMap.get("orderArray");
        StringBuilder sb = new StringBuilder("orgid,order,isoffset,repayamount as stat");
        for (int order : orders) {
            sb.append(",case when order=").append(order).append(" then repayamount else 0.0 end as order_").append(order);
        }
        ds = ds.select(sb.toString());
        GroupbyDataSet groupbyDataSet = ds.groupBy(new String[]{"orgid"});
        List<String> sumFields = this.getSumField(paramMap);
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        return groupbyDataSet.finish();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.orderFields, this.dataRangeValues})) {
            return columns;
        }
        int indexOfOverTime = this.orderFields.size() - 2;
        columns.add((AbstractReportColumn)this.createReportColumn(this.orderFields.get(indexOfOverTime), this.dataRangeValues.get(indexOfOverTime)));
        for (int i = 0; i < this.orderFields.size(); ++i) {
            if (i == indexOfOverTime) continue;
            columns.add((AbstractReportColumn)this.createReportColumn(this.orderFields.get(i), this.dataRangeValues.get(i)));
        }
        return columns;
    }

    private ReportColumn createReportColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setZeroShow(true);
        reportColumn.setScale(2);
        reportColumn.setCaption(new LocaleString(caption));
        return reportColumn;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(this.orderFields);
        return fields;
    }

    private List<String> getSumField(Map<String, Object> paramMap) {
        if (EmptyUtil.isNoEmpty(this.orderFields)) {
            return this.orderFields;
        }
        int[] orders = (int[])paramMap.get("orderArray");
        String[] dataRanges = (String[])paramMap.get("dataRangeArray");
        for (int order : orders) {
            this.orderFields.add("order_" + order);
            this.dataRangeValues.add(dataRanges[order]);
        }
        this.orderFields.add("stat");
        this.dataRangeValues.add(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"FinanceTermDateDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        return this.orderFields;
    }

    private boolean isDebit(Map<String, Object> paramMap) {
        Object isDebit = paramMap.get("isDebit");
        if (isDebit == null) {
            return false;
        }
        return (Boolean)isDebit;
    }

    private DataSet unionOrgInfo(DataSet ds, DataSet orgDs, List<String> sumFields, JoinType joinType) {
        return ds.join(orgDs, joinType).on("orgid", "orgid").select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
    }
}

