/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.interloan.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.helper.InterCompanyLoansDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.note.helper.DraftBillAmountHelper;

public class InterLoanBalanceHelper {
    private static final String REPAY_AMOUNT = "repayamount";
    private static final String REPAY_RATE_AMOUNT = "repayrateamount";
    public static final String ORG_IDS_KEY = "orgIdsKey";
    public static final String IS_DEBIT = "isDebit";
    private static final String PREFIX = "f";

    public static DataSet getAnlsDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get(ORG_IDS_KEY);
        boolean isDebit = (Boolean)paramMap.get(IS_DEBIT);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String comloanRange = (String)paramMap.get("comloanrange");
        DataSet allDs = InterCompanyLoansDataHelper.getInterCompanyLoanData((String)(InterLoanBalanceHelper.class.getName() + "getAnlsDataSet"), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (DataSet)orgDateSet, (boolean)isDebit, (String)comloanRange);
        allDs = allDs.select("repayamount + rowoffset + coloffset as repayamount, loanrate / 100 as loanrate").addField("repayamount * loanrate", REPAY_RATE_AMOUNT);
        allDs = allDs.groupBy().sum(REPAY_AMOUNT).sum(REPAY_RATE_AMOUNT).finish();
        return allDs.addField("case when repayamount is null or repayamount = 0 then 0.00 else repayrateamount / repayamount * 100 end", "avgrate");
    }

    public static DataSet getRptDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        boolean isDebit = (Boolean)paramMap.get(IS_DEBIT);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String comloanRange = (String)paramMap.get("comloanrange");
        DataSet allDs = InterCompanyLoansDataHelper.getInterCompanyLoanData((String)(InterLoanBalanceHelper.class.getName() + "getRptDataSet"), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (DataSet)orgDateSet.copy(), (boolean)isDebit, (String)comloanRange);
        if (!isDebit) {
            allDs = allDs.updateField("org", "creditor");
        }
        allDs = allDs.select("org as orgid,finproduct, repayamount, rowoffset, coloffset, loanrate / 100 as loanrate");
        allDs = allDs.addFields(new String[]{"repayamount * loanrate", "rowoffset * loanrate", "coloffset * loanrate"}, new String[]{REPAY_RATE_AMOUNT, "rowrateoffset", "colrateoffset"});
        allDs = allDs.groupBy(new String[]{"orgid", "finproduct"}).sum(REPAY_AMOUNT).sum(REPAY_RATE_AMOUNT).sum("rowoffset").sum("rowrateoffset").sum("coloffset").sum("colrateoffset").finish();
        RowMeta rowMeta = allDs.getRowMeta();
        if (allDs.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        DataSet[] splitDs = allDs.splitByFilter(new String[]{"true", "true"}, false);
        splitDs[0] = splitDs[0].select(new String[]{"orgid", "finproduct", "coloffset", "colrateoffset"});
        splitDs[0] = splitDs[0].filter(" orgid != " + orgId).updateField("orgid", "0L");
        splitDs[0] = splitDs[0].groupBy(new String[]{"orgid", "finproduct"}).sum("coloffset", REPAY_AMOUNT).sum("colrateoffset", REPAY_RATE_AMOUNT).finish();
        ArrayList<String> offNeedColFiled = new ArrayList<String>(16);
        List<String> offSumFields = Arrays.asList(REPAY_AMOUNT, REPAY_RATE_AMOUNT);
        DataSet offDs = DecisionAnlsHelper.typeGroupFiledSum(splitDs[0], "orgid", PREFIX, "finproduct", offSumFields, offNeedColFiled);
        String[] offField = DecisionAnlsHelper.getSelectField(offNeedColFiled);
        offDs = offDs.leftJoin(orgDateSet).on("orgid", "org").select(offField).finish();
        String mergeOffset = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"InterLoanBalanceHelper_1", (String)"tmc-tda-report", (Object[])new Object[0]);
        offDs = offDs.updateFields(new String[]{"mixorgname", "sumlevel", "isgroupnode"}, new String[]{'\'' + mergeOffset + '\'', "0", "'0'"});
        splitDs[1] = splitDs[1].updateFields(new String[]{REPAY_AMOUNT, REPAY_RATE_AMOUNT}, new String[]{"repayamount + rowoffset", "repayrateamount + rowrateoffset"});
        List<String> sumFields = Arrays.asList(REPAY_AMOUNT, REPAY_RATE_AMOUNT);
        ArrayList<String> needColFiled = new ArrayList<String>(16);
        DataSet upDs = DecisionAnlsHelper.typeGroupFiledSum(splitDs[1], "orgid", PREFIX, "finproduct", sumFields, needColFiled);
        String[] selectField = DecisionAnlsHelper.getSelectField(needColFiled);
        DataSet allOrgDs = orgDateSet.leftJoin(upDs).on("org", "orgid").select(selectField).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(allOrgDs, needColFiled, "orgid,mixorgname,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
            subOrgIds = (List)paramMap.get("allorgids");
        }
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            sumDataSet = sumDataSet.filter("rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds)).filter("total_repayamount > 0");
        }
        DataSet resultDs = sumDataSet.orderBy(new String[]{"sortcode"});
        ArrayList<String> allColFiled = new ArrayList<String>(16);
        allColFiled.addAll(needColFiled);
        allColFiled.removeAll(offNeedColFiled);
        String[] unionField = resultDs.getRowMeta().getFieldNames();
        offDs = offDs.addNullField(allColFiled.toArray(new String[0])).select(unionField).filter("total_repayamount != 0");
        resultDs = resultDs.union(offDs);
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(resultDs, needColFiled, "mixorgname");
        DataSet[] split = resultDs.splitByFilter(new String[]{"mixorgname = '" + mergeOffset + "'"}, true);
        ArrayList<String> rateAmtList = new ArrayList<String>(needColFiled.size());
        ArrayList<String> rateAmtExpr = new ArrayList<String>(needColFiled.size());
        for (String filed : needColFiled) {
            if (!filed.endsWith(REPAY_RATE_AMOUNT)) continue;
            rateAmtList.add(filed);
            rateAmtExpr.add("0.0");
        }
        split[0] = split[0].updateFields(rateAmtList.toArray(new String[0]), rateAmtExpr.toArray(new String[0]));
        DataSet result = split[1].union(split[0]).union(totalDataSet);
        result = InterLoanBalanceHelper.addAvgRate(result, needColFiled, (Set)paramMap.get("finproductId"), (List)paramMap.get("amountField"));
        return result;
    }

    private static DataSet addAvgRate(DataSet ds, List<String> needColFiled, Set<Long> finproductId, List<String> amountField) {
        needColFiled.forEach(f -> {
            if (f.endsWith(REPAY_AMOUNT) && f.startsWith(PREFIX)) {
                String productId = f.split(REPAY_AMOUNT)[0].substring(1);
                finproductId.add(Long.valueOf(productId));
            }
        });
        ArrayList<String> expr = new ArrayList<String>(finproductId.size());
        ArrayList<String> rateF = new ArrayList<String>(finproductId.size());
        ArrayList<String> removeF = new ArrayList<String>(finproductId.size());
        finproductId.forEach(f -> {
            String rateField = PREFIX + f + "rate";
            String repayAmount = PREFIX + f + REPAY_AMOUNT;
            String repayRateAmount = PREFIX + f + REPAY_RATE_AMOUNT;
            String exprStr = String.format("concat(case when %1$s is null or %1$s = 0 then 0.00 else round(%2$s/%1$s * 100, 2) end, '%%') as %3$s", repayAmount, repayRateAmount, rateField);
            rateF.add(rateField);
            expr.add(exprStr);
            removeF.add(repayRateAmount);
            amountField.add(repayAmount);
        });
        String exprStr = "concat(case when total_repayamount is null or total_repayamount = 0 then 0.00 else round(total_repayrateamount/total_repayamount  * 100, 2) end, '%') as total_rate";
        rateF.add("total_rate");
        expr.add(exprStr);
        removeF.add("total_repayrateamount");
        amountField.add("total_repayamount");
        ds = ds.addFields(expr.toArray(new String[0]), rateF.toArray(new String[0]));
        return ds.removeFields(removeF.toArray(new String[0]));
    }

    public static List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns, Set<Long> finproductId, String amtCaption) {
        QFilter filter = new QFilter("id", "in", finproductId);
        Map productsMap = BusinessDataServiceHelper.loadFromCache((String)"cfm_financingvarieties", (String)String.join((CharSequence)",", "id", "name"), (QFilter[])new QFilter[]{filter});
        for (Long productId : finproductId) {
            ReportColumnGroup group = new ReportColumnGroup();
            group.setHideSingleColumnRow(false);
            String prefix = PREFIX + productId;
            group.setFieldKey(prefix);
            String productName = ((DynamicObject)productsMap.get(productId)).getLocaleString("name").getLocaleValue();
            group.setCaption(new LocaleString(productName));
            DraftBillAmountHelper.buildReportColumn(group, prefix + REPAY_AMOUNT, amtCaption, "decimal");
            String cntCaption = ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u5229\u7387", (String)"InterLoanBalanceHelper_3", (String)"tmc-tda-report", (Object[])new Object[0]);
            DraftBillAmountHelper.buildReportColumn(group, prefix + "rate", cntCaption, "text");
            columns.add((AbstractReportColumn)group);
        }
        ReportColumnGroup group = new ReportColumnGroup();
        group.setHideSingleColumnRow(false);
        String prefix = "total";
        group.setFieldKey(prefix);
        LocaleString productName = new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InterLoanBalanceHelper_2", (String)"tmc-tda-report", (Object[])new Object[0]));
        group.setCaption(productName);
        DraftBillAmountHelper.buildReportColumn(group, prefix + "_repayamount", amtCaption, "decimal");
        String cntCaption = ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u5229\u7387", (String)"InterLoanBalanceHelper_3", (String)"tmc-tda-report", (Object[])new Object[0]);
        DraftBillAmountHelper.buildReportColumn(group, prefix + "_rate", cntCaption, "text");
        columns.add((AbstractReportColumn)group);
        return columns;
    }
}

