/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.interloan.qing.data;

import java.util.Collection;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.interloan.qing.data.AbstractInterLoanDataPlugin;

public class InterLoanDebtByProductDataPlugin
extends AbstractInterLoanDataPlugin {
    public static final String CFM_FINANCINGVARIETIES = "cfm_financingvarieties";
    private static String FINANCE_PRODUCT = "finproduct";
    private static final int TOP = 10;

    @Override
    protected String lendType() {
        return "org";
    }

    @Override
    protected String businessField() {
        return FINANCE_PRODUCT;
    }

    @Override
    protected String getFormId() {
        return "tda_borrowbalancerpt";
    }

    @Override
    protected void setLinkShowParameter(ReportShowParameter showParameter) {
        showParameter.setCaption(ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u878d\u8d44\u54c1\u79cd\u5206\u5e03\u8868-\u501f\u6b3e\u4eba", (String)"InterLoanDebitByProductDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
    }

    @Override
    protected DataSet afterDataSet(DataSet dataSet) {
        Set productIds = DecisionCommonHelper.getFieldValues((DataSet)dataSet.copy(), (String)FINANCE_PRODUCT, Long.class);
        DataSet productDataSet = this.getProductDataSet(productIds);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        dataSet = dataSet.leftJoin(productDataSet).on(FINANCE_PRODUCT, "id").select(fieldNames, new String[]{"name as businessTypeName"}).finish();
        dataSet = dataSet.orderBy(new String[]{"repayamount DESC"}).top(10);
        dataSet = dataSet.filter("repayamount != 0");
        return dataSet;
    }

    private DataSet getProductDataSet(Collection<Long> productIds) {
        return QueryServiceHelper.queryDataSet((String)this.createAlgoKey("product"), (String)CFM_FINANCINGVARIETIES, (String)String.join((CharSequence)",", "id", "number", "name"), (QFilter[])new QFilter("id", "in", productIds).toArray(), null);
    }
}

