/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.report.ReportList;
import kd.tmc.fbp.common.enums.CashTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.enums.InvestRevenueSortEnum;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestAmountDetailDataListPlugin
extends AbstractDetailDataPlugin {
    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"InvestAmountDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"investtype", ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u54c1\u79cd", (String)"InvestAmountDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(this.investTypeEnumItemList())});
        field.add(new Object[]{"investbillno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"InvestAmountDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankcatename", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"InvestAmountDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankname", ResManager.loadKDString((String)"\u5408\u4f5c\u91d1\u878d\u673a\u6784", (String)"InvestAmountDetailDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankaccountnumber", ResManager.loadKDString((String)"\u5b58\u6b3e\u8d26\u6237", (String)"InvestAmountDetailDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"InvestAmountDetailDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"InvestAmountDetailDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"initialamount", ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvestAmountDetailDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"initialamountrpt", ResManager.loadKDString((String)"\u91d1\u989d\u6298\u62a5\u544a\u5e01", (String)"InvestAmountDetailDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"originalamount", ResManager.loadKDString((String)"\u4f59\u989d", (String)"InvestAmountDetailDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u4f59\u989d\u6298\u62a5\u544a\u5e01", (String)"InvestAmountDetailDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u4f59\u989d\u65e5\u671f", (String)"InvestAmountDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"intdate", ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u671f", (String)"InvestAmountDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"expiredate", ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f", (String)"InvestAmountDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"term", ResManager.loadKDString((String)"\u671f\u9650", (String)"InvestAmountDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"customtype", ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b", (String)"InvestAmountDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(DateRangeEnum.valueMapItemList())});
        field.add(new Object[]{"date", ResManager.loadKDString((String)"\u671f\u95f4", (String)"InvestAmountDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"revenuesort", ResManager.loadKDString((String)"\u6536\u76ca\u7c7b\u522b", (String)"InvestAmountDetailDataListPlugin_25", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(InvestRevenueSortEnum.valueMapItemList())});
        field.add(new Object[]{"startdate", ResManager.loadKDString((String)"\u6536\u76ca\u8ba1\u7b97\u5f00\u59cb\u65e5\u671f", (String)"InvestAmountDetailDataListPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"enddate", ResManager.loadKDString((String)"\u6536\u76ca\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f", (String)"InvestAmountDetailDataListPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"days", ResManager.loadKDString((String)"\u5929\u6570", (String)"InvestAmountDetailDataListPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), "integer", false});
        field.add(new Object[]{"dayweight", ResManager.loadKDString((String)"\u5929\u6570\u6743\u91cd", (String)"InvestAmountDetailDataListPlugin_27", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"principle", ResManager.loadKDString((String)"\u8ba1\u606f\u672c\u91d1\u6298\u62a5\u544a\u5e01", (String)"InvestAmountDetailDataListPlugin_26", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"avgprinciple", ResManager.loadKDString((String)"\u5e73\u5747\u4f59\u989d\u6298\u62a5\u544a\u5e01", (String)"InvestAmountDetailDataListPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"expectprofit", ResManager.loadKDString((String)"\u6536\u76ca\u6298\u62a5\u544a\u5e01", (String)"InvestAmountDetailDataListPlugin_21", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"expectrate", ResManager.loadKDString((String)"\u6536\u76ca\u7387\uff08%\uff09", (String)"InvestAmountDetailDataListPlugin_23", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"isoffset", ResManager.loadKDString((String)"\u62b5\u6d88\u6807\u8bc6", (String)"InvestAmountDetailDataListPlugin_24", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        String customType = (String)paramMap.get("customtype");
        String dateType = (String)paramMap.get("datetype");
        DataSet ds = InvestDataHelper.getInvestDetailDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (DateRangeEnum)DateRangeEnum.ALL);
        String props = "id, company orgname, company, investtype, billno investbillno, bankcatename, bankname, bankaccountnumber,currencyname, rate, originalamount, amount, initialamount, initialamountrpt, bizdate, intdate, expiredate,term, initialrate, frate, isoffset,customtype,datetype,startdate,enddate,days,expectprofit,avgprinciple,expectrate,revenuesort,billtype,principle,dayweight,avgprinciple*expectrate rateamount,amount isoffset_amount, initialamountrpt isoffset_initialamountrpt";
        ds = ds.select(props);
        if (EmptyUtil.isNoEmpty((String)customType) || EmptyUtil.isNoEmpty((String)dateType)) {
            ds = ds.filter("customtype='" + customType + "' and " + "datetype" + "=" + dateType);
        }
        ds = ds.updateFields(new String[]{"amount", "initialamountrpt", "revenuesort"}, new String[]{"case when isoffset='1' then 0.0 else amount end", "case when isoffset='1' then 0.0 else initialamountrpt end", "case when billtype='10' and revenuesort='redeem_revenue' then 'deposit_redeem_revenue' else revenuesort end"});
        return InvestReportDataHelper.parseDateType(ds, queryDate);
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("amount", "initialamountrpt", "expectprofit", "avgprinciple", "rateamount", "isoffset_amount", "isoffset_initialamountrpt");
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("investbillno", "id");
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        Function<HyperLinkClickEvent, String> hyperLinkFunction = hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String investType = rowData.getString("investtype");
            String linkEntity = CashTypeEnum.FINANCE.getValue().equals(investType) ? "cim_finsubscribe" : (CashTypeEnum.NOTICE.getValue().equals(investType) ? "cim_noticedeposit" : (CashTypeEnum.FIX.getValue().equals(investType) || CashTypeEnum.STRUCT.getValue().equals(investType) || CashTypeEnum.HUGE.getValue().equals(investType) ? "cim_deposit" : "cim_finsubscribe"));
            return linkEntity;
        };
        return hyperLinkFunction;
    }

    @Override
    protected List<String> getOrderByList() {
        ArrayList<String> orderList = new ArrayList<String>(4);
        orderList.add("investtype");
        orderList.add("investbillno");
        orderList.add("startdate");
        orderList.add("revenuesort DESC");
        return orderList;
    }

    @Override
    protected DataSet beforeReturn(DataSet result) {
        return result.updateField("expectrate", "case when avgprinciple is null or avgprinciple=0 then 0.00 else rateamount/avgprinciple end");
    }

    private String[] investTypeEnumItemList() {
        InvestTypeEnum[] entityEnums = InvestTypeEnum.values();
        String[] array = new String[entityEnums.length * 2];
        int i = 0;
        for (InvestTypeEnum investTypeEnum : entityEnums) {
            array[i] = investTypeEnum.getValue();
            array[i + 1] = investTypeEnum.getName();
            i += 2;
        }
        return array;
    }
}

