/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestAmtSumDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String CUSTOM_TYPE = "customtype";
    private static final String DATE_TYPE = "datetype";
    private static final String INVEST_TYPE = "investtype";
    private static final String ORGID = "orgid";
    private static final String ROWID = "rowid";
    private static final String AMOUNT = "amount";
    private static final String PROFIT = "profit";
    private static final String RATEA_MOUNT = "rateamount";
    private static final String TOTAL_AMOUNT = "total_amount";
    private static final String TOTAL_PROFIT = "total_profit";
    private static final String TOTAL_RATEA_MOUNT = "total_rateamount";
    private List<String> sumFields;
    private List<String> amountFields;
    private List<String> rateAmountFields;
    private static final String AMOUNT_FIELD_NAMES = "amountFieldNames";
    private static final String RATE_AMOUNT_FIELD_NAMES = "rateAmountFieldNames";
    private static final String RATE_FIELD_NAMES = "rateFieldNames";

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        List orgIdSet = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allDs = InvestDataHelper.getInvestDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIdSet, (Date)queryDate, (Long)currencyId, (Long)orgViewId, (DateRangeEnum)DateRangeEnum.ALL);
        allDs = allDs.select("company orgid, investtype, customtype, datetype, avgprinciple amount, expectprofit profit, avgprinciple*expectrate rateamount");
        return allDs.groupBy(new String[]{ORGID, DATE_TYPE, CUSTOM_TYPE, INVEST_TYPE}).sum(AMOUNT).sum(PROFIT).sum(RATEA_MOUNT).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        dataSet = this.investTypeConvert(dataSet);
        if (!EmptyUtil.isEmpty(this.amountFields) && !EmptyUtil.isEmpty(this.rateAmountFields)) {
            paramMap.put(AMOUNT_FIELD_NAMES, this.amountFields.toArray(new String[0]));
            paramMap.put(RATE_AMOUNT_FIELD_NAMES, this.rateAmountFields.toArray(new String[0]));
        }
        dataSet = dataSet.filter("customtype = '" + InvestReportDataHelper.getCustomType(paramMap) + "'");
        Integer dateType = (Integer)paramMap.get(DATE_TYPE);
        dataSet = dataSet.filter("datetype = " + dateType);
        GroupbyDataSet groupSet = dataSet.groupBy(new String[]{ORGID});
        for (String fieldName : dataSet.getRowMeta().getFieldNames()) {
            if (!fieldName.endsWith(AMOUNT) && !fieldName.endsWith(PROFIT)) continue;
            groupSet.sum(fieldName);
        }
        dataSet = groupSet.finish();
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List<String> sumFields = this.getSumField(dataSet);
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet orgJoinSet = orgDateSet.leftJoin(dataSet).on(ROWID, ORGID).select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
        dataSet = this.getSumDataSetByLevel(orgJoinSet, sumFields, "sortcode,orgid,mixorgname");
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        dataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? dataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("total_amount > 0") : dataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("total_amount > 0");
        if ((dataSet = dataSet.orderBy(new String[]{"sortcode"}).addField("'groupcol'", "groupcol")).copy().isEmpty()) {
            queryParam.getCustomParam().put("isEmpty", true);
            return dataSet;
        }
        queryParam.getCustomParam().put("isEmpty", false);
        DataSet totalSet = this.addSubTotalDataSet(dataSet, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        DataSet resultDs = dataSet.union(totalSet);
        resultDs = this.addProfitFields(resultDs, paramMap, queryParam);
        return resultDs;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Object[] rateFieldNames = (String[])this.getQueryParam().getCustomParam().get(RATE_FIELD_NAMES);
        if (EmptyUtil.isEmpty((Object[])rateFieldNames)) {
            return columns;
        }
        List<ValueMapItem> investType = DecisionAnlsHelper.getEnumItemsByProperty("cim_investvarieties", INVEST_TYPE);
        Map<String, LocaleString> typeMap = investType.stream().collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName));
        typeMap.put("total", new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InvestRateTrendDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])));
        for (Object rateFieldName : rateFieldNames) {
            String[] splits = ((String)rateFieldName).split("_");
            String typeName = splits[0];
            ReportColumnGroup group = new ReportColumnGroup();
            group.setHideSingleColumnRow(false);
            group.setFieldKey(typeName);
            if (typeName != null) {
                group.setCaption(typeMap.get(typeName));
            } else {
                group.setCaption(new LocaleString(""));
            }
            InvestReportDataHelper.addChildren(group, typeName);
            columns.add((AbstractReportColumn)group);
        }
        return columns;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(36);
        if (EmptyUtil.isNoEmpty(this.sumFields)) {
            fields.addAll(this.sumFields);
        }
        return fields;
    }

    private DataSet investTypeConvert(DataSet allDs) {
        DataSet[] typeGroupSet = allDs.copy().splitByGroup(new String[]{INVEST_TYPE});
        DataSet baseSet = allDs.groupBy(new String[]{ORGID, DATE_TYPE, CUSTOM_TYPE}).sum(AMOUNT, TOTAL_AMOUNT).sum(PROFIT, TOTAL_PROFIT).sum(RATEA_MOUNT, TOTAL_RATEA_MOUNT).finish();
        this.amountFields = new ArrayList<String>(16);
        this.rateAmountFields = new ArrayList<String>(16);
        for (DataSet dataSet : typeGroupSet) {
            if (dataSet.isEmpty()) continue;
            Row row = dataSet.copy().next();
            String typeName = row.getString(INVEST_TYPE);
            dataSet = dataSet.groupBy(new String[]{ORGID, DATE_TYPE, CUSTOM_TYPE}).sum(AMOUNT, typeName + "_" + AMOUNT).sum(PROFIT, typeName + "_" + PROFIT).sum(RATEA_MOUNT, typeName + "_" + RATEA_MOUNT).finish();
            baseSet = baseSet.leftJoin(dataSet).on(ORGID, ORGID).on(DATE_TYPE, DATE_TYPE).on(CUSTOM_TYPE, CUSTOM_TYPE).select(baseSet.getRowMeta().getFieldNames(), new String[]{typeName + "_" + AMOUNT, typeName + "_" + PROFIT, typeName + "_" + RATEA_MOUNT}).finish();
            this.amountFields.add(typeName + "_" + AMOUNT);
            this.rateAmountFields.add(typeName + "_" + RATEA_MOUNT);
        }
        this.amountFields.add(TOTAL_AMOUNT);
        this.rateAmountFields.add(TOTAL_RATEA_MOUNT);
        return baseSet;
    }

    private List<String> getSumField(DataSet ds) {
        if (this.sumFields != null && !this.sumFields.isEmpty()) {
            return this.sumFields;
        }
        this.sumFields = new ArrayList<String>(64);
        for (String fieldName : ds.getRowMeta().getFieldNames()) {
            if (!fieldName.endsWith(AMOUNT) && !fieldName.endsWith(PROFIT)) continue;
            this.sumFields.add(fieldName);
        }
        return this.sumFields;
    }

    private DataSet addProfitFields(DataSet dataSet, Map<String, Object> paramMap, ReportQueryParam param) {
        Object[] amountFieldNames = (String[])paramMap.get(AMOUNT_FIELD_NAMES);
        String[] rateAmountFieldNames = (String[])paramMap.get(RATE_AMOUNT_FIELD_NAMES);
        if (EmptyUtil.isNoEmpty((Object[])amountFieldNames)) {
            int size = amountFieldNames.length;
            String[] rateFieldNames = new String[size];
            String[] rateFieldValues = new String[size];
            for (int i = 0; i < size; ++i) {
                Object amountName = amountFieldNames[i];
                String rateAmountName = rateAmountFieldNames[i];
                rateFieldNames[i] = ((String)amountName).substring(0, ((String)amountName).lastIndexOf(95)) + "_rate";
                String rateStr = String.format("case when (%1$s is null or %1$s=0) then 0.00 else round(%2$s/%1$s, 2) end", amountName, rateAmountName);
                rateFieldValues[i] = "concat(" + rateStr + ", ' %')";
            }
            param.getCustomParam().put(RATE_FIELD_NAMES, rateFieldNames);
            return dataSet.addFields(rateFieldValues, rateFieldNames);
        }
        return dataSet;
    }
}

