/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.CurrencyTypeEnum;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestCurrencyBalanceDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String COMPANY = "company";
    private static final String CURRENCY_NUMBER = "currencynumber";
    private static final String BALANCE = "balance";
    private static final String PROFIT = "profit";
    private static final String SUM_LEVEL = "sumlevel";
    private static final String IS_OFF_SET = "isoffset";
    private static final String TOTAL_BALANCE = "total_balance";
    private static final String TOTAL_PROFIT = "total_profit";
    private static final String _RATE = "_rate";
    private List<String> currencyFields;
    private List<String> balanceFields;
    private List<String> profitFields;
    private static final String RATE_FIELD_NAME = "rateFieldName";

    @Override
    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List orgIdSet = (List)paramMap.get("allorgids");
        DataSet allDs = InvestDataHelper.getInvestBalanceDataSet((String)this.createAlgoKey(""), (List)orgIdSet, (Date)queryDate, (Long)currencyId, (Long)orgViewId);
        String selectStr = "company, isoffset, amount as balance, frate, amount * frate as profit, case when currencynumber != 'CNY' and currencynumber != 'HKD' and currencynumber != 'USD' then 'other_' else concat(lower(currencynumber),'_') end as currencynumber, case when currencynumber = 'CNY' then 0 when currencynumber = 'USD' then 1 when currencynumber = 'HKD' then 2 else 3 end as currencysort";
        DataSet allDataSet = allDs.select(selectStr);
        return this.currencyTypeConvert(allDataSet);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List orgIdSet = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)orgIdSet) && orgIdSet.size() > 1) {
            orgIdSet.remove(orgId);
        }
        DataSet offsetDs = ds.copy().filter("isoffset='1'").filter("company in suborgids", Collections.singletonMap("suborgids", orgIdSet)).updateField(COMPANY, orgId.toString());
        offsetDs = this.groupby(offsetDs, new String[]{COMPANY});
        List<String> fieldList = this.getOrgFieldList();
        List<String> fields = this.getBalanceFields();
        fieldList.addAll(fields);
        String[] selectFields = fieldList.toArray(new String[fieldList.size()]);
        offsetDs = offsetDs.leftJoin(orgDateSet).on(COMPANY, "org").select(selectFields).finish();
        for (String field : this.balanceFields) {
            String fieldRate = field.substring(0, field.lastIndexOf(95)) + _RATE;
            offsetDs = offsetDs.addField("''", fieldRate);
            offsetDs = offsetDs.updateField(field, field + " * (-1)");
        }
        for (String field : this.profitFields) {
            offsetDs = offsetDs.updateField(field, field + " * (-1)");
        }
        String mergeOffset = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"InvestCurrencyDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
        offsetDs = offsetDs.updateFields(new String[]{"orgname", SUM_LEVEL, "isgroupnode"}, new String[]{'\'' + mergeOffset + '\'', "0", "'0'"});
        DataSet allDs = this.groupby(ds, new String[]{COMPANY});
        DataSet allOrgDs = orgDateSet.leftJoin(allDs).on("org", COMPANY).select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(allOrgDs, fields, "orgname,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
            subOrgIds = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds)).filter("total_balance> 0");
        fieldList.set(0, "orgname");
        DataSet resultSet = sumDataSet.select(fieldList.toArray(new String[0]));
        resultSet = resultSet.orderBy(new String[]{"sortcode"});
        resultSet = this.addOrUpdateProfitRate(resultSet, true, queryParam).union(offsetDs);
        resultSet = resultSet.filter("total_balance != 0 and total_balance != null");
        DataSet sDataSet = DecisionAnlsHelper.addAllTotalDataSet(resultSet, fields, "orgname");
        sDataSet = this.addOrUpdateProfitRate(sDataSet, false, queryParam);
        return resultSet.union(sDataSet).addField("rowid", "orgid");
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Object[] rateFieldNames = (String[])this.getQueryParam().getCustomParam().get(RATE_FIELD_NAME);
        if (EmptyUtil.isEmpty((Object[])rateFieldNames)) {
            return columns;
        }
        HashMap<String, LocaleString> typeMap = new HashMap<String, LocaleString>(16);
        for (String currencyField : this.currencyFields) {
            CurrencyTypeEnum currencyTypeEnum = CurrencyTypeEnum.valueOf((String)currencyField.toUpperCase());
            typeMap.put(currencyField, new LocaleString(currencyTypeEnum.getName()));
        }
        typeMap.put("total", new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InvestCurrencyDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0])));
        for (Object rateFieldName : rateFieldNames) {
            String[] splits = ((String)rateFieldName).split("_");
            String typeName = splits[0];
            ReportColumnGroup group = new ReportColumnGroup();
            group.setHideSingleColumnRow(false);
            group.setFieldKey(typeName);
            if (typeName != null) {
                group.setCaption((LocaleString)typeMap.get(typeName));
            } else {
                group.setCaption(new LocaleString(""));
            }
            this.addChildren(group, typeName);
            columns.add((AbstractReportColumn)group);
        }
        return columns;
    }

    private void addChildren(ReportColumnGroup group, String typeName) {
        this.buildReportColumn(group, typeName + "_balance", ResManager.loadKDString((String)"\u4f59\u989d", (String)"InvestCurrencyDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal");
        this.buildReportColumn(group, typeName + _RATE, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u7387", (String)"InvestCurrencyDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text");
    }

    private void buildReportColumn(ReportColumnGroup group, String fieldKey, String caption, String fieldType) {
        ReportColumn newCol = new ReportColumn();
        newCol.setHideSingleColumnRow(false);
        newCol.setFieldKey(fieldKey);
        newCol.setFieldType(fieldType);
        newCol.setScale(2);
        newCol.setZeroShow(true);
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign("right");
        newCol.setStyle(style);
        newCol.setCaption(new LocaleString(caption));
        group.getChildren().add(newCol);
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.balanceFields);
    }

    private DataSet currencyTypeConvert(DataSet ds) {
        DataSet[] groupDataSet = ds.copy().splitByGroup(new String[]{CURRENCY_NUMBER});
        DataSet baseSet = ds.groupBy(new String[]{COMPANY, IS_OFF_SET}).sum(BALANCE, TOTAL_BALANCE).sum(PROFIT, TOTAL_PROFIT).finish();
        this.currencyFields = new ArrayList<String>(6);
        this.balanceFields = new ArrayList<String>(6);
        this.profitFields = new ArrayList<String>(6);
        TreeMap<Integer, String> balanceMap = new TreeMap<Integer, String>();
        TreeMap<Integer, String> profitMap = new TreeMap<Integer, String>();
        for (DataSet dataSet : groupDataSet) {
            if (dataSet.isEmpty()) continue;
            Row row = dataSet.next();
            String currencyName = row.getString(CURRENCY_NUMBER);
            Integer currencySort = row.getInteger("currencysort");
            this.currencyFields.add(currencyName.substring(0, currencyName.length() - 1));
            balanceMap.put(currencySort, currencyName + BALANCE);
            profitMap.put(currencySort, currencyName + PROFIT);
        }
        balanceMap.forEach((k, v) -> this.balanceFields.add((String)v));
        profitMap.forEach((k, v) -> this.profitFields.add((String)v));
        List<String> amountFieldName = Arrays.asList(BALANCE, PROFIT);
        DataSet groupDS = ds.select(new String[]{COMPANY, IS_OFF_SET, CURRENCY_NUMBER, BALANCE, PROFIT}).groupBy(new String[]{COMPANY, IS_OFF_SET, CURRENCY_NUMBER}).sum(BALANCE).sum(PROFIT).finish();
        DataSet changeSet = DecisionAnlsHelper.ChangeMultRowToColDataSet(groupDS, CURRENCY_NUMBER, "company,isoffset", "", amountFieldName);
        DataSet groupByDS = this.groupby(changeSet, new String[]{COMPANY, IS_OFF_SET});
        groupByDS = groupByDS.leftJoin(baseSet).on(COMPANY, COMPANY).on(IS_OFF_SET, IS_OFF_SET).select(groupByDS.getRowMeta().getFieldNames(), new String[]{TOTAL_BALANCE, TOTAL_PROFIT}).finish();
        this.balanceFields.add(TOTAL_BALANCE);
        this.profitFields.add(TOTAL_PROFIT);
        return groupByDS;
    }

    private DataSet groupby(DataSet ds, String[] groups) {
        GroupbyDataSet groupByDS = ds.groupBy(groups);
        for (String balanceField : this.balanceFields) {
            groupByDS.sum(balanceField);
        }
        for (String profitField : this.profitFields) {
            groupByDS.sum(profitField);
        }
        return groupByDS.finish();
    }

    private List<String> getOrgFieldList() {
        return Stream.of("mixorgname as orgname", "0 sumlevel", "rowid", "pid", "level", "isgroupnode", "sortcode").collect(Collectors.toList());
    }

    private List<String> getBalanceFields() {
        ArrayList<String> fields = new ArrayList<String>(this.balanceFields);
        fields.addAll(this.profitFields);
        return fields;
    }

    private DataSet addOrUpdateProfitRate(DataSet dataSet, boolean addFlag, ReportQueryParam queryParam) {
        int size = this.balanceFields.size();
        String[] rateFieldNames = new String[size];
        String[] rateFieldValues = new String[size];
        for (int i = 0; i < size; ++i) {
            String balanceName = this.balanceFields.get(i);
            String profitName = this.profitFields.get(i);
            rateFieldNames[i] = balanceName.substring(0, balanceName.lastIndexOf(95)) + _RATE;
            String rateStr = String.format("case when (%1$s is null or %1$s=0) then 0.00 else round(%2$s/%1$s, 2) end", balanceName, profitName);
            rateFieldValues[i] = "concat(" + rateStr + ", ' %')";
        }
        if (addFlag) {
            queryParam.getCustomParam().put(RATE_FIELD_NAME, rateFieldNames);
            return dataSet.addFields(rateFieldValues, rateFieldNames);
        }
        return dataSet.updateFields(rateFieldNames, rateFieldValues);
    }
}

