/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestTermBalHelper;

public class InvestTermBalDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String TERM_TYPE = "termType";
    private static final String ORGID = "orgid";
    private static final String BALANCE = "balance";
    private static final String TERM_NUMBER = "termnumber";
    private static final String IS_OFF_SET = "isoffset";
    private static final String TOTAL_BALANCE = "total_balance";
    private static final String BALANCE_FIELD_PREFIX = "section_";
    private final List<String> balanceFields = new ArrayList<String>(InvestTermBalHelper.TERM_ENUMS.size() + 2);

    public InvestTermBalDataListPlugin() {
        InvestTermBalHelper.TERM_ENUMS.forEach(e -> this.balanceFields.add(BALANCE_FIELD_PREFIX + e.getNumber() + BALANCE));
        this.balanceFields.add(TOTAL_BALANCE);
    }

    @Override
    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List orgIdSet = (List)paramMap.get("allorgids");
        DataSet sourceDs = InvestDataHelper.getInvestBalanceDataSet((String)this.createAlgoKey(""), (List)orgIdSet, (Date)queryDate, (Long)currencyId, (Long)orgViewId).filter("residueterm != '-1d'");
        String needField = "company as orgid, isoffset, amount as balance";
        String termType = (String)paramMap.get(TERM_TYPE);
        needField = "original".equals(termType) ? needField + ", term" : needField + ", residueterm as term";
        sourceDs = sourceDs.select(needField);
        DataSet sectionDs = InvestTermBalHelper.handleDataSet(sourceDs, false);
        DataSet allDs = this.orgTermSectionSum(sectionDs.copy());
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String[] selectField = DecisionAnlsHelper.getSelectField(this.balanceFields);
        String resultField = "mixorgname, orgid, isgroupnode, sumlevel,sortcode," + String.join((CharSequence)",", this.balanceFields);
        DataSet offsetOrgDS = this.getMergeOffsetDS(sectionDs, orgDateSet, paramMap, selectField);
        offsetOrgDS = offsetOrgDS.select(resultField);
        DataSet allOrgDs = orgDateSet.leftJoin(allDs).on(ORGID, ORGID).select(selectField).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(allOrgDs, this.balanceFields, "orgid,sortcode,mixorgname");
        List subOrgIds = (List)paramMap.get("suborgids");
        if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
            subOrgIds = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds)).filter("total_balance> 0");
        DataSet resultSet = sumDataSet.select(resultField);
        resultSet = resultSet.orderBy(new String[]{"sortcode"});
        resultSet = resultSet.union(offsetOrgDS).filter("total_balance != 0 and total_balance != null");
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(resultSet, this.balanceFields, "mixorgname");
        return resultSet.union(totalDataSet);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ArrayList<String> dataRangeChineseList = new ArrayList<String>(InvestTermBalHelper.TERM_SECTION);
        dataRangeChineseList.add(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InvestTermBalDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        int count = 0;
        for (String dataRange : this.balanceFields) {
            ReportColumn newReportColumn = new ReportColumn();
            newReportColumn.setFieldKey(dataRange);
            newReportColumn.setFieldType("decimal");
            newReportColumn.setZeroShow(true);
            newReportColumn.setScale(2);
            ColumnStyle style = new ColumnStyle();
            style.setTextAlign("right");
            newReportColumn.setStyle(style);
            newReportColumn.setCaption(new LocaleString((String)dataRangeChineseList.get(count)));
            columns.add((AbstractReportColumn)newReportColumn);
            ++count;
        }
        return columns;
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.balanceFields);
    }

    private DataSet orgTermSectionSum(DataSet ds) {
        DataSet[] groupDataSet = ds.copy().splitByGroup(new String[]{TERM_NUMBER});
        ArrayList<String> needAddSection = new ArrayList<String>(this.balanceFields);
        DataSet baseSet = ds.select(new String[]{ORGID, TERM_NUMBER, BALANCE}).groupBy(new String[]{ORGID, TERM_NUMBER}).sum(BALANCE, TOTAL_BALANCE).finish();
        needAddSection.remove(TOTAL_BALANCE);
        for (DataSet dataSet : groupDataSet) {
            if (dataSet.isEmpty()) continue;
            Row row = dataSet.copy().next();
            String termNumber = row.getString(TERM_NUMBER);
            String field = BALANCE_FIELD_PREFIX + termNumber + BALANCE;
            dataSet = dataSet.groupBy(new String[]{ORGID, TERM_NUMBER}).sum(BALANCE, field).finish();
            baseSet = baseSet.leftJoin(dataSet).on(ORGID, ORGID).on(TERM_NUMBER, TERM_NUMBER).select(baseSet.getRowMeta().getFieldNames(), new String[]{field}).finish();
            needAddSection.remove(field);
        }
        for (String field : needAddSection) {
            baseSet = baseSet.addField("0.0", field);
        }
        return this.groupSum(baseSet, new String[]{ORGID});
    }

    private DataSet getMergeOffsetDS(DataSet sectionDs, DataSet orgDateSet, Map<String, Object> paramMap, String[] selectField) {
        List orgIdSet = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)orgIdSet) && orgIdSet.size() > 1) {
            orgIdSet.remove(orgId);
        }
        DataSet offsetDs = sectionDs.filter("isoffset='1'").filter("orgid in suborgids", Collections.singletonMap("suborgids", orgIdSet)).updateField(ORGID, orgId.toString());
        DataSet offsetSumDs = this.orgTermSectionSum(offsetDs);
        offsetSumDs = this.groupSum(offsetSumDs, new String[]{ORGID});
        for (String field : this.balanceFields) {
            offsetSumDs = offsetSumDs.updateField(field, field + " * (-1)");
        }
        offsetSumDs = offsetSumDs.leftJoin(orgDateSet.copy()).on(ORGID, ORGID).select(selectField).finish();
        String offsetName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"InvestTermBalDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
        return offsetSumDs.updateFields(new String[]{"mixorgname", "sumlevel", "isgroupnode"}, new String[]{'\'' + offsetName + '\'', "0", "'0'"});
    }

    private DataSet groupSum(DataSet ds, String[] groups) {
        GroupbyDataSet groupByDS = ds.groupBy(groups);
        for (String balanceField : this.balanceFields) {
            groupByDS.sum(balanceField);
        }
        return groupByDS.finish();
    }
}

