/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;

public class InvestBalanceOtherBankFormPlugin
extends AbstractReportFormPlugin {
    private static final String DISPLAY_TYPE = "displayType";
    private static final String AMOUNTRATE = "amountrate";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter fsp = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = fsp.getCustomParams();
        queryParam.getFilter().addFilterItem("parent_id", customParams.get("parent_id"));
        queryParam.getFilter().addFilterItem("current_org_id", customParams.get("current_org_id"));
        queryParam.getFilter().addFilterItem(DISPLAY_TYPE, customParams.get(DISPLAY_TYPE));
        return super.verifyQuery(queryParam);
    }

    public void processRowData(String gridPk, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPk, rowData, queryParam);
        for (DynamicObject row : rowData) {
            BigDecimal rateBigDecimal = StringUtils.isEmpty((String)row.getString(AMOUNTRATE)) ? BigDecimal.ZERO : row.getBigDecimal(AMOUNTRATE);
            String showStr = rateBigDecimal.setScale(2, RoundingMode.HALF_UP) + " %";
            row.set(AMOUNTRATE, (Object)showStr);
        }
    }
}

