/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class InvestBankBalanceFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ORGID = "orgid";
    private static final String FILTER = "filter";
    private static final String DISPLAY_TYPE = "displayType";
    private static final String PREFIX = "bankcate_";
    private static final String FILTER_COMPANY = "filter_company";
    private static final String[] colArr = new String[]{"stat", "mixorgname", "bankcate_1amount", "bankcate_3amount", "bankcate_stat"};

    public void processRowData(String gridPk, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPk, rowData, queryParam);
        Iterator iterator = rowData.iterator();
        Set<String> showColName = this.getRateColName(rowData);
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            for (String colName : showColName) {
                if ("3".equals(row.getString("sumlevel")) && !"bankcate_3amount".equals(colName) && !"bankcate_1amount".equals(colName) && !"bankcate_stat".equals(colName)) {
                    row.set(colName, (Object)" ");
                    continue;
                }
                InvestBankBalanceFormPlugin.setCellShow(colName, row);
            }
        }
    }

    private static void setCellShow(String colName, DynamicObject row) {
        BigDecimal rateBigDecimal = StringUtils.isEmpty((String)row.getString(colName)) ? BigDecimal.ZERO : row.getBigDecimal(colName);
        String showStr = rateBigDecimal.setScale(2, RoundingMode.HALF_UP).toString();
        if (colName.endsWith("amountrate") || "bankcate_statrate".equals(colName) || "bankcate_sumrate".equals(colName)) {
            showStr = showStr + " %";
        }
        row.set(colName, (Object)showStr);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("btn_showdetail")) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Long orgId = Long.valueOf((String)formShowParameter.getCustomParam(ORGID));
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                Pair pluginPair = (Pair)pluginInfo.get("plugin");
                param.setCaption((String)pluginPair.getValue1());
            }
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String isGroupNode = row.getString("isgroupnode");
        long orgid = row.getLong(ORGID);
        String fieldName = event.getFieldName();
        if (EmptyUtil.isNoEmpty((String)fieldName) && fieldName.startsWith(PREFIX)) {
            ReportShowParameter param = new ReportShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)this.getQueryParam());
            long parentId = ((DynamicObject)((DynamicObjectCollection)paramMap.get(FILTER_COMPANY)).get(0)).getLong("id");
            param.getCustomParams().put("parent_id", Long.toString(parentId));
            if (EmptyUtil.isEmpty((Long)orgid)) {
                param.getCustomParams().put("current_org_id", Long.toString(parentId));
            } else {
                param.getCustomParams().put("current_org_id", Long.toString(orgid));
            }
            if (this.getView().getFormShowParameter().getCustomParams().get("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            }
            param.setFormId("tda_investbalotherbankrpt");
            if ("bankcate_0amount".equals(fieldName)) {
                param.getCustomParams().put(DISPLAY_TYPE, "bank");
                param.setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u5176\u4ed6\u94f6\u884c\u4f59\u989d\u5206\u5e03", (String)"InvestBankBalanceFormPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
            } else {
                param.getCustomParams().put(DISPLAY_TYPE, "finance");
                param.setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u5176\u4ed6\u91d1\u878d\u673a\u6784\u5206\u5e03", (String)"InvestBankBalanceFormPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
            }
            this.getView().showForm((FormShowParameter)param);
            return;
        }
        if (EmptyUtil.isEmpty((Long)orgid) || !"1".equals(isGroupNode)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(ORGID, Long.toString(orgid));
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        param.getCustomParams().put(DISPLAY_TYPE, customParams.get(DISPLAY_TYPE));
        param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        param.getCustomParams().put("next", Boolean.TRUE);
        param.setFormId(formShowParameter.getFormId());
        param.setCaption(formShowParameter.getCaption());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject row = packageDataEvent.getRowData();
        String isGroupNode = row.getString("isgroupnode");
        Object formatValue = packageDataEvent.getFormatValue();
        String fieldKey = ((ReportColumn)packageDataEvent.getSource()).getFieldKey();
        if (fieldKey.startsWith(PREFIX)) {
            return;
        }
        if (formatValue != null && !"1".equals(isGroupNode)) {
            packageDataEvent.getNoLinkKey().add(fieldKey);
        }
    }

    private Set<String> getRateColName(DynamicObjectCollection rowData) {
        DataEntityPropertyCollection properties = rowData.getDynamicObjectType().getProperties();
        return properties.stream().filter(r -> StringUtils.isNotEmpty((String)r.getName()) && r.getName().startsWith("bank")).map(IMetadata::getName).collect(Collectors.toSet());
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        for (String col : colArr) {
            CellStyleRule cellStyleRule = new CellStyleRule();
            cellStyleRule.setFieldKey(col);
            cellStyleRule.setForeColor("red");
            cellStyleRule.setCondition("sumlevel = '3'");
            cellStyleRules.add(cellStyleRule);
        }
        super.setCellStyleRules(cellStyleRules);
    }
}

