/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestReportDataHelper {
    public static final String TMC_TDA_REPORT = "tmc-tda-report";
    public static final String CUSTOM_TYPE = "customtype";
    public static final String DATE_TYPE = "datetype";
    public static final String DATE = "date";
    public static final String INVEST_TYPE = "investtype";

    public static DataSet parseDateType(DataSet dataset, Date queryDate) {
        dataset = dataset.addField("'0'", DATE);
        final String[] dateArray = FinanceCostDateHelper.parseNewDateType((Date)queryDate);
        final RowMeta rowMetas = dataset.getRowMeta();
        dataset = dataset.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    Integer dateType = row.getInteger(InvestReportDataHelper.DATE_TYPE);
                    if (InvestReportDataHelper.DATE.equals(fieldName) && dateType != null) {
                        rowInfo.add(dateArray[dateType]);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return dataset;
    }

    public static String getCustomType(Map<String, Object> paramMap) {
        String type = (String)paramMap.get(CUSTOM_TYPE);
        if (EmptyUtil.isNoEmpty((String)type) && (DateRangeEnum.YEAR.getValue().equals(type) || DateRangeEnum.HALF_YEAR.getValue().equals(type) || DateRangeEnum.SEASON.getValue().equals(type) || DateRangeEnum.MONTH.getValue().equals(type))) {
            return type;
        }
        return DateRangeEnum.MONTH.getValue();
    }

    public static DataSet parseInvestType(DataSet dataSet) {
        List<ValueMapItem> investType = DecisionAnlsHelper.getEnumItemsByProperty("cim_investvarieties", INVEST_TYPE);
        final Map<String, LocaleString> typeMap = investType.stream().collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName));
        final RowMeta rowMetas = dataSet.getRowMeta();
        dataSet = dataSet.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(16);
                for (String fieldName : rowMetas.getFieldNames()) {
                    String investType = row.getString(InvestReportDataHelper.INVEST_TYPE);
                    if (InvestReportDataHelper.INVEST_TYPE.equals(fieldName) && investType != null) {
                        rowInfo.add(((LocaleString)typeMap.get(investType)).getLocaleValue());
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return dataSet;
    }

    public static void addChildren(ReportColumnGroup group, String fieldKeyPrefix) {
        InvestReportDataHelper.buildReportColumn(group, fieldKeyPrefix + "_amount", ResManager.loadKDString((String)"\u7d2f\u8ba1\u91d1\u989d", (String)"InvestReportDataHelper_3", (String)TMC_TDA_REPORT, (Object[])new Object[0]), "decimal");
        InvestReportDataHelper.buildReportColumn(group, fieldKeyPrefix + "_profit", ResManager.loadKDString((String)"\u6536\u76ca", (String)"InvestReportDataHelper_1", (String)TMC_TDA_REPORT, (Object[])new Object[0]), "decimal");
        InvestReportDataHelper.buildReportColumn(group, fieldKeyPrefix + "_rate", ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387", (String)"InvestReportDataHelper_2", (String)TMC_TDA_REPORT, (Object[])new Object[0]), "text");
    }

    private static void buildReportColumn(ReportColumnGroup group, String fieldKey, String caption, String fieldType) {
        ReportColumn newCol = new ReportColumn();
        newCol.setHideSingleColumnRow(false);
        newCol.setFieldKey(fieldKey);
        newCol.setFieldType(fieldType);
        newCol.setScale(2);
        newCol.setZeroShow(true);
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign("right");
        newCol.setStyle(style);
        newCol.setCaption(new LocaleString(caption));
        group.getChildren().add(newCol);
    }
}

