/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.tmc.tda.common.enums.InvestTermEnum;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestTermBalHelper {
    private static final String TERM = "term";
    private static final String BALANCE = "balance";
    private static final String TERM_NUMBER = "termnumber";
    public static final List<InvestTermEnum> TERM_ENUMS = Arrays.asList(InvestTermEnum.WITHIN_ONE_MONTH, InvestTermEnum.ONE_TWO_MONTH, InvestTermEnum.TWO_THREE_MONTH, InvestTermEnum.THREE_SIX_MONTH, InvestTermEnum.SIX_MONTH_ONE_YEAR, InvestTermEnum.MORE_THEN_ONE_YEAR, InvestTermEnum.DATELESS);
    public static final List<String> TERM_SECTION = Arrays.asList(InvestTermEnum.WITHIN_ONE_MONTH.getText(), InvestTermEnum.ONE_TWO_MONTH.getText(), InvestTermEnum.TWO_THREE_MONTH.getText(), InvestTermEnum.THREE_SIX_MONTH.getText(), InvestTermEnum.SIX_MONTH_ONE_YEAR.getText(), InvestTermEnum.MORE_THEN_ONE_YEAR.getText(), InvestTermEnum.DATELESS.getText());

    public static DataSet handleDataSet(DataSet ds, boolean qingAnls) {
        ds = ds.addField("0", TERM_NUMBER);
        final RowMeta rowMetas = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(10);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (InvestTermBalHelper.TERM_NUMBER.equals(fieldName)) {
                        String term = row.getString(InvestTermBalHelper.TERM);
                        InvestTermEnum termEnum = InvestTermEnum.getInvestTermEnum((String)term);
                        if (termEnum != null) {
                            rowInfo.add(Integer.parseInt(termEnum.getNumber()));
                            continue;
                        }
                        rowInfo.add(row.get(fieldName));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        ds = ds.filter("termnumber != 0");
        if (qingAnls) {
            ds = ds.groupBy(new String[]{TERM_NUMBER}).sum(BALANCE).finish();
            ds = InvestTermBalHelper.dealEmptyRow(ds);
            String term = "case when termnumber=1 then '%1$s' when termnumber=2 then '%2$s' when termnumber=3 then '%3$s' when termnumber=4 then '%4$s' when termnumber=5 then '%5$s' when termnumber=6 then '%6$s' when termnumber=7 then '%7$s' end";
            String sic = String.format(term, TERM_ENUMS.get(0).getText(), TERM_ENUMS.get(1).getText(), TERM_ENUMS.get(2).getText(), TERM_ENUMS.get(3).getText(), TERM_ENUMS.get(4).getText(), TERM_ENUMS.get(5).getText(), TERM_ENUMS.get(6).getText());
            ds = ds.addField(sic, TERM);
        }
        return ds;
    }

    private static DataSet dealEmptyRow(DataSet ds) {
        if (DecisionAnlsHelper.checkEmptyAndClose(ds.copy())) {
            return ds;
        }
        RowMeta rowMeta = ds.getRowMeta();
        for (InvestTermEnum termEnum : TERM_ENUMS) {
            if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter("termnumber=" + termEnum.getNumber()))) continue;
            DataSet bizDs = DecisionAnlsHelper.createRow(InvestTermBalHelper.class.getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{termEnum.getNumber(), 0}));
            ds = ds.union(bizDs);
        }
        return ds;
    }
}

