/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.InvestCostDateHelper;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestAmtBankQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String BANKNAME = "bankname";
    private static final String AMOUNT = "amount";
    private static final String PROFIT = "profit";
    private static final String RATEAMT = "rateamt";
    private static final String PROFIT_RATE = "profitrate";
    private static final String CUSTOM_TYPE = "customtype";
    private static final String DATE = "date";
    private static final String DATE_TYPE = "datetype";
    private static final String CLICK = "click";
    private static final int TOP = 10;

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{BANKNAME, ResManager.loadKDString((String)"\u673a\u6784\u540d\u79f0", (String)"InvestBankAmtQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u7d2f\u8ba1\u91d1\u989d", (String)"InvestBankAmtQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{PROFIT, ResManager.loadKDString((String)"\u6536\u76ca", (String)"InvestBankAmtQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{PROFIT_RATE, ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387", (String)"InvestBankAmtQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"InvestBankAmtQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{CUSTOM_TYPE, ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b", (String)"InvestBankAmtQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{DATE, ResManager.loadKDString((String)"\u671f\u95f4", (String)"InvestBankAmtQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{DATE_TYPE, ResManager.loadKDString((String)"\u671f\u95f4\u6392\u5e8f", (String)"InvestBankAmtQingAnlsPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{CLICK, ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"InvestBankAmtQingAnlsPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = InvestDataHelper.getInvestDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (DateRangeEnum)DateRangeEnum.ALL);
        ds = ds.select("finorgtype,customtype,datetype,bankcatename bankname,bankcateid bankcate,avgprinciple amount,expectprofit profit,avgprinciple*expectrate rateamt").groupBy(new String[]{"finorgtype", CUSTOM_TYPE, DATE_TYPE, BANKNAME, "bankcate"}).sum(AMOUNT).sum(PROFIT).sum(RATEAMT).finish();
        return InvestReportDataHelper.parseDateType(ds, queryDate);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        DataSet unionDs;
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)CUSTOM_TYPE, (String)DATE);
        String customType = (String)typeLinkValue.getValue0();
        String date = (String)typeLinkValue.getValue1();
        DataSet filterDs = InvestCostDateHelper.getAfterFilterDataSet((DataSet)ds, (String)customType, (Boolean)true, (String)date, filterParam);
        DataSet[] splitDataSets = filterDs.splitByFilter(new String[]{"finorgtype = '0'", "finorgtype = '3'", "finorgtype = '1'"}, true);
        Pair<DataSet, DataSet> topBankDsPair = DecisionAnlsHelper.splitTopBank(splitDataSets[0], AMOUNT, 10);
        DataSet topBankDs = this.groupBy((DataSet)topBankDsPair.getValue0()).orderBy(new String[]{"amount desc"});
        if (topBankDsPair.getValue1() != null) {
            DataSet otherBankDs = this.groupBy(((DataSet)topBankDsPair.getValue1()).updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"InvestBankAmtQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])));
            unionDs = topBankDs.union(otherBankDs);
        } else {
            unionDs = topBankDs;
        }
        DataSet financeDataSet = this.groupBy(splitDataSets[1].updateField(BANKNAME, "'" + FinOrgTypeEnum.FINCOMP.getName() + "'"));
        DataSet clearingHouseSet = this.groupBy(splitDataSets[2].updateField(BANKNAME, "'" + FinOrgTypeEnum.CLEARINGHOUSE.getName() + "'"));
        DataSet otherFinorgDataSet = this.groupBy(splitDataSets[3].updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u91d1\u878d\u673a\u6784'", (String)"InvestBankAmtQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0])));
        unionDs = unionDs.union(new DataSet[]{financeDataSet, clearingHouseSet, otherFinorgDataSet});
        return unionDs.addFields(new String[]{"case when (amount=0 or amount is null) then 0.0 else rateamt/amount end", "concat(customtype,'_',datetype)"}, new String[]{PROFIT_RATE, CLICK}).removeFields(new String[]{RATEAMT});
    }

    @Override
    protected Set<String> getAmountFields() {
        return Stream.of(AMOUNT, PROFIT).collect(Collectors.toSet());
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_investamtbankrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CLICK;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(CLICK, ids.get(0));
        param.setFormId(formId);
        this.fireLinkageShowForm(view, param);
    }

    private DataSet groupBy(DataSet ds) {
        return ds.groupBy(new String[]{CUSTOM_TYPE, DATE_TYPE, BANKNAME, DATE}).sum(AMOUNT).sum(PROFIT).sum(RATEAMT).finish();
    }
}

