/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.InvestCostDateHelper;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestAmtSumQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AMOUNT = "amount";
    private static final String PROFIT = "profit";
    private static final String AVG_RATE = "avgrate";
    private static final String CLICK = "click";
    private static final String CUSTOM_TYPE = "customtype";
    private static final String DATE_TYPE = "datetype";
    private static final String DATE = "date";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u7d2f\u8ba1\u91d1\u989d", (String)"InvestAmtSumQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{PROFIT, ResManager.loadKDString((String)"\u6536\u76ca", (String)"InvestAmtSumQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AVG_RATE, ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387", (String)"InvestAmtSumQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{CUSTOM_TYPE, ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b", (String)"InvestAmtSumQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{DATE, ResManager.loadKDString((String)"\u65e5\u671f", (String)"InvestAmtSumQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{DATE_TYPE, ResManager.loadKDString((String)"\u65e5\u671f\u6392\u5e8f", (String)"InvestAmtSumQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        fields.add(new Object[]{CLICK, ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"InvestAmtSumQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        List<Long> orgIdSet = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allDs = InvestDataHelper.getInvestDataSet((String)((Object)((Object)this)).getClass().getName(), orgIdSet, (Date)queryDate, (Long)currencyId, (Long)orgViewId, (DateRangeEnum)DateRangeEnum.ALL);
        allDs = allDs.select("avgprinciple amount, expectprofit profit, expectrate rate, customtype, datetype");
        DataSet groupDs = allDs.groupBy(new String[]{CUSTOM_TYPE, DATE_TYPE}).sum(AMOUNT).sum(PROFIT).sum("amount*rate", "rateamount").finish();
        DataSet resultSet = InvestReportDataHelper.parseDateType(groupDs, queryDate);
        return resultSet.addFields(new String[]{"case when amount is null or amount=0 then 0.00 else rateamount/amount end", "concat(customtype,'_',datetype)"}, new String[]{AVG_RATE, CLICK});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)CUSTOM_TYPE, (String)DATE);
        String customType = (String)typeLinkValue.getValue0();
        String date = (String)typeLinkValue.getValue1();
        return InvestCostDateHelper.getAfterFilterDataSet((DataSet)ds, (String)customType, (Boolean)true, (String)date, filterParam);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add(AMOUNT);
        fields.add(PROFIT);
        return fields;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_investamtsumrpt");
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(CLICK, ids.get(0));
        param.setFormId(formId);
        this.fireLinkageShowForm(view, param);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CLICK;
    }
}

