/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.CurrencyTypeEnum;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestCurrencyBalanceQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected static final String BALANCE = "balance";
    private static final String CURRENCY_NAME = "currencyname";
    private static final String CURRENCY_TYPE = "currencytype";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{BALANCE, ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u4f59\u989d", (String)"InvestCurrencyQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{CURRENCY_NAME, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"InvestCurrencyQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{CURRENCY_TYPE, ResManager.loadKDString((String)"\u5e01\u79cd\u79cd\u7c7b", (String)"InvestCurrencyQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List<Long> orgIds = this.getOrgIds(paramMap);
        DataSet resultDs = InvestDataHelper.getInvestBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        String selectField = "amount as balance, frate, currency as currencyid, currencynumber,case when currencynumber = 'CNY' then 0 when currencynumber = 'USD' then 1 when currencynumber = 'HKD' then 2 else 3 end as currencytype";
        resultDs = resultDs.filter("isoffset='0'").select(selectField);
        resultDs = resultDs.groupBy(new String[]{CURRENCY_TYPE}).sum(BALANCE).finish().orderBy(new String[]{CURRENCY_TYPE});
        resultDs = DecisionAnlsHelper.creatAbsentRow(resultDs, CURRENCY_TYPE, Arrays.asList("0", "1", "2", "3"), 0, () -> new Object[]{"", 0.0});
        String currencyStr = String.format("case when currencytype=0 then '%1$s' when currencytype=1 then '%2$s' when currencytype=2 then '%3$s' else '%4$s' end", CurrencyTypeEnum.CNY.getName(), CurrencyTypeEnum.USD.getName(), CurrencyTypeEnum.HKD.getName(), CurrencyTypeEnum.OTHER.getName());
        return resultDs.addField(currencyStr, CURRENCY_NAME);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(BALANCE);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_investcurrencybalrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CURRENCY_NAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("tda_investcurrencybalrpt");
        this.fireLinkageShowForm(view, param);
    }
}

