/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestOrgBalanceQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String COMPANY = "company";
    private static final String ORG = "rowid";
    private static final String ORG_NAME = "org_name";
    private static final String PID = "pid";
    private static final String LEVEL = "level";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String AMOUNT = "amount";
    private static final String AMOUNTRATE = "amountrate";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{ORG_NAME, ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"InvestOrgBalanceQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u4f59\u989d", (String)"InvestOrgBalanceQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{AMOUNTRATE, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u7387", (String)"InvestOrgBalanceQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty(orgIds) && orgIds.size() > 1) {
            orgIds.remove(orgId);
        }
        DataSet ds = InvestDataHelper.getInvestBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        String selectStr = "company,amount,frate";
        ds = ds.select(selectStr).addField("amount * frate", AMOUNTRATE).groupBy(new String[]{COMPANY}).sum(AMOUNT).sum(AMOUNTRATE).finish();
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List<String> fieldList = this.getSelectFieldList();
        String[] selectFields = fieldList.toArray(new String[fieldList.size()]);
        DataSet leftJoinBankDataSet = orgDateSet.leftJoin(ds).on(ORG, COMPANY).select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinBankDataSet, Arrays.asList(AMOUNT, AMOUNTRATE), "org_name,sortcode");
        List<Long> subOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
            subOrgIds = Collections.singletonList(orgId);
        }
        sumDataSet = sumDataSet.filter("amount != 0 and amount != null and rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds)).orderBy(new String[]{"amount desc"});
        return sumDataSet.updateField(AMOUNTRATE, "case when amount is null then 0 else amountrate/amount end");
    }

    private List<String> getSelectFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(10);
        fieldList.add("mixorgname org_name");
        fieldList.add("0 sumlevel");
        fieldList.add(ORG);
        fieldList.add(PID);
        fieldList.add(LEVEL);
        fieldList.add(ISGROUPNODE);
        fieldList.add("sortcode");
        fieldList.add(AMOUNT);
        fieldList.add(AMOUNTRATE);
        return fieldList;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_investbybalancerpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return ORG_NAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("tda_investbybalancerpt");
        param.setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u5355\u4f4d\u4f59\u989d\u5206\u5e03\u8868", (String)"InvestOrgBalanceQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, param);
    }
}

