/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestTermBalHelper;

public class InvestTermBalQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String TERM = "term";
    private static final String BALANCE = "balance";
    private static final String TERM_NUMBER = "termnumber";
    private static final String PARAM = "param";
    private static final String PARAM_NAME = "paramname";
    private static final String TERM_TYPE = "termType";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{TERM, ResManager.loadKDString((String)"\u671f\u9650", (String)"InvestTermBalQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{BALANCE, ResManager.loadKDString((String)"\u4f59\u989d", (String)"InvestTermBalQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{TERM_NUMBER, ResManager.loadKDString((String)"\u671f\u9650\u7f16\u53f7", (String)"InvestTermBalQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"InvestTermBalQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{PARAM_NAME, ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"InvestTermBalQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet allDS = InvestDataHelper.getInvestBalanceDataSet((String)this.createAlgoKey(""), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        allDS = allDS.filter("isoffset='0' and residueterm != '-1d'").select("amount as balance, residueterm, term");
        DataSet originalDS = allDS.copy().select("balance, term");
        originalDS = InvestTermBalHelper.handleDataSet(originalDS, true);
        String originalName = ResManager.loadKDString((String)"\u539f\u59cb\u671f\u9650", (String)"InvestTermBalQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]);
        originalDS = originalDS.addFields(new String[]{"'original'", '\'' + originalName + '\''}, new String[]{PARAM, PARAM_NAME});
        DataSet residueDS = allDS.select("balance, residueterm as term");
        residueDS = InvestTermBalHelper.handleDataSet(residueDS, true);
        String residueName = ResManager.loadKDString((String)"\u5269\u4f59\u671f\u9650", (String)"InvestTermBalQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        residueDS = residueDS.addFields(new String[]{"'residue'", '\'' + residueName + '\''}, new String[]{PARAM, PARAM_NAME});
        return originalDS.union(residueDS);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(BALANCE);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_investtermbalrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        String termType = ids.get(0);
        param.getCustomParams().put(TERM_TYPE, ids.get(0));
        param.setFormId("tda_investtermbalrpt");
        String caption = "residue".equals(termType) ? ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u5269\u4f59\u671f\u9650\u4f59\u989d\u5206\u5e03\u8868", (String)"InvestTermBalQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u539f\u59cb\u671f\u9650\u4f59\u989d\u5206\u5e03\u8868", (String)"InvestTermBalQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        param.setCaption(caption);
        this.fireLinkageShowForm(view, param);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.setFormId("tda_investtermbalrpt");
        JSONArray jsonArray = (JSONArray)clickArgs.get((Object)"data");
        String termType = (String)jsonArray.get(3);
        String caption = "residue".equals(termType) ? ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u5269\u4f59\u671f\u9650\u4f59\u989d\u5206\u5e03\u8868", (String)"InvestTermBalQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u539f\u59cb\u671f\u9650\u4f59\u989d\u5206\u5e03\u8868", (String)"InvestTermBalQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        param.setCaption(caption);
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put(TERM_TYPE, termType);
        param.setCustomParams(customParams);
    }
}

