/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.liquidity.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.LiquidityDataCheckHelper;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.report.common.helper.AbstractDecisionDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.liquidity.helper.LiquidityDateHelper;
import org.apache.commons.lang3.StringUtils;

public class LiquidityIndexDataHelper
extends AbstractDecisionDataHelper {
    private static final String ACCOUNTYEAR = "accountyear";
    private static final String ACCOUNTPERIOD = "accountperiod";
    protected static final List<String> ORG_SELECTFIELD = Arrays.asList("orgid", "rowid", "mixorgname", "orgname", "pid", "isgroupnode", "level", "0  as sumlevel", "sortcode");
    protected static final String SELECTFIELD = "orgid,rowid,mixorgname,orgname,pid,isgroupnode,level,sumlevel,sortcode";
    public static final String SORTCODE = "sortcode";
    private String indexName;

    public LiquidityIndexDataHelper(String indexName) {
        this.indexName = indexName;
    }

    @Override
    protected DataSet queryDataSetFromDb(Map<String, Object> paramMap, String algoKey) {
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        String cacheKey = this.getCacheKey(paramMap, algoKey);
        boolean useCache = isQueryCache && !DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        List allorgids = (List)paramMap.get("allorgids");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List orgIds = useCache ? TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId) : allorgids;
        DataSet result = CacheManager.getCacheOrElseGet((Long)orgViewId, (String)algoKey, (String)cacheKey, () -> this.queryLiquidityBill(paramMap, orgIds, algoKey));
        if (useCache) {
            result = result.filter("orgid in allorgids", Collections.singletonMap("allorgids", allorgids));
        }
        return result;
    }

    private DataSet queryLiquidityBill(Map<String, Object> paramMap, List<Long> orgIds, String algoKey) {
        QFilter qFilter = this.getFilter(paramMap, orgIds);
        String selectFields = "org.id as rowid,org.id as orgid,org.name as orgname," + this.indexName + ",concat(accountyear,accountperiod) as period";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"tda_liquiditybill", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    private QFilter getFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Map<String, Integer> periodMap = LiquidityDateHelper.getYearAndMonth(queryDate);
        Integer year = periodMap.get("year");
        Integer month = periodMap.get("month");
        Integer lastMonth = periodMap.get("lastmonth");
        QFilter curPeriodFilter = new QFilter(ACCOUNTYEAR, "=", (Object)year).and(ACCOUNTPERIOD, "=", (Object)month);
        QFilter lastPeriodFilter = new QFilter(ACCOUNTYEAR, "=", (Object)LiquidityDateHelper.getLastPeriodYear(periodMap)).and(ACCOUNTPERIOD, "=", (Object)lastMonth);
        QFilter yearFilter1 = new QFilter(ACCOUNTYEAR, "=", (Object)(year - 1)).and(ACCOUNTPERIOD, "=", (Object)12);
        QFilter yearFilter2 = new QFilter(ACCOUNTYEAR, "=", (Object)(year - 2)).and(ACCOUNTPERIOD, "=", (Object)12);
        QFilter yearFilter3 = new QFilter(ACCOUNTYEAR, "=", (Object)(year - 3)).and(ACCOUNTPERIOD, "=", (Object)12);
        QFilter yearFilter4 = new QFilter(ACCOUNTYEAR, "=", (Object)(year - 4)).and(ACCOUNTPERIOD, "=", (Object)12);
        QFilter yearFilter5 = new QFilter(ACCOUNTYEAR, "=", (Object)(year - 5)).and(ACCOUNTPERIOD, "=", (Object)12);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        QFilter qFilter = new QFilter("orgview.id", "=", (Object)orgViewId);
        qFilter.and("org.id", "in", orgIds);
        qFilter.and(curPeriodFilter.or(lastPeriodFilter).or(yearFilter1).or(yearFilter2).or(yearFilter3).or(yearFilter4).or(yearFilter5));
        return qFilter;
    }

    private Map<String, String> getAliasMap(Date queryDate) {
        Map<String, Integer> periodMap = LiquidityDateHelper.getYearAndMonth(queryDate);
        Integer year = periodMap.get("year");
        Integer month = periodMap.get("month");
        Integer lastMonth = periodMap.get("lastmonth");
        HashMap<String, String> aliasMap = new HashMap<String, String>(8);
        aliasMap.put(year.toString() + month.toString(), "decimalfield");
        aliasMap.put(LiquidityDateHelper.getLastPeriodYear(periodMap).toString() + lastMonth, "decimalfield1");
        aliasMap.put(year - 1 + "12", "decimalfield2");
        aliasMap.put(year - 2 + "12", "decimalfield3");
        aliasMap.put(year - 3 + "12", "decimalfield4");
        aliasMap.put(year - 4 + "12", "decimalfield5");
        aliasMap.put(year - 5 + "12", "decimalfield6");
        return aliasMap;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet allAcctSet, ReportQueryParam queryParam) {
        Object sortcode;
        List filterOrg;
        Map<String, Object> paramMap = this.transQueryParam(queryParam);
        Date realQueryDate = LiquidityDataCheckHelper.getRealQueryDate(paramMap);
        paramMap.put("querydate", realQueryDate);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DynamicObject org = (DynamicObject)paramMap.get("org");
        long orgId = org.getLong("id");
        if (EmptyUtil.isNoEmpty((Object)paramMap.get("suborgids"))) {
            filterOrg = (List)paramMap.get("suborgids");
            filterOrg.add(orgId);
        } else {
            filterOrg = (List)paramMap.get("allorgids");
        }
        DataSet ds = allAcctSet.leftJoin(orgDateSet).on("rowid", "orgid").select(ORG_SELECTFIELD.toArray(new String[0]), new String[]{this.indexName, "period"}).finish();
        if (CollectionUtils.isNotEmpty((Collection)filterOrg) && (sortcode = this.genTotalSortCode(ds = ds.filter("rowid in (" + TmcBusinessBaseHelper.idListToString((List)filterOrg) + ")"))) != null) {
            ds = ds.updateFields(new String[]{SORTCODE, "isgroupnode"}, new String[]{"case when rowid = " + orgId + " then " + sortcode + " else sortcode end", "case when rowid = " + orgId + " then '-1' else isgroupnode end"});
        }
        DataSet assetsDebtDs = ds.addField(this.indexName, "count");
        Map<String, String> aliasMap = this.getAliasMap(DecisionAnlsHelper.getQueryDate(paramMap));
        DataSet changResult = this.changeRowToColDataSet(assetsDebtDs, "period", SELECTFIELD, aliasMap);
        List fieldName = Arrays.stream(changResult.getRowMeta().getFieldNames()).collect(Collectors.toList());
        for (String value : aliasMap.values()) {
            if (fieldName.contains(value)) continue;
            changResult = changResult.addField("0.0", value);
        }
        if (aliasMap.size() == 6) {
            changResult = changResult.addField("decimalfield2", "decimalfield1");
        }
        changResult = changResult.orderBy(new String[]{SORTCODE});
        DataSet result = changResult.updateField("orgname", "mixorgname");
        return this.filterEmptyRow(result);
    }

    private DataSet filterEmptyRow(DataSet result) {
        String[] fieldNames = result.getRowMeta().getFieldNames();
        ArrayList<String> colList = new ArrayList<String>(10);
        for (String colName : fieldNames) {
            if (colName == null || colName.indexOf("decimalfield") == -1) continue;
            colList.add(colName);
        }
        if (CollectionUtils.isNotEmpty(colList)) {
            result = DecisionAnlsHelper.removeNoDataTreeDs(result, colList, false);
        }
        return result;
    }

    private DataSet changeRowToColDataSet(DataSet ds, String changeField, String groupFieldName, Map<String, String> map) {
        DataSet tempDs = ds.copy();
        HashSet<DataSet> dsSet = new HashSet<DataSet>(16);
        HashSet<String> dsFieldName = new HashSet<String>(16);
        while (tempDs.hasNext()) {
            Row row = tempDs.next();
            String fieldValue = row.getString(changeField);
            String fieldName = map.get(fieldValue);
            String filter = changeField + " = '" + fieldValue + "'";
            if (!dsFieldName.add(fieldValue)) continue;
            DataSet ds1 = ds.copy().filter(filter).select(groupFieldName + ", count as " + fieldName);
            dsSet.add(ds1);
        }
        DataSet result = ds.select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        for (DataSet dsTemp : dsSet) {
            if (result == null) {
                result = dsTemp;
                continue;
            }
            ArrayList<DataSet> fieldNameList = new ArrayList<DataSet>();
            Collections.addAll(fieldNameList, dsTemp.getRowMeta().getFieldNames());
            for (DataSet fieldName : result.getRowMeta().getFieldNames()) {
                if (fieldNameList.contains(fieldName)) continue;
                fieldNameList.add(fieldName);
            }
            JoinDataSet temp = result.join(dsTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                temp = temp.on(groupField.trim(), groupField.trim());
            }
            result = temp.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
        }
        return result;
    }

    private String getCacheKey(Map<String, Object> paramMap, String algoKey) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        return algoKey + "-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyyMM");
    }

    private Object genTotalSortCode(DataSet ds) {
        DataSet dsCopy = ds.copy();
        if (!dsCopy.hasNext()) {
            return null;
        }
        Object totalSortCode = dsCopy.next().get(SORTCODE);
        DataType sortcodeType = ds.getRowMeta().getField(SORTCODE).getDataType();
        totalSortCode = sortcodeType instanceof StringType ? (totalSortCode != null && StringUtils.isNumeric((CharSequence)totalSortCode.toString()) ? "'9223372036854775807'" : "'" + StringUtils.rightPad((String)"z", (int)9, (String)"z") + "'") : Long.valueOf(Long.MAX_VALUE);
        return totalSortCode;
    }
}

