/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.liquidity.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.report.common.helper.AbstractDecisionDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.liquidity.helper.LiquidityDateHelper;

public class LiquidityIndexQingDataHelper
extends AbstractDecisionDataHelper {
    protected static final String TMC_TDA_REPORT = "tmc-tda-report";
    private static final String ACCOUNTYEAR = "accountyear";
    private static final String ACCOUNTPERIOD = "accountperiod";
    private static final String ASSETSDEBTRATE = "assetsdebtrate";
    private static final String LASTYEARRATE_ALM = "lastyearrate_alm";
    private static final String LASTMONTHRATE_ALM = "lastmonthrate_alm";
    private static final String INTDEBTRATE = "intdebtrate";
    private static final String LASTYEARRATE_IBR = "lastyearrate_ibr";
    private static final String LASTMONTHRATE_IBR = "lastmonthrate_ibr";
    private static final String QUICKRATIO = "quickratio";
    private static final String LASTYEARRATE_QR = "lastyearrate_qr";
    private static final String LASTMONTHRATE_QR = "lastmonthrate_qr";
    private static final String FLOWRATIO = "flowratio";
    private static final String LASTYEARRATE_FR = "lastyearrate_fr";
    private static final String LASTMONTHRATE_FR = "lastmonthrate_fr";
    private static final String INTCOVERRATIO = "intcoverratio";
    private static final String LASTYEARRATE_ICR = "lastyearrate_icr";
    private static final String LASTMONTHRATE_ICR = "lastmonthrate_icr";
    private static final String FUNDDUETHREEMTHRATIO = "fundduethreemthratio";
    private static final String LASTYEARRATE_FDTMR = "lastyearrate_fdtmr";
    private static final String LASTMONTHRATE_FDTMR = "lastmonthrate_fdtmr";
    private static final String DUETHREEMONTHAMT = "duethreemonthamt";
    private static final String LASTYEARRATE_DTMA = "lastyearrate_dtma";
    private static final String LASTMONTHRATE_DTMA = "lastmonthrate_dtma";
    private static final String DUETHREEMONTHRATIO = "duethreemonthratio";
    private static final String LASTYEARRATE_DTMR = "lastyearrate_dtmr";
    private static final String LASTMONTHRATE_DTMR = "lastmonthrate_dtmr";
    private Map<String, List<String>> aliasMap = new HashMap<String, List<String>>(4);
    private static final List<String> selectFieldsCur = Stream.of("assetsdebtrate", "intdebtrate", "quickratio", "flowratio", "intcoverratio", "fundduethreemthratio", "duethreemonthamt", "duethreemonthratio").collect(Collectors.toList());
    private static final List<String> selectFieldsLastyear = Stream.of("lastyearrate_alm", "lastyearrate_ibr", "lastyearrate_qr", "lastyearrate_fr", "lastyearrate_icr", "lastyearrate_fdtmr", "lastyearrate_dtma", "lastyearrate_dtmr").collect(Collectors.toList());
    private static final List<String> selectFieldsLastmonth = Stream.of("lastmonthrate_alm", "lastmonthrate_ibr", "lastmonthrate_qr", "lastmonthrate_fr", "lastmonthrate_icr", "lastmonthrate_fdtmr", "lastmonthrate_dtma", "lastmonthrate_dtmr").collect(Collectors.toList());

    @Override
    protected DataSet queryDataSetFromDb(Map<String, Object> paramMap, String algoKey) {
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        String cacheKey = this.getCacheKey(paramMap, algoKey);
        boolean useCache = isQueryCache && !DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List<Long> orgIds = useCache ? TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId) : Collections.singletonList(orgId);
        DataSet result = CacheManager.getCacheOrElseGet((Long)orgViewId, (String)algoKey, (String)cacheKey, () -> this.queryLiquidityBill(paramMap, orgIds, algoKey));
        if (useCache) {
            result = result.filter("orgid = " + orgId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet queryLiquidityBill(Map<String, Object> paramMap, List<Long> orgIds, String algoKey) {
        List<QFilter> list = this.getFilter(paramMap, orgIds);
        try (DataSet curDs = null;){
            String selectFieldStr = StringUtils.join((Object[])selectFieldsCur.toArray(), (String)",");
            curDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"tda_liquiditybill", (String)("org.name as orgname, org.id as orgid,concat(accountyear,accountperiod) as period," + selectFieldStr), (QFilter[])list.toArray(new QFilter[list.size()]), null);
            DataSet resultDs = this.changeRowToColDataSet(curDs, "period", "orgid,orgname", this.aliasMap);
            DataSet dataSet = resultDs = resultDs.addFields(new String[]{"case when (lastyearrate_alm =0 or assetsdebtrate=0)  then 0.0 else ((assetsdebtrate-lastyearrate_alm)/lastyearrate_alm) end", "case when (lastmonthrate_alm = 0 or assetsdebtrate=0) then 0.0 else ((assetsdebtrate-lastmonthrate_alm)/lastmonthrate_alm) end", "case when (lastyearrate_ibr = 0 or intdebtrate=0) then 0.0 else ((intdebtrate-lastyearrate_ibr)/lastyearrate_ibr) end", "case when (lastmonthrate_ibr = 0 or intdebtrate=0) then 0.0 else ((intdebtrate-lastmonthrate_ibr)/lastmonthrate_ibr) end", "case when (lastyearrate_qr = 0 or quickratio=0) then 0.0 else ((quickratio-lastyearrate_qr)/lastyearrate_qr) end", "case when (lastmonthrate_qr = 0 or quickratio=0) then 0.0 else ((quickratio-lastmonthrate_qr)/lastmonthrate_qr) end", "case when (lastyearrate_fr = 0 or flowratio=0) then 0.0 else ((flowratio-lastyearrate_fr)/lastyearrate_fr) end", "case when (lastmonthrate_fr = 0 or flowratio=0) then 0.0 else ((flowratio-lastmonthrate_fr)/lastmonthrate_fr) end", "case when (lastyearrate_icr = 0 or intcoverratio=0) then 0.0 else ((intcoverratio-lastyearrate_icr)/lastyearrate_icr) end", "case when (lastmonthrate_icr = 0 or intcoverratio=0) then 0.0 else ((intcoverratio-lastmonthrate_icr)/lastmonthrate_icr) end", "case when (lastyearrate_fdtmr = 0 or fundduethreemthratio=0) then 0.0 else ((fundduethreemthratio-lastyearrate_fdtmr)/lastyearrate_fdtmr) end", "case when (lastmonthrate_fdtmr = 0 or fundduethreemthratio=0) then 0.0 else ((fundduethreemthratio-lastmonthrate_fdtmr)/lastmonthrate_fdtmr) end", "case when (lastyearrate_dtma = 0 or duethreemonthamt=0) then 0.0 else ((duethreemonthamt-lastyearrate_dtma)/lastyearrate_dtma) end", "case when (lastmonthrate_dtma = 0 or duethreemonthamt=0) then 0.0 else ((duethreemonthamt-lastmonthrate_dtma)/lastmonthrate_dtma) end", "case when (lastyearrate_dtmr = 0 or duethreemonthratio=0) then 0.0 else ((duethreemonthratio-lastyearrate_dtmr)/lastyearrate_dtmr) end", "case when (lastmonthrate_dtmr = 0 or duethreemonthratio=0) then 0.0 else ((duethreemonthratio-lastmonthrate_dtmr)/lastmonthrate_dtmr) end"}, new String[]{"lastyearrate_alm_rate", "lastmonthrate_alm_rate", "lastyearrate_ibr_rate", "lastmonthrate_ibr_rate", "lastyearrate_qr_rate", "lastmonthrate_qr_rate", "lastyearrate_fr_rate", "lastmonthrate_fr_rate", "lastyearrate_icr_rate", "lastmonthrate_icr_rate", "lastyearrate_fdtmr_rate", "lastmonthrate_fdtmr_rate", "lastyearrate_dtma_rate", "lastmonthrate_dtma_rate", "lastyearrate_dtmr_rate", "lastmonthrate_dtmr_rate"});
            return dataSet;
        }
    }

    private List<QFilter> getFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(3);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        QFilter qFilter = new QFilter("orgview.id", "=", (Object)orgViewId);
        qFilter.and("org.id", "in", orgIds);
        list.add(qFilter);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Map<String, Integer> periodMap = LiquidityDateHelper.getYearAndMonth(queryDate);
        Integer year = periodMap.get("year");
        Integer lastMonth = periodMap.get("lastmonth");
        Integer lastYear = periodMap.get("lastyear");
        Integer month = periodMap.get("month");
        Integer lastPeriodYear = LiquidityDateHelper.getLastPeriodYear(periodMap);
        QFilter curFilter = new QFilter(ACCOUNTYEAR, "=", (Object)year).and(ACCOUNTPERIOD, "=", (Object)month);
        QFilter lastYearFilter = new QFilter(ACCOUNTYEAR, "=", (Object)lastYear).and(ACCOUNTPERIOD, "=", (Object)month);
        QFilter lastPeriodFilter = new QFilter(ACCOUNTYEAR, "=", (Object)lastPeriodYear).and(ACCOUNTPERIOD, "=", (Object)lastMonth);
        QFilter periodFilter = curFilter.or(lastYearFilter).or(lastPeriodFilter);
        list.add(periodFilter);
        this.aliasMap.put(year.toString() + month, selectFieldsCur);
        this.aliasMap.put(lastYear.toString() + month.toString(), selectFieldsLastyear);
        this.aliasMap.put(lastPeriodYear.toString() + lastMonth.toString(), selectFieldsLastmonth);
        return list;
    }

    private DataSet changeRowToColDataSet(DataSet ds, String changeField, String groupFieldName, Map<String, List<String>> map) {
        DataSet ds1;
        StringBuilder fieldsStr;
        String filter;
        List<String> fieldNameList;
        DataSet tempDs = ds.copy();
        HashSet<DataSet> dsSet = new HashSet<DataSet>(16);
        HashMap<String, String> dsFieldName = new HashMap<String, String>(16);
        String orgName = "";
        Long orgId = 0L;
        while (tempDs.hasNext()) {
            Row row = tempDs.next();
            orgName = row.getString("orgname");
            orgId = row.getLong("orgId");
            String string = row.getString(changeField);
            fieldNameList = map.remove(string);
            filter = changeField + " = '" + string + "'";
            if (dsFieldName.get(string) != null) continue;
            fieldsStr = new StringBuilder(groupFieldName);
            fieldsStr.append(",").append(ASSETSDEBTRATE).append(" as ").append(fieldNameList.get(0));
            fieldsStr.append(",").append(INTDEBTRATE).append(" as ").append(fieldNameList.get(1));
            fieldsStr.append(",").append(QUICKRATIO).append(" as ").append(fieldNameList.get(2));
            fieldsStr.append(",").append(FLOWRATIO).append(" as ").append(fieldNameList.get(3));
            fieldsStr.append(",").append(INTCOVERRATIO).append(" as ").append(fieldNameList.get(4));
            fieldsStr.append(",").append(FUNDDUETHREEMTHRATIO).append(" as ").append(fieldNameList.get(5));
            fieldsStr.append(",").append(DUETHREEMONTHAMT).append(" as ").append(fieldNameList.get(6));
            fieldsStr.append(",").append(DUETHREEMONTHRATIO).append(" as ").append(fieldNameList.get(7));
            ds1 = ds.copy().filter(filter).select(fieldsStr.toString());
            dsSet.add(ds1);
            dsFieldName.put(string, "");
        }
        for (Map.Entry entry : map.entrySet()) {
            fieldNameList = (List<String>)entry.getValue();
            filter = changeField + " = '" + (String)entry.getKey() + "'";
            if (dsFieldName.get(entry.getKey()) != null) continue;
            fieldsStr = new StringBuilder(groupFieldName);
            fieldsStr.append(",").append(ASSETSDEBTRATE).append(" as ").append(fieldNameList.get(0));
            fieldsStr.append(",").append(INTDEBTRATE).append(" as ").append(fieldNameList.get(1));
            fieldsStr.append(",").append(QUICKRATIO).append(" as ").append(fieldNameList.get(2));
            fieldsStr.append(",").append(FLOWRATIO).append(" as ").append(fieldNameList.get(3));
            fieldsStr.append(",").append(INTCOVERRATIO).append(" as ").append(fieldNameList.get(4));
            fieldsStr.append(",").append(FUNDDUETHREEMTHRATIO).append(" as ").append(fieldNameList.get(5));
            fieldsStr.append(",").append(DUETHREEMONTHAMT).append(" as ").append(fieldNameList.get(6));
            fieldsStr.append(",").append(DUETHREEMONTHRATIO).append(" as ").append(fieldNameList.get(7));
            ds1 = ds.copy().filter(filter).select(fieldsStr.toString());
            this.creatEmptyRow(ds1, orgName, orgId);
            dsSet.add(ds1);
            dsFieldName.put((String)entry.getKey(), "");
        }
        DataSet result = ds.select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        for (DataSet dsTemp : dsSet) {
            if (result == null) {
                result = dsTemp;
                continue;
            }
            ArrayList<String> fieldNameList2 = new ArrayList<String>();
            Collections.addAll(fieldNameList2, dsTemp.getRowMeta().getFieldNames());
            for (String fieldName : result.getRowMeta().getFieldNames()) {
                if (fieldNameList2.contains(fieldName)) continue;
                fieldNameList2.add(fieldName);
            }
            JoinDataSet temp = result.join(dsTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                temp = temp.on(groupField.trim(), groupField.trim());
            }
            result = temp.select(fieldNameList2.toArray(new String[fieldNameList2.size()])).finish();
        }
        return result;
    }

    private DataSet creatEmptyRow(DataSet resultDs, String orgName, Long orgId) {
        if (resultDs.copy().isEmpty()) {
            RowMeta rowMeta = resultDs.getRowMeta();
            DataSet bizDs = DecisionAnlsHelper.createRow(this.getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{orgName, orgId, 0, 0, 0, 0, 0, 0, 0, 0}));
            return resultDs.union(bizDs);
        }
        return resultDs;
    }

    private String getCacheKey(Map<String, Object> paramMap, String algoKey) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        return algoKey + "-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyyMM");
    }
}

