/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.liquidity.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.LiquidityDataCheckHelper;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.liquidity.helper.LiquidityDateHelper;

public class LiquidityIndicatorDetailHelper {
    private static final String ORGID = "orgid";
    private static final String[] FIELDS = new String[]{"rowid", "pid", "duethreemonthamt"};

    public static DataSet getDataSet(Map<String, Object> paramMap) {
        String[] filterExps;
        DataSet[] dataSets;
        DataSet curPeriodDataSet;
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Map<String, Integer> periodMap = LiquidityDateHelper.getYearAndMonth(queryDate);
        String algoKey = LiquidityIndicatorDetailHelper.class.getName() + "_queryLiquidityBill";
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        String cacheKey = LiquidityIndicatorDetailHelper.getCacheKey(paramMap);
        boolean useCache = isQueryCache && !DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        List allorgids = (List)paramMap.get("allorgids");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List orgIds = useCache ? TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId) : allorgids;
        DataSet periodDatSet = CacheManager.getCacheOrElseGet((Long)orgViewId, (String)algoKey, (String)cacheKey, () -> LiquidityIndicatorDetailHelper.queryLiquidityBill(paramMap, periodMap, orgIds, algoKey));
        if (useCache) {
            periodDatSet = periodDatSet.filter("orgid in allorgids", Collections.singletonMap("allorgids", allorgids));
        }
        if ((curPeriodDataSet = (dataSets = periodDatSet.splitByFilter(filterExps = new String[]{"accountyear = " + periodMap.get("year") + " and accountperiod = " + periodMap.get("month"), "accountyear = " + periodMap.get("lastyear") + " and accountperiod = " + periodMap.get("month"), "accountyear = " + LiquidityDateHelper.getLastPeriodYear(periodMap) + " and accountperiod = " + periodMap.get("lastmonth")}, false))[0]).isEmpty()) {
            DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.BigDecimalType};
            return DecisionAnlsHelper.createEmptyDataSet(FIELDS, dataTypes);
        }
        DataSet allDataSet = curPeriodDataSet.leftJoin(dataSets[1]).on(ORGID, ORGID).select(new String[]{ORGID, "orgname", "assetsdebtrate", "intdebtrate", "quickratio", "flowratio", "intcoverratio", "duethreemonthamt", "fundduethreemthratio", "duethreemonthratio"}, new String[]{"assetsdebtrate assetsdebtrateyear", "intdebtrate intdebtrateyear", "quickratio quickratioyear", "flowratio flowratioyear", "intcoverratio intcoverratioyear", "duethreemonthamt duethreemonthamtyear", "fundduethreemthratio fundduethreemthratioyear", "duethreemonthratio duethreemonthratioyear"}).finish();
        allDataSet = allDataSet.leftJoin(dataSets[2]).on(ORGID, ORGID).select(new String[]{ORGID, "orgname", "assetsdebtrate", "intdebtrate", "assetsdebtrateyear", "intdebtrateyear", "quickratio", "quickratioyear", "flowratio", "flowratioyear", "intcoverratio", "intcoverratioyear", "duethreemonthamt", "duethreemonthamtyear", "fundduethreemthratio", "fundduethreemthratioyear", "duethreemonthratio", "duethreemonthratioyear"}, new String[]{"assetsdebtrate assetsdebtratemonth", "intdebtrate intdebtratemonth", "quickratio quickratiomonth", "flowratio flowratiomonth", "intcoverratio intcoverratiomonth", "duethreemonthamt duethreemonthamtmonth", "fundduethreemthratio fundduethreemthratiomonth", "duethreemonthratio duethreemonthratiomonth"}).finish();
        for (String indicator : LiquidityDataCheckHelper.INDICATOR_FIELDS) {
            allDataSet = allDataSet.updateField(indicator, "case when " + indicator + " = null then 0 else " + indicator + " end");
            String yearIndicator = indicator + "year";
            allDataSet = allDataSet.updateField(yearIndicator, "case when " + yearIndicator + " > 0 and " + yearIndicator + " !=null then (" + indicator + "- " + yearIndicator + " ) * 100 / " + yearIndicator + " else 0 end");
            String monthIndicator = indicator + "month";
            allDataSet = allDataSet.updateField(monthIndicator, "case when " + monthIndicator + " > 0 and " + yearIndicator + " !=null then (" + indicator + "- " + monthIndicator + " ) * 100 / " + monthIndicator + " else 0 end");
        }
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String[] fieldNames = allDataSet.getRowMeta().getFieldNames();
        allDataSet = orgDateSet.join(allDataSet).on("rowid", ORGID).select(new String[]{"rowid", "pid", "mixorgname", "isgroupnode", "level"}, fieldNames).finish();
        allDataSet = allDataSet.updateField("orgname", "mixorgname orgname");
        DynamicObject org = (DynamicObject)paramMap.get("org");
        String simpleName = org.getString("simplename");
        if (StringUtils.isBlank((String)simpleName)) {
            simpleName = org.getString("name");
        }
        String topName = simpleName + "-";
        DataSet[] parentDataSets = allDataSet.splitByFilter(new String[]{"orgid = " + org.getPkValue()}, true);
        String totalName = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"LiquidityIndicatorDetailHelper_0", (String)"tmc-tda-report", (Object[])new Object[0]);
        DataSet sumOrgDataSet = parentDataSets[0].updateFields(new String[]{"orgname", ORGID, "isgroupnode"}, new String[]{"'" + topName + totalName + "'", "0", "'0'"}).addField("1", "sumlevel");
        DataSet resultDataSet = parentDataSets[1].addField("0", "sumlevel").union(sumOrgDataSet);
        resultDataSet = resultDataSet.addField(DateUtils.formatString((Date)DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-1), (String)"yyyyMM"), "date");
        return resultDataSet;
    }

    private static DataSet queryLiquidityBill(Map<String, Object> paramMap, Map<String, Integer> periodMap, List<Long> orgIds, String algoKey) {
        QFilter filter = LiquidityIndicatorDetailHelper.getFilter(paramMap, orgIds);
        filter = filter.and("accountyear", "in", Arrays.asList(periodMap.get("year"), periodMap.get("lastyear"))).and("accountperiod", "in", Arrays.asList(periodMap.get("month"), periodMap.get("lastmonth")));
        String props = "org.name as orgname, org.id as orgid, accountyear, accountperiod, assetsdebtrate*100 assetsdebtrate,intdebtrate*100 intdebtrate,quickratio,flowratio,intcoverratio,duethreemonthamt,fundduethreemthratio,duethreemonthratio*100 duethreemonthratio";
        DataSet periodDatSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"tda_liquiditybill", (String)props, (QFilter[])filter.toArray(), (String)"accountyear,accountperiod");
        return periodDatSet;
    }

    private static QFilter getFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        QFilter qFilter = new QFilter("orgview.id", "=", (Object)orgViewId);
        qFilter.and("org.id", "in", orgIds);
        return qFilter;
    }

    public static String getCacheKey(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        return "LiquidityIndicatorDetailHelper-cachekey-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyyMM");
    }
}

