/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.liquidity.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class LiquidityIndicatorHelper {
    private static final String LAST_2_MONTH_PROPS = "org.id as orgid,accountyear,accountperiod,assetsdebtrate,intdebtrate,quickratio,flowratio,intcoverratio,duethreemonthamt,fundduethreemthratio,duethreemonthratio, '2m' dateRange";
    private static final String LAST_5_YEARS_PROPS = "org.id as orgid,accountyear,0 accountperiod,assetsdebtrate,intdebtrate,quickratio,flowratio,intcoverratio,duethreemonthamt,fundduethreemthratio,duethreemonthratio, '5y' dateRange";
    private static final String SELECT = "case when accountperiod = 0 then cast(accountyear as String) else  CONCAT(cast(accountyear as String) ,'-',case when len(cast(accountperiod as String)) = 1 then CONCAT('0',cast(accountperiod as String)) else cast(accountperiod as String) end ) end as date,assetsdebtrate*100 assetsdebtrate,intdebtrate*100 intdebtrate,quickratio,flowratio,intcoverratio,duethreemonthamt,fundduethreemthratio,duethreemonthratio*100 duethreemonthratio";

    public static DataSet getLiquidityBillDataSet(Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet dataSet = LiquidityIndicatorHelper.queryLiquidityBillDataSet(paramMap, queryDate);
        return dataSet;
    }

    private static DataSet createNewDataset(DataSet targetDs, int year, int month) {
        RowMeta rowMeta = targetDs.getRowMeta();
        DataSetBuilder newDataset = Algo.create((String)"LiquidityIndicatorHelper").createDataSetBuilder(rowMeta);
        newDataset.append(new Object[]{year, month, 0, 0, 0, 0, 0, 0.0, 0, 0});
        return newDataset.build();
    }

    private static DataSet queryLiquidityBillDataSet(Map<String, Object> paramMap, Date queryDate) {
        String algoKey = LiquidityIndicatorHelper.class.getName() + "_queryLiquidityBill";
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        String cacheKey = LiquidityIndicatorHelper.getCacheKey(paramMap);
        boolean useCache = isQueryCache && !DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List<Long> orgIds = useCache ? TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId) : Collections.singletonList(orgId);
        DataSet result = CacheManager.getCacheOrElseGet((Long)orgViewId, (String)algoKey, (String)cacheKey, () -> LiquidityIndicatorHelper.queryLiquidityBill(paramMap, queryDate, orgIds, algoKey));
        if (useCache) {
            result = result.filter("orgid = " + orgId);
        }
        DataSet[] dataSets = result.removeFields(new String[]{"orgid"}).splitByFilter(new String[]{"dateRange = '2m'"}, true);
        DataSet last2MonthDs = dataSets[0].removeFields(new String[]{"dateRange"});
        DataSet last5yearsDs = dataSets[1].removeFields(new String[]{"dateRange"});
        for (int i = 1; i <= 5; ++i) {
            int lastNYear = DateUtils.getYear((Date)DateUtils.getLastYear((Date)queryDate, (int)i));
            DataSet data = last5yearsDs.copy().filter("accountyear =" + lastNYear);
            if (!data.isEmpty()) continue;
            last5yearsDs = last5yearsDs.union(LiquidityIndicatorHelper.createNewDataset(last5yearsDs, lastNYear, 0));
        }
        int lastMonth = DateUtils.getMonth((Date)DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-1));
        int last2Month = DateUtils.getMonth((Date)DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-2));
        int lastYear = DateUtils.getYear((Date)DateUtils.getLastYear((Date)queryDate, (int)1));
        int year = DateUtils.getYear((Date)queryDate);
        if (lastMonth == 1) {
            last2MonthDs = LiquidityIndicatorHelper.dealEmptyLast2MonthData(last2MonthDs, year, 1);
            last2MonthDs = LiquidityIndicatorHelper.dealEmptyLast2MonthData(last2MonthDs, lastYear, 12);
        } else if (lastMonth == 12) {
            last2MonthDs = LiquidityIndicatorHelper.dealEmptyLast2MonthData(last2MonthDs, lastYear, lastMonth);
            last2MonthDs = LiquidityIndicatorHelper.dealEmptyLast2MonthData(last2MonthDs, lastYear, last2Month);
        } else {
            last2MonthDs = LiquidityIndicatorHelper.dealEmptyLast2MonthData(last2MonthDs, year, lastMonth);
            last2MonthDs = LiquidityIndicatorHelper.dealEmptyLast2MonthData(last2MonthDs, year, last2Month);
        }
        return last2MonthDs.union(last5yearsDs).select(SELECT).orderBy(new String[]{"date"});
    }

    private static DataSet dealEmptyLast2MonthData(DataSet last2MonthDs, int year, int month) {
        DataSet last2MonthData = last2MonthDs.copy().filter("accountyear = " + year + " and accountperiod = " + month);
        if (last2MonthData.isEmpty()) {
            last2MonthDs = last2MonthDs.union(LiquidityIndicatorHelper.createNewDataset(last2MonthDs, year, month));
        }
        return last2MonthDs;
    }

    private static DataSet queryLiquidityBill(Map<String, Object> paramMap, Date queryDate, List<Long> orgIds, String algoKey) {
        QFilter qFilter = LiquidityIndicatorHelper.buildCommonFilter(paramMap, orgIds);
        QFilter last2MonthFilter = LiquidityIndicatorHelper.buildLast2MonthFilter(queryDate);
        QFilter last5yearsFilter = LiquidityIndicatorHelper.buildLast5yearsFilter(queryDate);
        String orderBys = "accountyear,accountperiod";
        DataSet last2MonthDs = QueryServiceHelper.queryDataSet((String)(algoKey + "2m"), (String)"tda_liquiditybill", (String)LAST_2_MONTH_PROPS, (QFilter[])new QFilter[]{qFilter, last2MonthFilter}, (String)orderBys);
        DataSet last5yearsDs = QueryServiceHelper.queryDataSet((String)(algoKey + "5y"), (String)"tda_liquiditybill", (String)LAST_5_YEARS_PROPS, (QFilter[])new QFilter[]{qFilter, last5yearsFilter}, (String)orderBys);
        return last2MonthDs.union(last5yearsDs);
    }

    private static QFilter buildCommonFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        QFilter qFilter = new QFilter("orgview.id", "=", (Object)orgViewId);
        qFilter.and("org.id", "in", orgIds);
        return qFilter;
    }

    private static QFilter buildLast2MonthFilter(Date queryDate) {
        if (queryDate != null) {
            Date lastYear = DateUtils.getLastYear((Date)queryDate, (int)1);
            int month = DateUtils.getMonth((Date)DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-1));
            int last2Month = DateUtils.getMonth((Date)DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)-2));
            if (month == 1) {
                return new QFilter("accountyear", "=", (Object)DateUtils.getYear((Date)queryDate)).and("accountperiod", "=", (Object)1).or(new QFilter("accountyear", "=", (Object)DateUtils.getYear((Date)lastYear)).and("accountperiod", "=", (Object)12));
            }
            if (month == 12) {
                return new QFilter("accountyear", "=", (Object)DateUtils.getYear((Date)lastYear)).and("accountperiod", "in", Arrays.asList(month, last2Month));
            }
            return new QFilter("accountyear", "=", (Object)DateUtils.getYear((Date)queryDate)).and("accountperiod", "in", Arrays.asList(month, last2Month));
        }
        return null;
    }

    private static QFilter buildLast5yearsFilter(Date queryDate) {
        if (queryDate != null) {
            Date last5Year = DateUtils.getLastYear((Date)queryDate, (int)5);
            QFilter dFilter = new QFilter("accountyear", ">=", (Object)DateUtils.getYear((Date)last5Year));
            dFilter.and("accountyear", "<", (Object)DateUtils.getYear((Date)queryDate)).and("accountperiod", "=", (Object)12);
            return dFilter;
        }
        return null;
    }

    public static String getCacheKey(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        return "LiquidityIndicatorHelper-cachekey-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyyMM");
    }
}

