/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.liquidity.qing;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.helper.LiquidityDataCheckHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.liquidity.helper.LiquidityIndicatorDetailHelper;

public class LiquidityIndicatorDetailQingDataListPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"LiquidityIndicatorDetailQingDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"assetsdebtrate", ResManager.loadKDString((String)"\u8d44\u4ea7\u8d1f\u503a\u7387", (String)"LiquidityIndicatorQingDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"intdebtrate", ResManager.loadKDString((String)"\u6709\u606f\u8d1f\u503a\u7387", (String)"LiquidityIndicatorQingDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"quickratio", ResManager.loadKDString((String)"\u901f\u52a8\u6bd4\u4f8b", (String)"LiquidityIndicatorQingDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"flowratio", ResManager.loadKDString((String)"\u6d41\u52a8\u6bd4\u4f8b", (String)"LiquidityIndicatorQingDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"intcoverratio", ResManager.loadKDString((String)"\u5229\u606f\u4fdd\u969c\u500d\u6570", (String)"LiquidityIndicatorQingDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"duethreemonthamt", ResManager.loadKDString((String)"3\u4e2a\u6708\u5185\u5230\u671f\u6709\u606f\u503a\u52a1", (String)"LiquidityIndicatorQingDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"fundduethreemthratio", ResManager.loadKDString((String)"\u8d27\u5e01\u8d44\u91d1\u5bf93\u4e2a\u6708\u5185\u5230\u671f\u503a\u52a1\u8986\u76d6\u500d\u6570", (String)"LiquidityIndicatorQingDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"duethreemonthratio", ResManager.loadKDString((String)"3\u4e2a\u6708\u5185\u5230\u671f\u503a\u52a1\u5360\u6bd4", (String)"LiquidityIndicatorQingDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    @Override
    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if ("duethreemonthamt".equals(Field2)) {
            return ((BigDecimal)value).setScale(6, 4);
        }
        return value;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton("duethreemonthamt");
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Date realQueryDate = LiquidityDataCheckHelper.getRealQueryDate(paramMap);
        paramMap.put("querydate", realQueryDate);
        DataSet ds = LiquidityIndicatorDetailHelper.getDataSet(paramMap);
        return this.filterDataSet(ds, paramMap);
    }

    private DataSet filterDataSet(DataSet ds, Map<String, Object> paramMap) {
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List<Long> secondOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        if (secondOrgIds == null) {
            secondOrgIds = Collections.singletonList(orgId);
        } else {
            secondOrgIds.add(orgId);
        }
        return ds.filter("rowid in secondOrgIds", Collections.singletonMap("secondOrgIds", secondOrgIds));
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "orgname";
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_liquidity_inddet");
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_liquidity_inddet");
        this.fireLinkageShowForm(view, parameter);
    }
}

