/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.common.helper.DraftBillUpdateFieldFunction;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.note.helper.DraftBillSpreadHelper;

public abstract class AbstractDraftBillDetailDataListPlugin
extends AbstractDetailDataPlugin {
    protected static final String MODEL = "tmc-tda-report";
    public static final String PERIODNAME = "periodname";
    private static final String DISPLAYTYPE = "displayType";
    private static final String ALLTYPE = "all";
    private final Map<String, String> monthMap = new LinkedHashMap(10){
        {
            this.put("onemonth", ResManager.loadKDString((String)"1\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_8", (String)AbstractDraftBillDetailDataListPlugin.MODEL, (Object[])new Object[0]));
            this.put("twomonth", ResManager.loadKDString((String)"2\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_9", (String)AbstractDraftBillDetailDataListPlugin.MODEL, (Object[])new Object[0]));
            this.put("threemonth", ResManager.loadKDString((String)"3\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_10", (String)AbstractDraftBillDetailDataListPlugin.MODEL, (Object[])new Object[0]));
            this.put("sixmonth", ResManager.loadKDString((String)"6\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_11", (String)AbstractDraftBillDetailDataListPlugin.MODEL, (Object[])new Object[0]));
            this.put("oversixmonth", ResManager.loadKDString((String)"6\u4e2a\u6708\u4ee5\u4e0a\u5230\u671f", (String)"BillSpreadDataListPlugin_12", (String)AbstractDraftBillDetailDataListPlugin.MODEL, (Object[])new Object[0]));
        }
    };
    private String selectField = "id,orgid company,billtype,registereddate,draftbillno,subbillrange,currency,issuedate,expiredate,originalamount, amount,drawername,draweraccountname,  drawerbank,receivername, receiveraccount, receiverbankname,acceptername, accepteraccount, accepterbankcatename, accepterbankcate, accepterinstitution,delivername,deliver,receiver, description,billstatus,draftbillstatus,rptype,bizdate,rate, draftbillcount,originalsubbillrang,originalsubbillamount,eledraftstatusnew,eledraftstatus,elccirculatestatus,dateRange";

    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"AbstractDraftBillDetailDataListPlugin_0", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"billtype", ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b", (String)"AbstractDraftBillDetailDataListPlugin_2", (String)MODEL, (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("5", ResManager.loadKDString((String)"\u5546\u4e1a\u627f\u5151", (String)"AbstractDraftBillDetailDataListPlugin_3", (String)MODEL, (Object[])new Object[0]), "6", ResManager.loadKDString((String)"\u94f6\u884c\u627f\u5151", (String)"AbstractDraftBillDetailDataListPlugin_4", (String)MODEL, (Object[])new Object[0]), "20", ResManager.loadKDString((String)"\u8d22\u53f8\u627f\u5151", (String)"AbstractDraftBillDetailDataListPlugin_5", (String)MODEL, (Object[])new Object[0]))});
        field.add(new Object[]{"registereddate", ResManager.loadKDString((String)"\u767b\u8bb0\u65e5\u671f", (String)"AbstractDraftBillDetailDataListPlugin_6", (String)MODEL, (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"draftbillno", ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801", (String)"AbstractDraftBillDetailDataListPlugin_7", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"subbillrange", ResManager.loadKDString((String)"\u5b50\u7968\u5305\u533a\u95f4", (String)"AbstractDraftBillDetailDataListPlugin_8", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"originalsubbillrang", ResManager.loadKDString((String)"\u539f\u59cb\u5b50\u7968\u5305\u533a\u95f4", (String)"AbstractDraftBillDetailDataListPlugin_29", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"AbstractDraftBillDetailDataListPlugin_9", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"issuedate", ResManager.loadKDString((String)"\u51fa\u7968\u65e5\u671f", (String)"AbstractDraftBillDetailDataListPlugin_10", (String)MODEL, (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"expiredate", ResManager.loadKDString((String)"\u7968\u636e\u5230\u671f\u65e5", (String)"AbstractDraftBillDetailDataListPlugin_11", (String)MODEL, (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"draftbillcount", ResManager.loadKDString((String)"\u7b14\u6570", (String)"AbstractDraftBillDetailDataListPlugin_12", (String)MODEL, (Object[])new Object[0]), "integer", false});
        field.add(new Object[]{"originalamount", ResManager.loadKDString((String)"\u7968\u9762\u91d1\u989d", (String)"AbstractDraftBillDetailDataListPlugin_13", (String)MODEL, (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u7968\u9762\u91d1\u989d\u6298\u7b97", (String)"AbstractDraftBillDetailDataListPlugin_14", (String)MODEL, (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"originalsubbillamount", ResManager.loadKDString((String)"\u539f\u59cb\u5b50\u7968\u5305\u91d1\u989d", (String)"AbstractDraftBillDetailDataListPlugin_30", (String)MODEL, (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"drawername", ResManager.loadKDString((String)"\u51fa\u7968\u4eba\u5168\u79f0", (String)"AbstractDraftBillDetailDataListPlugin_15", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"draweraccountname", ResManager.loadKDString((String)"\u51fa\u7968\u4eba\u8d26\u53f7", (String)"AbstractDraftBillDetailDataListPlugin_16", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"drawerbank", ResManager.loadKDString((String)"\u51fa\u7968\u4eba\u5f00\u6237\u884c", (String)"AbstractDraftBillDetailDataListPlugin_17", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"receivername", ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5168\u79f0", (String)"AbstractDraftBillDetailDataListPlugin_18", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"receiveraccount", ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u8d26\u53f7", (String)"AbstractDraftBillDetailDataListPlugin_19", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"receiverbankname", ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5f00\u6237\u884c", (String)"AbstractDraftBillDetailDataListPlugin_20", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"acceptername", ResManager.loadKDString((String)"\u627f\u5151\u4eba\u5168\u79f0", (String)"AbstractDraftBillDetailDataListPlugin_21", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"accepteraccount", ResManager.loadKDString((String)"\u627f\u5151\u4eba\u8d26\u53f7", (String)"AbstractDraftBillDetailDataListPlugin_22", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"accepterbankcatename", ResManager.loadKDString((String)"\u627f\u5151\u4eba\u94f6\u884c\u7c7b\u522b", (String)"AbstractDraftBillDetailDataListPlugin_23", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"accepterinstitution", ResManager.loadKDString((String)"\u627f\u5151\u673a\u6784\u7c7b\u578b", (String)"AbstractDraftBillDetailDataListPlugin_35", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"delivername", ResManager.loadKDString((String)"\u4ea4\u7968\u4eba\u5168\u79f0", (String)"AbstractDraftBillDetailDataListPlugin_24", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"description", ResManager.loadKDString((String)"\u6458\u8981", (String)"AbstractDraftBillDetailDataListPlugin_25", (String)MODEL, (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"billstatus", ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"AbstractDraftBillDetailDataListPlugin_26", (String)MODEL, (Object[])new Object[0]), "combofield", false, DecisionAnlsHelper.getEnumItemsByProperty("cdm_receivablebill", "billstatus")});
        field.add(new Object[]{"eledraftstatusnew", ResManager.loadKDString((String)"\u7535\u7968\u72b6\u6001", (String)"AbstractDraftBillDetailDataListPlugin_31", (String)MODEL, (Object[])new Object[0]), "combofield", false, DecisionAnlsHelper.getEnumItemsByProperty("receivebill".equals(this.getRpType()) || "discount".equals(this.getRpType()) ? "cdm_receivablebill" : "cdm_payablebill", "eledraftstatusnew")});
        field.add(new Object[]{"eledraftstatus", ResManager.loadKDString((String)"\u7535\u7968\u72b6\u6001\uff08\u65e7\uff09", (String)"AbstractDraftBillDetailDataListPlugin_33", (String)MODEL, (Object[])new Object[0]), "combofield", false, DecisionAnlsHelper.getEnumItemsByProperty("receivebill".equals(this.getRpType()) || "discount".equals(this.getRpType()) ? "cdm_receivablebill" : "cdm_payablebill", "eledraftstatus")});
        field.add(new Object[]{"elccirculatestatus", ResManager.loadKDString((String)"\u7535\u7968\u6d41\u901a\u6807\u8bc6", (String)"AbstractDraftBillDetailDataListPlugin_32", (String)MODEL, (Object[])new Object[0]), "combofield", false, DecisionAnlsHelper.getEnumItemsByProperty("receivebill".equals(this.getRpType()) || "discount".equals(this.getRpType()) ? "cdm_receivablebill" : "cdm_payablebill", "elccirculatestatus")});
        field.add(new Object[]{"draftbillstatus", ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001", (String)"AbstractDraftBillDetailDataListPlugin_27", (String)MODEL, (Object[])new Object[0]), "combofield", false, DecisionAnlsHelper.getEnumItemsByProperty("receivebill".equals(this.getRpType()) || "discount".equals(this.getRpType()) ? "cdm_receivablebill" : "cdm_payablebill", "draftbillstatus")});
        if (!"discount".equals(this.getRpType())) {
            field.add(new Object[]{"rptype", ResManager.loadKDString((String)"\u6536\u4ed8\u7c7b\u578b", (String)"AbstractDraftBillDetailDataListPlugin_28", (String)MODEL, (Object[])new Object[0]), "combofield", false, DecisionAnlsHelper.getEnumItemsByProperty("cdm_receivablebill", "rptype")});
        }
        if ("balance".equals(this.getAmountType())) {
            field.add(new Object[]{"dateRange", ResManager.loadKDString((String)"\u5230\u671f\u671f\u9650\u7c7b\u578b", (String)"AbstractDraftBillDetailDataListPlugin_34", (String)MODEL, (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("onemonth", this.monthMap.get("onemonth"), "twomonth", this.monthMap.get("twomonth"), "threemonth", this.monthMap.get("threemonth"), "sixmonth", this.monthMap.get("sixmonth"), "oversixmonth", this.monthMap.get("oversixmonth"))});
        }
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet billDataSet;
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        String customType = (String)paramMap.get("customtype");
        String dateType = (String)paramMap.get("datetype");
        String displayType = (String)paramMap.get(DISPLAYTYPE);
        String amountType = this.getAmountType();
        if ("balance".equals(amountType)) {
            billDataSet = DraftBillDataHelper.getBillBalanceDataSet((String)"BillBalanceDetail", (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (String)this.getRpType());
            billDataSet = billDataSet.addField("' '", "dateRange");
            billDataSet = DraftBillSpreadHelper.getDataSetByCurrentDate(billDataSet, queryDate, new ArrayList<String>(this.monthMap.keySet()), new ArrayList<String>(this.monthMap.values()));
        } else {
            if ("discount".equals(this.getRpType())) {
                billDataSet = DraftBillDataHelper.getRecBillDiscountDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
                String ranstatus = ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"AbstractDraftBillDetailDataListPlugin_36", (String)MODEL, (Object[])new Object[0]);
                billDataSet = billDataSet.addField('\'' + ranstatus + '\'', "draftbilltranstatus");
                this.selectField = this.selectField + ",draftbilltranstatus,discountrate,discountinterest,recbodyname,recbodybankcatename";
            } else {
                billDataSet = DraftBillDataHelper.getBillAccruedDataSet((String)"BillAccruedDetail", (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (String)this.getRpType());
            }
            DataSet[] dateRangeDataSet = DraftBillDataHelper.getDateRangeDataSet((DataSet)billDataSet, (Date)queryDate, null, (boolean)true);
            billDataSet = dateRangeDataSet[0].addField("''", PERIODNAME);
            billDataSet = DraftBillUpdateFieldFunction.updateFields((DataSet)billDataSet, (DraftBillUpdateFieldFunction[])new DraftBillUpdateFieldFunction[]{DraftBillUpdateFieldFunction.dateTypeUpdateFunction((Date)queryDate, (String)PERIODNAME)});
            String filter = "customtype = '" + customType + "' and " + PERIODNAME + " = '" + dateType + "'";
            billDataSet = billDataSet.filter(filter).addField("' '", "dateRange");
        }
        if (EmptyUtil.isNoEmpty((String)displayType) && !ALLTYPE.equals(displayType)) {
            billDataSet = billDataSet.filter("billtype = displayType", Collections.singletonMap(DISPLAYTYPE, displayType));
        }
        billDataSet = billDataSet.addField("case when billtype = '6' then accepterbankcatename else acceptername end", "accepterinstitution");
        billDataSet = billDataSet.select(this.selectField);
        return billDataSet;
    }

    protected abstract String getRpType();

    protected abstract String getAmountType();

    @Override
    protected String getCountField() {
        return "draftbillcount";
    }

    @Override
    protected List<String> getSumLists() {
        return Collections.singletonList("amount");
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("draftbillno", "id");
    }
}

