/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.note.helper.DraftBillAmountHelper;
import kd.tmc.tda.report.note.helper.DraftBillSpreadHelper;

public class BillSpreadDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String receivebill = "receivebill";
    private static final String ORG = "org";
    private static final String ORG_NAME = "org_name";
    private static final String ORGID = "rowid";
    private static final String PID = "pid";
    private static final String LEVEL = "level";
    private static final String BILLTYPE = "billtype";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String MODEL = "tmc-tda-report";
    private static final String AMOUNT = "amount";
    private Set<String> removeFieldSet;
    private String rpType = "receivebill";
    private List<String> colTypeFields;
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("onemonth_bankamount", "twomonth_bankamount", "threemonth_bankamount", "sixmonth_bankamount", "oversixmonth_bankamount", "onemonth_financeamount", "twomonth_financeamount", "threemonth_financeamount", "sixmonth_financeamount", "oversixmonth_financeamount", "onemonth_businessamount", "twomonth_businessamount", "threemonth_businessamount", "sixmonth_businessamount", "oversixmonth_businessamount");
    private static final List<String> COUNT_FIELDS = Arrays.asList("onemonth_bankcount", "twomonth_bankcount", "threemonth_bankcount", "sixmonth_bankcount", "oversixmonth_bankcount", "onemonth_financecount", "twomonth_financecount", "threemonth_financecount", "sixmonth_financecount", "oversixmonth_financecount", "onemonth_businesscount", "twomonth_businesscount", "threemonth_businesscount", "sixmonth_businesscount", "oversixmonth_businesscount");
    private static final List<String> AMOUNT_TOTAL_FIELDS = Arrays.asList("onemonth_totalamount", "twomonth_totalamount", "threemonth_totalamount", "sixmonth_totalamount", "oversixmonth_totalamount");
    private static final List<String> COUNT_TOTAL_FIELDS = Arrays.asList("onemonth_totalcount", "twomonth_totalcount", "threemonth_totalcount", "sixmonth_totalcount", "oversixmonth_totalcount");
    private final Map<String, LocaleString> headTitle = new HashMap<String, LocaleString>(16);
    private final Map<String, String> monthMap;

    public BillSpreadDataListPlugin() {
        this.headTitle.put("receivebill_bank", new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u94f6\u884c\u627f\u5151", (String)"BillSpreadDataListPlugin_0", (String)MODEL, (Object[])new Object[0])));
        this.headTitle.put("receivebill_finance", new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u8d22\u53f8\u627f\u5151", (String)"BillSpreadDataListPlugin_1", (String)MODEL, (Object[])new Object[0])));
        this.headTitle.put("receivebill_business", new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u5546\u4e1a\u627f\u5151", (String)"BillSpreadDataListPlugin_2", (String)MODEL, (Object[])new Object[0])));
        this.headTitle.put("receivebill_total", new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u5408\u8ba1", (String)"BillSpreadDataListPlugin_3", (String)MODEL, (Object[])new Object[0])));
        this.headTitle.put("paybill_bank", new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u94f6\u884c\u627f\u5151", (String)"BillSpreadDataListPlugin_4", (String)MODEL, (Object[])new Object[0])));
        this.headTitle.put("paybill_finance", new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u8d22\u53f8\u627f\u5151", (String)"BillSpreadDataListPlugin_5", (String)MODEL, (Object[])new Object[0])));
        this.headTitle.put("paybill_business", new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u5546\u4e1a\u627f\u5151", (String)"BillSpreadDataListPlugin_6", (String)MODEL, (Object[])new Object[0])));
        this.headTitle.put("paybill_total", new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u5408\u8ba1", (String)"BillSpreadDataListPlugin_7", (String)MODEL, (Object[])new Object[0])));
        this.monthMap = new LinkedHashMap<String, String>(10);
        this.monthMap.put("onemonth", ResManager.loadKDString((String)"1\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_8", (String)MODEL, (Object[])new Object[0]));
        this.monthMap.put("twomonth", ResManager.loadKDString((String)"2\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_9", (String)MODEL, (Object[])new Object[0]));
        this.monthMap.put("threemonth", ResManager.loadKDString((String)"3\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_10", (String)MODEL, (Object[])new Object[0]));
        this.monthMap.put("sixmonth", ResManager.loadKDString((String)"6\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_11", (String)MODEL, (Object[])new Object[0]));
        this.monthMap.put("oversixmonth", ResManager.loadKDString((String)"6\u4e2a\u6708\u4ee5\u4e0a\u5230\u671f", (String)"BillSpreadDataListPlugin_12", (String)MODEL, (Object[])new Object[0]));
    }

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)reportQueryParam);
        return this.queryData(paramMap);
    }

    private DataSet queryData(Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String rptype = (String)paramMap.get("rptype");
        List allorgids = (List)paramMap.get("allorgids");
        long orgViewid = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet allDs = DraftBillDataHelper.getBillBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewid, (String)rptype).addField("' '", "dateRange").addField("orgid", ORG).updateField(BILLTYPE, "case when billtype = '6' then 'bank' when billtype = '20' then 'finance' when billtype = '5' then 'business' else 'other' end").select("org,billtype,dateRange,amount,expiredate,draftbillcount as count");
        DataSet union = DraftBillSpreadHelper.getDataSetByCurrentDate(allDs, queryDate, new ArrayList<String>(this.monthMap.keySet()), new ArrayList<String>(this.monthMap.values()));
        union = union.select(new String[]{ORG, BILLTYPE, "count", "dateRange", "concat(dateRange,concat('_',billtype)) as billTypeAndRange", "case when amount is Null then 0 else amount end as amount"});
        union = union.groupBy(new String[]{ORG, "billTypeAndRange"}).sum("count").sum(AMOUNT).finish();
        List<String> sumFields = Arrays.asList(AMOUNT, "count");
        DataSet changeSet = DecisionAnlsHelper.typeGroupFiledSum(union, ORG, "", "billTypeAndRange", sumFields, new ArrayList<String>(16));
        changeSet = DecisionAnlsHelper.addAbsentFields(changeSet, AMOUNT_FIELDS, "0.0");
        changeSet = DecisionAnlsHelper.addAbsentFields(changeSet, COUNT_FIELDS, "0");
        changeSet = changeSet.addFields(new String[]{"0.0", "0.0", "0.0", "0.0", "0.0"}, AMOUNT_TOTAL_FIELDS.toArray(new String[0]));
        changeSet = changeSet.addFields(new String[]{"0", "0", "0", "0", "0"}, COUNT_TOTAL_FIELDS.toArray(new String[0]));
        return changeSet;
    }

    private List<String> getOrgFieldList() {
        return Stream.of("mixorgname org_name", "0 sumlevel", ORG, ORGID, PID, LEVEL, ISGROUPNODE).collect(Collectors.toList());
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(10);
        fields.addAll(AMOUNT_FIELDS.stream().collect(Collectors.toSet()));
        fields.addAll(AMOUNT_TOTAL_FIELDS.stream().collect(Collectors.toSet()));
        fields.removeAll(this.removeFieldSet);
        return fields;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.rpType = (String)paramMap.get("rptype");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List<String> fieldList = this.getOrgFieldList();
        fieldList.addAll(AMOUNT_FIELDS);
        fieldList.addAll(COUNT_FIELDS);
        fieldList.add("sortcode");
        DataSet leftJoinBankDataSet = orgDateSet.leftJoin(ds).on(ORG, ORG).select(fieldList.toArray(new String[0])).finish();
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        DataSet parentOrgDs = leftJoinBankDataSet.copy().filter("rowid= " + ((DynamicObject)parentOrgs.get(0)).getString("id"));
        parentOrgDs = parentOrgDs.updateField(ISGROUPNODE, "'0'");
        ArrayList<String> sumFields = new ArrayList<String>(AMOUNT_FIELDS);
        sumFields.addAll(COUNT_FIELDS);
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinBankDataSet, sumFields, String.join((CharSequence)",", "sortcode", ORG_NAME, ORG));
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = CollectionUtils.isEmpty((Collection)subOrgIds) ? DecisionAnlsHelper.createEmptyDataSet(sumDataSet.getRowMeta()) : sumDataSet.filter("org in suborgids", Collections.singletonMap("suborgids", subOrgIds));
        fieldList.set(0, ORG_NAME);
        DataSet resultSet = parentOrgDs.union(sumDataSet.select(fieldList.toArray(new String[0])));
        resultSet = this.addTotalField(resultSet);
        sumFields.addAll(AMOUNT_TOTAL_FIELDS);
        sumFields.addAll(COUNT_TOTAL_FIELDS);
        resultSet = resultSet.addField("onemonth_totalamount + twomonth_totalamount + threemonth_totalamount + sixmonth_totalamount + oversixmonth_totalamount", "totalamount");
        resultSet = resultSet.filter("totalamount != 0 and totalamount != null");
        if (resultSet.getRowMeta().getFieldIndex("sortcode", false) >= 0) {
            resultSet = resultSet.orderBy(new String[]{"sortcode"});
        }
        DataSet sDataSet = DecisionAnlsHelper.addAllTotalDataSet(resultSet, sumFields, ORG_NAME);
        this.removeFieldSet = this.getColTypeField(sDataSet);
        resultSet = resultSet.union(sDataSet);
        resultSet = resultSet.removeFields(this.removeFieldSet.toArray(new String[0]));
        return resultSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        this.colTypeFields.add("_total");
        HashSet<String> removeTerms = new HashSet<String>(8);
        for (String prefixType : this.removeFieldSet) {
            removeTerms.add(prefixType.split(AMOUNT)[0]);
        }
        for (String billType : this.colTypeFields) {
            ReportColumnGroup group = new ReportColumnGroup();
            group.setHideSingleColumnRow(false);
            group.setFieldKey(billType);
            String key = this.rpType + billType;
            if (EmptyUtil.isNotBlank((CharSequence)key)) {
                LocaleString localeString = this.headTitle.get(key);
                group.setCaption(localeString);
            } else {
                group.setCaption(new LocaleString(""));
            }
            this.monthMap.forEach((k, v) -> {
                String prefixType = k + billType;
                ReportColumnGroup termGroup = new ReportColumnGroup();
                termGroup.setHideSingleColumnRow(false);
                termGroup.setFieldKey(prefixType);
                termGroup.setCaption(new LocaleString(v));
                group.getChildren().add(termGroup);
                if (!removeTerms.contains(prefixType)) {
                    String amtCaption = ResManager.loadKDString((String)"\u91d1\u989d", (String)"BillSpreadDataListPlugin_13", (String)MODEL, (Object[])new Object[0]);
                    DraftBillAmountHelper.buildReportColumn(termGroup, prefixType + AMOUNT, amtCaption, "decimal");
                    String cntCaption = ResManager.loadKDString((String)"\u7b14\u6570", (String)"BillSpreadDataListPlugin_14", (String)MODEL, (Object[])new Object[0]);
                    DraftBillAmountHelper.buildReportColumn(termGroup, prefixType + "count", cntCaption, "text");
                }
            });
            columns.add((AbstractReportColumn)group);
        }
        return columns;
    }

    private DataSet addTotalField(DataSet resultSet) {
        ArrayList<String> termList = new ArrayList<String>(this.monthMap.keySet());
        List<String> cntList = Arrays.asList("_bankcount", "_financecount", "_businesscount");
        for (String term : termList) {
            for (String cnt : cntList) {
                String termCnt = term + cnt;
                String cntExpr = String.format("case when %1$s is null then 0 else %1$s end", termCnt);
                resultSet = resultSet.updateField(termCnt, cntExpr);
            }
        }
        resultSet = resultSet.addField("onemonth_bankamount + onemonth_financeamount + onemonth_businessamount", "onemonth_totalamount");
        resultSet = resultSet.addField("twomonth_bankamount + twomonth_financeamount + twomonth_businessamount", "twomonth_totalamount");
        resultSet = resultSet.addField("threemonth_bankamount + threemonth_financeamount + threemonth_businessamount", "threemonth_totalamount");
        resultSet = resultSet.addField("sixmonth_bankamount + sixmonth_financeamount + sixmonth_businessamount", "sixmonth_totalamount");
        resultSet = resultSet.addField("oversixmonth_bankamount + oversixmonth_financeamount + oversixmonth_businessamount", "oversixmonth_totalamount");
        resultSet = resultSet.addField("onemonth_bankcount + onemonth_financecount + onemonth_businesscount", "onemonth_totalcount");
        resultSet = resultSet.addField("twomonth_bankcount + twomonth_financecount + twomonth_businesscount", "twomonth_totalcount");
        resultSet = resultSet.addField("threemonth_bankcount + threemonth_financecount + threemonth_businesscount", "threemonth_totalcount");
        resultSet = resultSet.addField("sixmonth_bankcount + sixmonth_financecount + sixmonth_businesscount", "sixmonth_totalcount");
        resultSet = resultSet.addField("oversixmonth_bankcount + oversixmonth_financecount + oversixmonth_businesscount", "oversixmonth_totalcount");
        return resultSet;
    }

    public Set<String> getColTypeField(DataSet totalDataSet) {
        HashSet<String> removeOverFieldSet = new HashSet<String>(5);
        if (totalDataSet.isEmpty()) {
            return removeOverFieldSet;
        }
        List<String> billTypeList = Arrays.asList("_bank", "_finance", "_business");
        ArrayList<String> termList = new ArrayList<String>(this.monthMap.keySet());
        this.colTypeFields = new ArrayList<String>(6);
        RowMeta rowMeta = totalDataSet.getRowMeta();
        Row row = totalDataSet.copy().next();
        for (String billType : billTypeList) {
            BigDecimal billTypeTotal = BigDecimal.ZERO;
            for (String term : termList) {
                String cilFiled = term + billType + AMOUNT;
                billTypeTotal = billTypeTotal.add(row.getBigDecimal(cilFiled));
            }
            if (billTypeTotal.compareTo(BigDecimal.ZERO) <= 0) continue;
            this.colTypeFields.add(billType);
        }
        for (String fieldName : rowMeta.getFieldNames()) {
            Object obj;
            if (!fieldName.startsWith("oversixmonth_") || !((obj = row.get(fieldName)) instanceof BigDecimal) || ((BigDecimal)obj).compareTo(BigDecimal.ZERO) != 0) continue;
            removeOverFieldSet.add(fieldName);
        }
        return removeOverFieldSet;
    }
}

