/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class DraftBillAccepterBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String RPT_TYPE = "rptype";
    private static final String BILLNUM = "billnum";
    private static final String RECEIVE_BILL = "receivebill";
    private String rptTypeValue;
    private static final String BANKNAME = "bankname";
    private static final String BANKCATE = "bankcate";
    private static final String AMOUNT = "amount";
    private static final String BILL_TYPE = "billtype";
    private static final String ORGID = "orgid";
    private static final int TOP = 10;
    private static final String ROWID = "rowid";
    private static final String STAT = "stat";
    private static final String STAT_NUM = "statnum";
    private static final String BANKSTAT = "bankcate_allamount";
    private static final String BANKSTAT_NUM = "bankcate_allbillnum";
    private static final String PREFIX = "bankcate_";
    private static final String OHTERBANK_ID = "0";
    private static final String FINANCE_ID = "5";
    private static final String FINCOMP_ID = "20";

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet detaiData = DraftBillDataHelper.getBillBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (String)this.getRpType(queryParam));
        String selectStr = "orgid,accepterbankcate bankcate,accepterbankcatename bankname,amount,draftbillcount as billnum,billtype,rptype";
        DataSet result = detaiData.select(selectStr).groupBy(new String[]{ORGID, BANKNAME, BANKCATE, BILL_TYPE, RPT_TYPE}).sum(AMOUNT).sum(BILLNUM).finish();
        return result;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet result, ReportQueryParam queryParam) {
        DataSet bankUnionSet;
        Map paramMap = this.transQueryParam(queryParam);
        if (EmptyUtil.isNoEmpty((String)this.getRpType(queryParam))) {
            result = result.filter("rptype = '" + this.rptTypeValue + "'");
        }
        DataSet[] splitDataSets = result.splitByFilter(new String[]{"billtype = '6' and bankcate != 0", "billtype = '6' and bankcate = 0", "billtype = '20'", "billtype = '5'"}, false);
        DataSet bankDataSte = splitDataSets[0];
        DataSet otherBankDataSte = splitDataSets[1];
        Pair<DataSet, DataSet> splitBankDataSet = DecisionAnlsHelper.splitTopBank(bankDataSte, AMOUNT, 10);
        DataSet topDomesticBankAcctSet = ((DataSet)splitBankDataSet.getValue0()).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(BILLNUM).finish().orderBy(new String[]{"amount desc"});
        if (splitBankDataSet.getValue1() != null) {
            DataSet otherDomesticBankAcctSet = ((DataSet)splitBankDataSet.getValue1()).updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"DraftBillAccepterBankDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), OHTERBANK_ID}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(BILLNUM).finish();
            bankUnionSet = topDomesticBankAcctSet.union(otherDomesticBankAcctSet);
        } else {
            bankUnionSet = topDomesticBankAcctSet;
        }
        otherBankDataSte = otherBankDataSte.updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"DraftBillAccepterBankDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), OHTERBANK_ID}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(BILLNUM).finish();
        bankUnionSet = bankUnionSet.union(otherBankDataSte).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(BILLNUM).finish();
        DataSet financeDataSet = splitDataSets[2].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u8d22\u52a1\u516c\u53f8'", (String)"ReceiveBillDiscountBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), FINCOMP_ID}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(BILLNUM).finish();
        DataSet clearingHouseSet = splitDataSets[3].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u5546\u4e1a\u7968\u636e'", (String)"ReceiveBillDiscountBankQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), FINANCE_ID}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(BILLNUM).finish();
        DataSet allData = bankUnionSet.union(new DataSet[]{financeDataSet, clearingHouseSet});
        allData = AmountTransHelper.dealRowOtherValue((DataSet)allData, (Map)paramMap, new HashSet<String>(Collections.singletonList(AMOUNT)));
        DataSet copy = allData.copy();
        DataSet afterChangeRowToColSet = DecisionAnlsHelper.ChangeMultRowToColDataSet(allData, BANKCATE, ORGID, PREFIX, Arrays.asList(AMOUNT, BILLNUM));
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> sumField = this.getSumField(afterChangeRowToColSet);
        List<String> selectField = this.getSelectField(sumField);
        selectField.add("sortcode");
        afterChangeRowToColSet = this.groupby(afterChangeRowToColSet, new String[]{ORGID}, sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(afterChangeRowToColSet).on(ROWID, ORGID).select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "sortcode,orgname,mixorgname,rowid orgid");
        List subOrgids = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)subOrgids)) {
            subOrgids = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in orgidparam", Collections.singletonMap("orgidparam", subOrgids));
        Set sumColSet = sumField.stream().filter(f -> f.endsWith(AMOUNT)).collect(Collectors.toSet());
        Set sumNumColSet = sumField.stream().filter(f -> f.endsWith(BILLNUM)).collect(Collectors.toSet());
        sumDataSet = sumDataSet.addField(CollectionUtils.isNotEmpty(sumColSet) ? String.join((CharSequence)"+", sumColSet) : OHTERBANK_ID, STAT);
        sumDataSet = sumDataSet.addField(CollectionUtils.isNotEmpty(sumNumColSet) ? String.join((CharSequence)"+", sumNumColSet) : OHTERBANK_ID, STAT_NUM);
        boolean allColEmpty = EmptyUtil.isEmpty(sumColSet) && EmptyUtil.isEmpty(sumNumColSet);
        Set sumBankColSet = sumField.stream().filter(f -> f.endsWith(AMOUNT) && !"bankcate_5amount".equals(f) && !"bankcate_20amount".equals(f)).collect(Collectors.toSet());
        Set sumBankNumColSet = sumField.stream().filter(f -> f.endsWith(BILLNUM) && !"bankcate_5billnum".equals(f) && !"bankcate_20billnum".equals(f)).collect(Collectors.toSet());
        sumDataSet = sumDataSet.addField(CollectionUtils.isNotEmpty(sumBankColSet) ? String.join((CharSequence)"+", sumBankColSet) : OHTERBANK_ID, BANKSTAT);
        sumDataSet = sumDataSet.addField(CollectionUtils.isNotEmpty(sumBankNumColSet) ? String.join((CharSequence)"+", sumBankNumColSet) : OHTERBANK_ID, BANKSTAT_NUM);
        boolean allBankColEmpty = EmptyUtil.isEmpty(sumBankColSet) && EmptyUtil.isEmpty(sumBankNumColSet);
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        sumDataSet = this.removeAllZeroRow(sumDataSet, sumField.stream().collect(Collectors.toSet()));
        sumField.add(STAT);
        sumField.add(STAT_NUM);
        sumField.add(BANKSTAT);
        sumField.add(BANKSTAT_NUM);
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, sumField, "mixorgname");
        totalSet = DecisionAnlsHelper.updateValueWhenNull(totalSet, sumField);
        List<AbstractReportColumn> cols = this.getCols(totalSet.copy(), copy, allBankColEmpty, allColEmpty);
        queryParam.getCustomParam().put("topBankMap", cols);
        DataSet resultDataSet = sumDataSet.union(totalSet);
        return resultDataSet;
    }

    private DataSet groupby(DataSet groupDataSet, String[] groupStrs, List<String> sumFields) {
        GroupbyDataSet groupbyDataSet = groupDataSet.groupBy(groupStrs);
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        return groupbyDataSet.finish();
    }

    private List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(25);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("mixorgname orgname");
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add(ORGID);
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        return selectField;
    }

    private List<AbstractReportColumn> getCols(DataSet totalSet, DataSet allData, boolean allBankColEmpty, boolean allColEmpty) {
        if (totalSet.isEmpty()) {
            return new ArrayList<AbstractReportColumn>();
        }
        Map<Long, String> bankMap = this.getBankColKayAndNameMap(allData);
        Set<String> bankCols = this.getBankCols(Arrays.asList(totalSet.getRowMeta().getFieldNames()), AMOUNT);
        ArrayList<AbstractReportColumn> datas = new ArrayList<AbstractReportColumn>(3);
        ArrayList<AbstractReportColumn> bankColumn = new ArrayList<AbstractReportColumn>(11);
        String otherBankCateColKey = this.getBankcateAmountColName(OHTERBANK_ID);
        if (CollectionUtils.isNotEmpty(bankCols)) {
            Row totalRow = totalSet.next();
            ArrayList totalRowData = new ArrayList(32);
            bankCols.forEach(r -> {
                BigDecimal bankCateAmount = totalRow.getBigDecimal(r);
                if (!otherBankCateColKey.equals(r)) {
                    totalRowData.add(new Pair(r, (Object)bankCateAmount));
                }
            });
            Collections.sort(totalRowData, (o1, o2) -> ((BigDecimal)o2.getValue1()).compareTo((BigDecimal)o1.getValue1()));
            for (Pair colNamePair : totalRowData) {
                String colKey = (String)colNamePair.getValue0();
                String substring = colKey.substring(PREFIX.length(), colKey.indexOf(AMOUNT));
                Long bankCateId = Long.valueOf(substring);
                bankColumn.add(this.getReportCol(bankMap.get(bankCateId), colKey));
            }
        }
        if (this.colExists(totalSet, OHTERBANK_ID)) {
            bankColumn.add(this.getReportCol(ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"DraftBillAccepterBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), this.getBankcateAmountColName(OHTERBANK_ID)));
        }
        if (this.colExists(totalSet, "all")) {
            bankColumn.add(this.getReportCol(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"DraftBillAccepterBankDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), this.getBankcateAmountColName("all")));
        }
        if (!allBankColEmpty) {
            ReportColumnGroup bankGroupColumn = new ReportColumnGroup();
            bankGroupColumn.setFieldKey("bankgroup");
            if (RECEIVE_BILL.equals(this.rptTypeValue)) {
                bankGroupColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u94f6\u884c\u627f\u5151", (String)"DraftBillAccepterBankDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])));
            } else {
                bankGroupColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u94f6\u884c\u627f\u5151", (String)"DraftBillAccepterBankDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0])));
            }
            bankGroupColumn.getChildren().addAll(bankColumn);
            datas.add((AbstractReportColumn)bankGroupColumn);
        }
        if (this.colExists(totalSet, FINCOMP_ID)) {
            String finComCaption = RECEIVE_BILL.equals(this.rptTypeValue) ? ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u8d22\u53f8\u627f\u5151", (String)"DraftBillAccepterBankDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u8d22\u53f8\u627f\u5151", (String)"DraftBillAccepterBankDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]);
            datas.add(this.getReportCol(finComCaption, this.getBankcateAmountColName(FINCOMP_ID)));
        }
        if (this.colExists(totalSet, FINANCE_ID)) {
            String finCaption = RECEIVE_BILL.equals(this.rptTypeValue) ? ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u5546\u4e1a\u627f\u5151", (String)"DraftBillAccepterBankDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u5546\u4e1a\u627f\u5151", (String)"DraftBillAccepterBankDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]);
            datas.add(this.getReportCol(finCaption, this.getBankcateAmountColName(FINANCE_ID)));
        }
        if (!allColEmpty) {
            ColumnStyle columnStyle = new ColumnStyle();
            columnStyle.setTextAlign("right");
            ReportColumn newAmountCol = new ReportColumn();
            newAmountCol.setFieldKey(STAT);
            newAmountCol.setFieldType("decimal");
            newAmountCol.setZeroShow(true);
            newAmountCol.setScale(2);
            newAmountCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"DraftBillAccepterBankDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0])));
            newAmountCol.setStyle(columnStyle);
            ReportColumn newNumCol = new ReportColumn();
            newNumCol.setFieldKey(STAT_NUM);
            newNumCol.setFieldType("integer");
            newNumCol.setZeroShow(true);
            newNumCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7b14\u6570", (String)"DraftBillAccepterBankDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0])));
            newNumCol.setStyle(columnStyle);
            ReportColumnGroup newCol = new ReportColumnGroup();
            newCol.setFieldKey("statgroup");
            newCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"DraftBillAccepterBankDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])));
            newCol.getChildren().add(newAmountCol);
            newCol.getChildren().add(newNumCol);
            datas.add((AbstractReportColumn)newCol);
        }
        return datas;
    }

    private Map<Long, String> getBankColKayAndNameMap(DataSet allData) {
        HashMap<Long, String> bankMap = new HashMap<Long, String>(32);
        if (!allData.isEmpty()) {
            while (allData.hasNext()) {
                Row row = allData.next();
                bankMap.put(row.getLong(BANKCATE), row.getString(BANKNAME));
            }
        }
        return bankMap;
    }

    private boolean colExists(DataSet dataSet, String bankCateId) {
        return dataSet.getRowMeta().getFieldIndex(PREFIX + bankCateId + AMOUNT, false) != -1;
    }

    private AbstractReportColumn getReportCol(String catpion, String colKey) {
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        ReportColumn newAmountCol = new ReportColumn();
        newAmountCol.setFieldKey(colKey);
        newAmountCol.setFieldType("decimal");
        newAmountCol.setZeroShow(true);
        newAmountCol.setScale(2);
        newAmountCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"DraftBillAccepterBankDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0])));
        newAmountCol.setStyle(columnStyle);
        ReportColumn newNumCol = new ReportColumn();
        newNumCol.setFieldKey(colKey.replace(AMOUNT, BILLNUM));
        newNumCol.setFieldType("integer");
        newNumCol.setZeroShow(true);
        newNumCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7b14\u6570", (String)"DraftBillAccepterBankDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0])));
        newNumCol.setStyle(columnStyle);
        ReportColumnGroup newCol = new ReportColumnGroup();
        newCol.setCaption(new LocaleString(catpion));
        newCol.setFieldKey(colKey.replace(AMOUNT, "group"));
        newCol.getChildren().add(newAmountCol);
        newCol.getChildren().add(newNumCol);
        ReportColumnGroup result = newCol;
        return result;
    }

    private Set<String> getBankCols(List<String> sumField, String suffix) {
        return sumField.stream().filter(f -> f.endsWith(suffix) && !this.getBankcateAmountColName(FINCOMP_ID).equals(f) && !this.getBankcateAmountColName(FINANCE_ID).equals(f) && !this.getBankcateAmountColName("all").equals(f)).collect(Collectors.toSet());
    }

    private String getBankcateAmountColName(String bankCateId) {
        return PREFIX + bankCateId + AMOUNT;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = (List)this.getQueryParam().getCustomParam().get("topBankMap");
        columns.addAll(cols);
        return columns;
    }

    private String getRpType(ReportQueryParam queryParam) {
        if (EmptyUtil.isNoEmpty((String)this.rptTypeValue)) {
            return this.rptTypeValue;
        }
        Map paramMap = this.transQueryParam(queryParam);
        String type = (String)paramMap.get(RPT_TYPE);
        if (EmptyUtil.isEmpty((String)type)) {
            return "";
        }
        this.rptTypeValue = type;
        return type;
    }
}

