/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.note.helper.DraftBillAmountHelper;

public class DraftBillAmountDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String CLICK = "click";
    private static final String ORGID = "orgid";
    private static final String BILL_TYPE = "billtype";
    private static final String AMOUNT = "amount";
    private static final String COUNT = "count";
    private static final String RATE = "rate";
    private static final String MODEL = "tmc-tda-report";
    private Set<String> amountField;
    private String rpType;
    private final Map<String, Pair<Integer, LocaleString>> headTitle = new HashMap<String, Pair<Integer, LocaleString>>(16);

    public DraftBillAmountDataListPlugin() {
        this.headTitle.put("receivebillbilltype_6", (Pair<Integer, LocaleString>)new Pair((Object)1, (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u94f6\u884c\u627f\u5151", (String)"DraftBillAmountDataListPlugin_0", (String)MODEL, (Object[])new Object[0]))));
        this.headTitle.put("receivebillbilltype_20", (Pair<Integer, LocaleString>)new Pair((Object)2, (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u8d22\u53f8\u627f\u5151", (String)"DraftBillAmountDataListPlugin_1", (String)MODEL, (Object[])new Object[0]))));
        this.headTitle.put("receivebillbilltype_5", (Pair<Integer, LocaleString>)new Pair((Object)3, (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u5546\u4e1a\u627f\u5151", (String)"DraftBillAmountDataListPlugin_2", (String)MODEL, (Object[])new Object[0]))));
        this.headTitle.put("receivebilltotal_", (Pair<Integer, LocaleString>)new Pair((Object)4, (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u5408\u8ba1", (String)"DraftBillAmountDataListPlugin_3", (String)MODEL, (Object[])new Object[0]))));
        this.headTitle.put("paybillbilltype_6", (Pair<Integer, LocaleString>)new Pair((Object)1, (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u94f6\u884c\u627f\u5151", (String)"DraftBillAmountDataListPlugin_4", (String)MODEL, (Object[])new Object[0]))));
        this.headTitle.put("paybillbilltype_20", (Pair<Integer, LocaleString>)new Pair((Object)2, (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u8d22\u53f8\u627f\u5151", (String)"DraftBillAmountDataListPlugin_5", (String)MODEL, (Object[])new Object[0]))));
        this.headTitle.put("paybillbilltype_5", (Pair<Integer, LocaleString>)new Pair((Object)3, (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u5546\u4e1a\u627f\u5151", (String)"DraftBillAmountDataListPlugin_6", (String)MODEL, (Object[])new Object[0]))));
        this.headTitle.put("paybilltotal_", (Pair<Integer, LocaleString>)new Pair((Object)4, (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u5408\u8ba1", (String)"DraftBillAmountDataListPlugin_7", (String)MODEL, (Object[])new Object[0]))));
    }

    @Override
    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List orgIds = (List)paramMap.get("allorgids");
        String rpType = (String)paramMap.get("rptype");
        DataSet allDS = DraftBillDataHelper.getBillAccruedDataSet((String)this.createAlgoKey(""), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (String)rpType);
        String needField = "orgid, billtype, rptype, amount, registereddate, issuedate, draftbillcount as count";
        return allDS.select(needField);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List<String> cusParamList = this.getCustomerParam(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        this.rpType = (String)paramMap.get("rptype");
        DataSet termDS = DraftBillAmountHelper.getTermData(ds, queryDate, this.rpType, cusParamList.get(0), cusParamList.get(1));
        termDS = termDS.groupBy(new String[]{ORGID, BILL_TYPE}).sum(COUNT).sum(AMOUNT).finish();
        List<String> billTypes = Arrays.asList("5", "6", "20");
        termDS = termDS.filter("billtype in billTypes", Collections.singletonMap("billTypes", billTypes));
        List<String> sumFields = Arrays.asList(AMOUNT, COUNT);
        ArrayList<String> needColFiled = new ArrayList<String>(16);
        termDS = DecisionAnlsHelper.typeGroupFiledSum(termDS, ORGID, "billtype_", BILL_TYPE, sumFields, needColFiled);
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String[] selectField = DecisionAnlsHelper.getSelectField(needColFiled);
        DataSet orgTermDS = orgDateSet.leftJoin(termDS).on(ORGID, ORGID).select(selectField).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(orgTermDS, needColFiled, "orgid,sortcode,mixorgname");
        List subOrgIds = (List)paramMap.get("suborgids");
        if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
            long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
            sumDataSet = sumDataSet.filter("rowid = " + orgId).filter("total_amount > 0");
        } else {
            sumDataSet = sumDataSet.filter("rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds)).filter("total_amount > 0");
        }
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(sumDataSet, needColFiled, "mixorgname");
        DataSet resultDS = sumDataSet.union(totalDataSet);
        this.getTypeAmountFields(needColFiled);
        return this.handleRateAndCount(resultDS, this.amountField);
    }

    @Override
    protected Set<String> getAmountFields() {
        return this.amountField;
    }

    private List<String> getCustomerParam(Map<String, Object> paramMap) {
        String paramStr = (String)paramMap.get(CLICK);
        if (EmptyUtil.isNoEmpty((String)paramStr)) {
            return Arrays.asList(paramStr.split("_"));
        }
        return Arrays.asList("", "");
    }

    private void getTypeAmountFields(List<String> colFiled) {
        this.amountField = new HashSet<String>(8);
        for (String colName : colFiled) {
            if (!colName.endsWith(AMOUNT)) continue;
            this.amountField.add(colName);
        }
    }

    private DataSet handleRateAndCount(DataSet ds, Set<String> amountFieldSet) {
        int size = amountFieldSet.size();
        ArrayList<String> rateFie = new ArrayList<String>(size);
        ArrayList<String> rateExp = new ArrayList<String>(size);
        ArrayList<String> countFie = new ArrayList<String>(size);
        ArrayList<String> countExp = new ArrayList<String>(size);
        for (String amountField : amountFieldSet) {
            if (!amountField.startsWith("billtype_")) continue;
            String rateStr = String.format("case when (%1$s is null or %1$s=0) then 0.00 else round(%1$s / total_amount * 100, 2) end", amountField);
            String rateExpr = "concat(" + rateStr + ", ' %')";
            String prefix = amountField.split(AMOUNT)[0];
            rateFie.add(prefix + RATE);
            rateExp.add(rateExpr);
            String countField = prefix + COUNT;
            String countExpr = String.format("case when %1$s is null then 0 else %1$s end", countField);
            countFie.add(countField);
            countExp.add(countExpr);
        }
        ds = ds.addFields(rateExp.toArray(new String[0]), rateFie.toArray(new String[0]));
        ds = ds.updateFields(countFie.toArray(new String[0]), countExp.toArray(new String[0]));
        return ds;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ArrayList<String> billTypeList = new ArrayList<String>(this.amountField);
        TreeMap<Integer, ReportColumnGroup> colMap = new TreeMap<Integer, ReportColumnGroup>();
        for (String billType : billTypeList) {
            Integer sort = 6;
            String prefixType = billType.split(AMOUNT)[0];
            ReportColumnGroup group = new ReportColumnGroup();
            group.setHideSingleColumnRow(false);
            group.setFieldKey(prefixType);
            String key = this.rpType + prefixType;
            if (EmptyUtil.isNotBlank((CharSequence)key)) {
                sort = (Integer)this.headTitle.get(key).getValue0();
                LocaleString localeString = (LocaleString)this.headTitle.get(key).getValue1();
                group.setCaption(localeString);
            } else {
                sort = sort + 1;
                group.setCaption(new LocaleString(""));
            }
            if (prefixType != null && prefixType.startsWith("billtype_")) {
                DraftBillAmountHelper.buildReportColumn(group, prefixType + AMOUNT, ResManager.loadKDString((String)"\u7d2f\u8ba1\u91d1\u989d", (String)"DraftBillAmountDataListPlugin_8", (String)MODEL, (Object[])new Object[0]), "decimal");
                DraftBillAmountHelper.buildReportColumn(group, prefixType + COUNT, ResManager.loadKDString((String)"\u7d2f\u8ba1\u7b14\u6570", (String)"DraftBillAmountDataListPlugin_9", (String)MODEL, (Object[])new Object[0]), "text");
                DraftBillAmountHelper.buildReportColumn(group, prefixType + RATE, ResManager.loadKDString((String)"\u5360\u6bd4", (String)"DraftBillAmountDataListPlugin_12", (String)MODEL, (Object[])new Object[0]), "text");
            } else if (prefixType != null && prefixType.startsWith("total_")) {
                DraftBillAmountHelper.buildReportColumn(group, prefixType + AMOUNT, ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d", (String)"DraftBillAmountDataListPlugin_10", (String)MODEL, (Object[])new Object[0]), "decimal");
                DraftBillAmountHelper.buildReportColumn(group, prefixType + COUNT, ResManager.loadKDString((String)"\u5408\u8ba1\u7b14\u6570", (String)"DraftBillAmountDataListPlugin_11", (String)MODEL, (Object[])new Object[0]), "text");
            }
            colMap.put(sort, group);
        }
        columns.addAll(colMap.values());
        return columns;
    }
}

