/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.note.helper.DraftBillAmountHelper;

public class DraftBillAmtAccepterBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ORGID = "orgid";
    private static final String ROWID = "rowid";
    private static final String ACCEPTER_BANK = "accepterbankcate";
    private static final String BANK_NAME = "accepterbankcatename";
    private static final String BILL_TYPE = "billtype";
    private static final String AMOUNT = "amount";
    private static final String COUNT = "count";
    private static final int TOP_BANK_NUMBER = 10;
    private List<String> topBankCodes;
    private List<String> topBankNames;
    private static final String BANK_STAT = "bankstat";
    private static final String CLICK = "click";
    private static final String PREFIX = "accepterbank_";
    private Set<String> amountFields;
    private String rpType;
    private static final String FINORG = "finorg";
    private static final String BIZ = "bizbill";
    private static final String TOTAL = "total";

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List orgIds = (List)paramMap.get("allorgids");
        this.rpType = (String)paramMap.get("rptype");
        return DraftBillDataHelper.getBillAccruedDataSet((String)this.createAlgoKey(((Object)((Object)this)).getClass().getName()), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (String)this.rpType).filter("billtype in ('5', '6', '20')").select(new String[]{ORGID, ACCEPTER_BANK, BANK_NAME, BILL_TYPE, AMOUNT, "rptype", "registereddate", "issuedate", "draftbillcount count"});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        List subOrgIds;
        Map paramMap = this.transQueryParam(queryParam);
        String[] termParam = this.getCustomerParam(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        this.rpType = (String)paramMap.get("rptype");
        DataSet termDs = DraftBillAmountHelper.getTermData(dataSet, queryDate, this.rpType, termParam[0], termParam[1]);
        DataSet bankTopDs = this.convertAccepterBankTopOnDraftBill(termDs);
        ArrayList<String> colFields = new ArrayList<String>(32);
        bankTopDs = DecisionAnlsHelper.typeGroupFiledSum(bankTopDs, ORGID, PREFIX, ACCEPTER_BANK, Arrays.asList(AMOUNT, COUNT), colFields);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet resultSet = orgDs.leftJoin(bankTopDs).on(ROWID, ORGID).select(DecisionAnlsHelper.getSelectField(colFields)).finish();
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        DataSet sumDataSet = this.getSumDataSetByLevel(resultSet, colFields, "mixorgname, orgid, sortcode");
        List bankSumFields = this.topBankCodes.stream().map(e -> PREFIX + e + AMOUNT).collect(Collectors.toList());
        List bankCountFields = this.topBankCodes.stream().map(e -> PREFIX + e + COUNT).collect(Collectors.toList());
        this.amountFields = new HashSet(bankSumFields);
        if (EmptyUtil.isNoEmpty(bankSumFields)) {
            sumDataSet = sumDataSet.addField(String.join((CharSequence)"+", bankSumFields), BANK_STAT);
            bankSumFields.add(BANK_STAT);
            this.amountFields.add(BANK_STAT);
            sumDataSet = sumDataSet.addField(String.join((CharSequence)"+", bankCountFields), "bankstatcount");
            bankSumFields.addAll(this.topBankCodes.stream().map(e -> PREFIX + e + COUNT).collect(Collectors.toList()));
            bankSumFields.add("bankstatcount");
        }
        if ((sumDataSet = EmptyUtil.isEmpty((Collection)(subOrgIds = (List)paramMap.get("suborgids"))) ? sumDataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("total_amount > 0") : sumDataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("total_amount > 0")).getRowMeta().getFieldIndex("sortcode", false) >= 0) {
            sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        }
        sumDataSet = sumDataSet.addField("'groupcol'", "groupcol");
        if (EmptyUtil.isNoEmpty(bankSumFields)) {
            colFields.add(BANK_STAT);
            colFields.add("bankstatcount");
        }
        this.topBankCodes = bankSumFields;
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), colFields, "mixorgname");
        return sumDataSet.union(totalSet);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportColumnGroup group = this.getReportColumnGroup(columns);
        this.topBankNames.add(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"DraftBillAccepterBankDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
        if (!this.topBankCodes.isEmpty()) {
            int idx = 0;
            for (String topBankName : this.topBankNames) {
                String bankAmtCode = this.topBankCodes.get(idx);
                String bankCountCode = this.topBankCodes.get(idx + this.topBankNames.size());
                ReportColumnGroup bankGroup = new ReportColumnGroup();
                bankGroup.setHideSingleColumnRow(false);
                bankGroup.setFieldKey(PREFIX + idx);
                bankGroup.setCaption(new LocaleString(topBankName));
                DraftBillAmtAccepterBankDataListPlugin.buildReportColumn(bankGroup, bankAmtCode, ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvestReportDataHelper_0", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal");
                DraftBillAmtAccepterBankDataListPlugin.buildReportColumn(bankGroup, bankCountCode, ResManager.loadKDString((String)"\u7b14\u6570", (String)"AbstractDraftBillDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "integer");
                group.getChildren().add(bankGroup);
                ++idx;
            }
        }
        HashMap<String, String> draftBillColumnMap = this.createDraftBillColumnMap(this.rpType);
        columns.add((AbstractReportColumn)this.createReportGroup("accepterbank_20", draftBillColumnMap.get("accepterbank_finorg")));
        columns.add((AbstractReportColumn)this.createReportGroup("accepterbank_5", draftBillColumnMap.get("accepterbank_bizbill")));
        columns.add((AbstractReportColumn)this.createReportGroup("total_", draftBillColumnMap.get("accepterbank_total")));
        return columns;
    }

    @Override
    protected Set<String> getAmountFields() {
        return this.amountFields;
    }

    private DataSet convertAccepterBankTopOnDraftBill(DataSet dataSet) {
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"billtype = '6'", "billtype = '20'"}, true);
        DataSet bankBillDs = dataSets[0];
        DataSet finBillDs = dataSets[1];
        DataSet comBillDs = dataSets[2];
        DataSet topBankSet = bankBillDs.copy().filter("accepterbankcate <> 0L").groupBy(new String[]{ACCEPTER_BANK, BANK_NAME}).sum(AMOUNT).finish().orderBy(new String[]{"amount DESC"}).top(10);
        this.topBankCodes = new ArrayList<String>(12);
        this.topBankNames = new ArrayList<String>(12);
        while (topBankSet.hasNext()) {
            Row row = topBankSet.next();
            this.topBankCodes.add(String.valueOf(row.getLong(ACCEPTER_BANK)));
            this.topBankNames.add(row.getString(BANK_NAME));
        }
        if (this.topBankCodes.isEmpty()) {
            topBankSet = bankBillDs.groupBy(new String[]{ACCEPTER_BANK, ORGID}).sum(AMOUNT).sum(COUNT).finish().updateField(ACCEPTER_BANK, "6L");
            if (!topBankSet.isEmpty()) {
                this.topBankCodes.add("6");
                this.topBankNames.add(ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"DraftBillAccepterBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
            }
        } else {
            String filterStr = String.join((CharSequence)",", this.topBankCodes);
            DataSet[] topBankDatasets = bankBillDs.splitByFilter(new String[]{"accepterbankcate in (" + filterStr + ")"}, true);
            topBankSet = topBankDatasets[0].groupBy(new String[]{ACCEPTER_BANK, ORGID}).sum(AMOUNT).sum(COUNT).finish();
            DataSet noTopBankSet = topBankDatasets[1].updateField(ACCEPTER_BANK, "6L").groupBy(new String[]{ACCEPTER_BANK, ORGID}).sum(AMOUNT).sum(COUNT).finish();
            if (!noTopBankSet.isEmpty()) {
                this.topBankCodes.add("6");
                this.topBankNames.add(ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"DraftBillAccepterBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
            }
            topBankSet = topBankSet.union(noTopBankSet);
        }
        finBillDs = finBillDs.updateField(ACCEPTER_BANK, "20L").groupBy(new String[]{ACCEPTER_BANK, ORGID}).sum(AMOUNT).sum(COUNT).finish();
        topBankSet = topBankSet.union(finBillDs);
        comBillDs = comBillDs.updateField(ACCEPTER_BANK, "5L").groupBy(new String[]{ACCEPTER_BANK, ORGID}).sum(AMOUNT).sum(COUNT).finish();
        return topBankSet.union(comBillDs);
    }

    private String[] getCustomerParam(Map<String, Object> paramMap) {
        String paramStr = (String)paramMap.get(CLICK);
        if (EmptyUtil.isNoEmpty((String)paramStr)) {
            String[] split = paramStr.split("_");
            return new String[]{split[0], split[1]};
        }
        return new String[]{"", ""};
    }

    private ReportColumnGroup getReportColumnGroup(List<AbstractReportColumn> columns) {
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumnGroup)) continue;
            if ("receivebill".equals(this.rpType)) {
                column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u94f6\u884c\u627f\u5151", (String)"DraftBillAccepterBankDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])));
            } else {
                column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u94f6\u884c\u627f\u5151", (String)"DraftBillAccepterBankDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0])));
            }
            return (ReportColumnGroup)column;
        }
        return new ReportColumnGroup();
    }

    private ReportColumnGroup createReportGroup(String fieldKey, String caption) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setHideSingleColumnRow(false);
        group.setFieldKey(fieldKey);
        group.setCaption(new LocaleString(caption));
        DraftBillAmtAccepterBankDataListPlugin.addChildren(group, fieldKey);
        return group;
    }

    private HashMap<String, String> createDraftBillColumnMap(String rpType) {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        if ("receivebill".equals(rpType)) {
            hashMap.put("accepterbank_finorg", ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u8d22\u53f8\u627f\u5151", (String)"DraftBillAmountDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
            hashMap.put("accepterbank_bizbill", ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e-\u5546\u4e1a\u627f\u5151", (String)"DraftBillAmountDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]));
            hashMap.put("accepterbank_total", ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u53d1\u751f\u989d\u5408\u8ba1", (String)"DraftBillAmtAccepterBankDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        } else {
            hashMap.put("accepterbank_finorg", ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u8d22\u53f8\u627f\u5151", (String)"DraftBillAmountDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
            hashMap.put("accepterbank_bizbill", ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e-\u5546\u4e1a\u627f\u5151", (String)"DraftBillAmountDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]));
            hashMap.put("accepterbank_total", ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u53d1\u751f\u989d\u5408\u8ba1", (String)"DraftBillAmtAccepterBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        return hashMap;
    }

    private static void addChildren(ReportColumnGroup group, String fieldKey) {
        DraftBillAmtAccepterBankDataListPlugin.buildReportColumn(group, fieldKey + AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvestReportDataHelper_0", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal");
        DraftBillAmtAccepterBankDataListPlugin.buildReportColumn(group, fieldKey + COUNT, ResManager.loadKDString((String)"\u7b14\u6570", (String)"DraftBillAmtAccepterBankDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "integer");
    }

    private static void buildReportColumn(ReportColumnGroup group, String fieldKey, String caption, String fieldType) {
        ReportColumn newCol = new ReportColumn();
        newCol.setHideSingleColumnRow(false);
        newCol.setFieldKey(fieldKey);
        newCol.setFieldType(fieldType);
        if ("decimal".equals(fieldType)) {
            newCol.setScale(2);
        }
        newCol.setZeroShow(true);
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign("right");
        newCol.setStyle(style);
        newCol.setCaption(new LocaleString(caption));
        group.getChildren().add(newCol);
    }
}

