/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class BillSpreadFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ORGID = "orgid";
    private static final String RPT_TYPE = "rptype";
    private static final String RECEIVE_BILL = "receivebill";
    private static final String FILTER = "filter";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        this.addItemClickListeners(new String[]{"toolbarap"});
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String type = this.getRptType();
        queryParam.getFilter().addFilterItem(RPT_TYPE, (Object)type);
        queryParam.getFilter().addFilterItem("orgViewNumber", (Object)this.getPageCache().get("orgViewNumber"));
        return super.verifyQuery(queryParam);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_showdetail".equals(key)) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Long orgId = Long.valueOf((String)formShowParameter.getCustomParam(ORGID));
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                Pair pluginPair = (Pair)pluginInfo.get("plugin");
                param.setCaption((String)pluginPair.getValue1());
            }
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String formId;
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        ReportList rptList = (ReportList)hyperLinkClickEvent.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String orgId = row.getString("rowid");
        if ("0".equals(orgId)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        HashMap commFilters = new HashMap();
        ReportShowParameter param = new ReportShowParameter();
        Map customParams = param.getCustomParams();
        customParams.put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        customParams.put(ORGID, orgId);
        customParams.put("orgViewNumber", this.getPageCache().get("orgViewNumber"));
        customParams.put("commFilters", SerializationUtils.serializeToBase64(commFilters));
        String type = this.getRptType();
        customParams.put(RPT_TYPE, type);
        if (RECEIVE_BILL.equals(type)) {
            formId = "tda_receivebillrpt";
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u671f\u9650\u5206\u5e03\u8868", (String)"ReceiveBillSpreadQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        } else {
            formId = "tda_paybillperiodrpt";
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u671f\u9650\u5206\u5e03\u8868", (String)"PayBillSpreadQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        customParams.put("next", true);
        param.setFormId(formId);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    private String getRptType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)customParams.get(RPT_TYPE);
        if (StringUtil.isEmpty((String)type)) {
            type = RECEIVE_BILL;
        }
        return type;
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        DynamicObject rowData = evt.getRowData();
        String isGroupNode = rowData.getString("isgroupnode");
        Object formatValue = evt.getFormatValue();
        if (formatValue != null && !"1".equals(isGroupNode)) {
            evt.getNoLinkKey().add(((ReportColumn)evt.getSource()).getFieldKey());
        }
    }
}

