/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LetterCreditFormListPlugin
extends AbstractReportFormPlugin {
    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String dateRange = (String)customParams.get("dateRange");
        queryParam.getFilter().addFilterItem("dateRange", (Object)dateRange);
        queryParam.getFilter().addFilterItem("orgViewNumber", (Object)this.getPageCache().get("orgViewNumber"));
        return super.verifyQuery(queryParam);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            String spotRatio = row.getString("spotratio");
            BigDecimal bigSpotRatio = EmptyUtil.isEmpty((String)spotRatio) ? BigDecimal.ZERO : new BigDecimal(spotRatio);
            row.set("spotratio", (Object)(bigSpotRatio.setScale(2, RoundingMode.HALF_UP) + "%"));
            String farRatio = row.getString("farratio");
            BigDecimal farSpotRatio = EmptyUtil.isEmpty((String)farRatio) ? BigDecimal.ZERO : new BigDecimal(farRatio);
            row.set("farratio", (Object)(farSpotRatio.setScale(2, RoundingMode.HALF_UP) + "%"));
        }
    }
}

