/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class DraftbillSecondHelper {
    public static final String COMPANYID = "companyid";
    public static final String ORGID = "orgid";
    public static final String AMOUNT = "amount";
    public static final String COUNT = "count";
    private static final int DAYLIMIT = 10;
    public static final String ROWID = "rowid";

    private DraftbillSecondHelper() {
    }

    public static DataSet getQingReportdata(Map<String, Object> paramMap) {
        Long orgViewid = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currentOrgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewid, Collections.singletonList(orgId), (boolean)true);
        String rptype = (String)paramMap.get("rptype");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet groupByOrgData = DraftBillDataHelper.getBillBalanceDataSet((String)(DraftbillSecondHelper.class.getName() + "_qing"), (List)allorgids, (Date)DecisionAnlsHelper.getQueryDate(paramMap), (Long)baseCurrency, (Long)orgViewid, (String)rptype);
        groupByOrgData = groupByOrgData.addField(ORGID, COMPANYID).groupBy(new String[]{COMPANYID}).sum(AMOUNT).finish();
        DataSet allOrgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewid);
        List<String> fieldList = DraftbillSecondHelper.getFieldList();
        fieldList.add(AMOUNT);
        DataSet bussinessJoinOrg = allOrgDataSet.leftJoin(groupByOrgData).on(ROWID, COMPANYID).select(fieldList.toArray(new String[0])).finish();
        DataSet sumDataSetByLevel = DecisionAnlsHelper.getSumDataSetByLevel(bussinessJoinOrg, Collections.singletonList(AMOUNT), "companyid,companyname");
        List subOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewid, (Long)currentOrgId, (boolean)true);
        sumDataSetByLevel = CollectionUtils.isEmpty((Collection)subOrgIds) ? DecisionAnlsHelper.createEmptyDataSet(sumDataSetByLevel.getRowMeta().getFieldNames(), sumDataSetByLevel.getRowMeta().getDataTypes()) : sumDataSetByLevel.filter("companyid in orgidparam", Collections.singletonMap("orgidparam", subOrgIds)).filter("amount > 0");
        return sumDataSetByLevel.addField("0.0", "amountrate");
    }

    public static DataSet query(Map<String, Object> paramMap) {
        Long orgViewid = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewid, Collections.singletonList(orgId), (boolean)true);
        String rptype = (String)paramMap.get("rptype");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String name = DraftbillSecondHelper.class.getName();
        String selectField = "orgid companyid, amount, expiredate, billtype, draftbillcount as count";
        if (EmptyUtil.isEmpty((String)rptype)) {
            DataSet receive = DraftBillDataHelper.getBillBalanceDataSet((String)name, (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewid, (String)"receivebill");
            receive = receive.select(selectField);
            DataSet pay = DraftBillDataHelper.getBillBalanceDataSet((String)name, (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewid, (String)"paybill");
            pay = pay.select(selectField);
            return DraftbillSecondHelper.queryRptData(receive, queryDate, orgViewid).addField("'receivebill'", "rptype").union(DraftbillSecondHelper.queryRptData(pay, queryDate, orgViewid).addField("'paybill'", "rptype"));
        }
        DataSet allDs = DraftBillDataHelper.getBillBalanceDataSet((String)name, (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewid, (String)rptype);
        allDs = allDs.select(selectField);
        return DraftbillSecondHelper.queryRptData(allDs, queryDate, orgViewid).addField("'" + rptype + "'", "rptype");
    }

    public static DataSet queryRptData(DataSet allOrgBillData, Date queryDate, Long orgViewId) {
        Date endDate = DateUtils.getNextDay((Date)queryDate, (int)10);
        String sqlFilterStr = "expiredate <= to_date('" + DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss") + "','yyyy-MM-dd')";
        allOrgBillData = allOrgBillData.select("count, companyid, case when billtype = '6' and " + sqlFilterStr + " then amount else 0 end banktenamount ,case when billtype = '6' and " + sqlFilterStr + " then count else 0 end banktenqty ,case when billtype = '20' and " + sqlFilterStr + " then amount else 0 end fintenamount ,case when billtype = '20' and " + sqlFilterStr + " then count else 0 end fintenqty ,case when billtype = '5' and " + sqlFilterStr + " then amount else 0 end busstenmount ,case when billtype = '5' and " + sqlFilterStr + " then count else 0 end busstenqty, case when billtype = '6' then amount else 0 end bankreceivableamount, case when billtype = '6' then count else 0 end bankreceivableqty, case when billtype = '20' then amount else 0 end finreceivableamount, case when billtype = '20' then count else 0 end finreceivableqty, case when billtype = '5' then amount else 0 end bussreceivableamount, case when billtype = '5' then count else 0 end bussreceivableqty, " + AMOUNT).groupBy(new String[]{COMPANYID}).sum("banktenamount").sum("banktenqty").sum("fintenamount").sum("fintenqty").sum("busstenmount").sum("busstenqty").sum("bankreceivableamount").sum("bankreceivableqty").sum("finreceivableamount").sum("finreceivableqty").sum("bussreceivableamount").sum("bussreceivableqty").sum(AMOUNT, "receivableamountsum").sum(COUNT, "receivableqtysum").finish();
        List<String> reportCommonCol = DraftbillSecondHelper.getReportCommonCol();
        reportCommonCol.addAll(DraftbillSecondHelper.getReportTenDayCol());
        reportCommonCol.addAll(DraftbillSecondHelper.getFieldList());
        reportCommonCol.add("sortcode");
        DataSet allOrgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        allOrgBillData = allOrgDateSet.leftJoin(allOrgBillData).on(ROWID, COMPANYID).select(reportCommonCol.toArray(new String[0])).finish();
        List<String> resultCol = DraftbillSecondHelper.getReportCommonCol();
        resultCol.addAll(DraftbillSecondHelper.getReportTenDayCol());
        return DecisionAnlsHelper.getSumDataSetByLevel(allOrgBillData, resultCol, "sortcode, companyid, companyname, companyid orgid").addFields(new String[]{"case when receivableamountsum = 0 or bankreceivableamount = 0 then 0 else bankreceivableamount/receivableamountsum end", "case when receivableamountsum = 0 or finreceivableamount = 0 then 0 else finreceivableamount/receivableamountsum end", "case when receivableamountsum = 0 or bussreceivableamount = 0 then 0 else bussreceivableamount/receivableamountsum end", "''", "''", "''"}, new String[]{"bankrate", "finrate", "bussrate", "bankratestr", "finratestr", "bussratestr"});
    }

    public static List<String> getReportCommonCol() {
        ArrayList<String> reportCol = new ArrayList<String>(8);
        reportCol.add("bankreceivableamount");
        reportCol.add("bankreceivableqty");
        reportCol.add("finreceivableamount");
        reportCol.add("finreceivableqty");
        reportCol.add("bussreceivableamount");
        reportCol.add("bussreceivableqty");
        reportCol.add("receivableamountsum");
        reportCol.add("receivableqtysum");
        return reportCol;
    }

    public static List<String> getReportTenDayCol() {
        ArrayList<String> reportCol = new ArrayList<String>(8);
        reportCol.add("banktenamount");
        reportCol.add("banktenqty");
        reportCol.add("fintenamount");
        reportCol.add("fintenqty");
        reportCol.add("busstenmount");
        reportCol.add("busstenqty");
        return reportCol;
    }

    private static List<String> getFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(8);
        fieldList.add("org companyid");
        fieldList.add(ORGID);
        fieldList.add(ROWID);
        fieldList.add("mixorgname companyname");
        fieldList.add("isgroupnode");
        fieldList.add("level");
        fieldList.add("pid");
        fieldList.add("0 as sumlevel");
        return fieldList;
    }
}

