/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.qing;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.RecPayBillTypeEnum;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.note.helper.DraftBillAmountHelper;

public abstract class AbstractDraftBillAmountDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String BILL_TYPE = "billtype";
    private static final String TERM_TYPE = "termtype";
    private static final String TERM = "term";
    private static final String AMOUNT = "amount";
    private static final String CLICK = "click";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{BILL_TYPE, ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b", (String)"AbstractDraftBillAmountDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{TERM_TYPE, ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b", (String)"AbstractDraftBillAmountDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{TERM, ResManager.loadKDString((String)"\u533a\u95f4", (String)"AbstractDraftBillAmountDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{"count", ResManager.loadKDString((String)"\u7b14\u6570", (String)"AbstractDraftBillAmountDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"AbstractDraftBillAmountDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{CLICK, ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"AbstractDraftBillAmountDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{"sort", ResManager.loadKDString((String)"\u6392\u5e8f\u5e8f\u53f7", (String)"AbstractDraftBillAmountDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        String rpType = this.getRpType();
        DataSet allDS = DraftBillDataHelper.getBillAccruedDataSet((String)this.createAlgoKey(""), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (String)rpType);
        String needField = "billtype, rptype, amount, registereddate, issuedate, draftbillcount as count";
        allDS = allDS.select(needField);
        DataSet termDs = DraftBillAmountHelper.getTermData(allDS, queryDate, rpType, null, null).select(new String[]{BILL_TYPE, "customtype as termtype", TERM, "count", AMOUNT});
        return termDs.groupBy(new String[]{BILL_TYPE, TERM_TYPE, TERM}).sum("count").sum(AMOUNT).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta()).addFields(new String[]{"0", "''"}, new String[]{"sort", CLICK});
        }
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)TERM_TYPE, (String)TERM);
        String termType = (String)typeLinkValue.getValue0();
        String term = (String)typeLinkValue.getValue1();
        if (EmptyUtil.isNoEmpty((String)termType) && EmptyUtil.isNoEmpty((String)term)) {
            String filter = "termtype = '" + termType + "' and " + TERM + " = '" + term + "'";
            ds = ds.filter(filter);
        }
        ds = DecisionAnlsHelper.creatAbsentRow(ds, BILL_TYPE, Arrays.asList("5", "6", "20"), 0, () -> new Object[]{"''", termType, term, 0, 0.0});
        String sortExpr = "case when billtype = '6' then 1 when billtype = '20' then 2 else 3 end as sort";
        String clickExpr = "concat(termtype,'_',term)";
        return ds.addFields(new String[]{sortExpr, clickExpr}, new String[]{"sort", CLICK});
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList(this.getLinkRptFormId());
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CLICK;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(CLICK, ids.get(0));
        param.setFormId(this.getLinkRptFormId());
        this.fireLinkageShowForm(view, param);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.getCustomParams().put(CLICK, paramMap.get(TERM_TYPE) + "_" + paramMap.get(TERM));
    }

    private DataSet dealEmptyBillTypeRowForRpType(DataSet resultDs, List<String> billTypes) {
        resultDs = resultDs.filter("billtype in billTypes", Collections.singletonMap("billTypes", billTypes));
        for (String billType : billTypes) {
            if (!resultDs.copy().filter("billtype = '" + billType + "'").isEmpty()) continue;
            RowMeta rowMeta = resultDs.getRowMeta();
            DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{billType, 0, 0.0}));
            resultDs = resultDs.union(bizDs);
        }
        return resultDs;
    }

    @Override
    protected Object translateCellDisplay(String field, Object value, Row rs) {
        if (BILL_TYPE.equals(field)) {
            RecPayBillTypeEnum typeEnum = RecPayBillTypeEnum.getByCode((String)((String)value));
            value = typeEnum != null ? typeEnum.getName() : ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AbstractFinDebtDistDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        return super.translateCellDisplay(field, value, rs);
    }

    protected abstract String getRpType();

    protected abstract String getLinkRptFormId();
}

